package com.elitesland.scp.application.service.export;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightExportRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.service.feedback.ScpStoreFeedbackService;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpStoreFeedbackServiceExportImpl implements DataExport<ScpStoreFeedbackRespVO, ScpStoreFeedbackQueryParamVO>{
    private final ScpStoreFeedbackService scpStoreFeedbackService;

    @Override
    public String getTmplCode() {
        return "scp_store_feedback_export";
    }

    @Override
    public PagingVO<ScpStoreFeedbackRespVO> executeExport(ScpStoreFeedbackQueryParamVO queryParam) {
        return scpStoreFeedbackService.searchByPc(queryParam);
    }

    @Override
    public Integer pageSize() {
        return 100;
    }
}
