package com.elitesland.scp.application.service.freight;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.freight.*;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.domain.entity.freight.ScpStoreOrderFreightDO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 门店订单运费服务
 * @author Rikyon
 * @version 1.0
 * @Create 2025/8/13
 */
@Service
public interface ScpStoreOrderFreightService {
    ScpStoreOrderFreightDO saveStoreOrderFreight(ScpStoreOrderFreightSaveParamVO param);
    List<ScpStoreOrderFreightDO> saveAllStoreOrderFreight(List<ScpStoreOrderFreightSaveParamVO> scpStoreOrderFreightSaveParamVOS);
    void deleteStoreOrderFreight(Long id);
    PagingVO<ScpStoreOrderFreightPageRespVO> pageStoreOrderFreight(ScpStoreOrderFreightPageParamVO param);
    /**
     * 获取商品明细行信息
     *
     * @param paramVO
     */
    List<ScpStoreOrderFreightPageRespVO> listStoreOrderFreight(ScpStoreOrderFreightPageParamVO paramVO);

    ScpStoreOrderFreightQuaryRespVO freightBatchQuery(ScpStoreOrderFreightQuaryParamVO param);
    List<ScpStoreOrderFreightQuaryRespVO> freightBatchQueryAll(List<ScpStoreOrderFreightQuaryParamVO> param);
    ScpStoreOrderFreightRespVO getStoreOrderFreightDetail(Long id);

    List<String> executeImport(List<ScpStoreOrderFreightImportVO> scpStoreOrderFreightImportVOList, int startRowIndex);
    PagingVO<ScpStoreOrderFreightExportRespVO> exportSearch(ScpStoreOrderFreightPageParamVO queryParam);
}
