package com.elitesland.scp.application.web.calendar;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 门店订货日历 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2024-03-28
 */
@RestController
@RequestMapping(value = "/scp/storeCalendar", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "门店订货日历管理接口", tags = {"门店订货日历管理接口"})
@AllArgsConstructor
public class ScpStoreDemandCalendarController {

    private final ScpStoreDemandCalendarService  scpStoreDemandCalendarService;



    @PostMapping("/save")
    @ApiOperation("门店订货日历-新增/编辑")
    public ApiResult saveStoreCalendar(@RequestBody ScpStoreDemandCalendarSaveVO createParam) {
        scpStoreDemandCalendarService.saveStoreCalendar(createParam);
        return ApiResult.ok();
    }


    @PostMapping("/page")
    @ApiOperation("门店订货日历-列表")
    public ApiResult<PagingVO<ScpStoreDemandCalendarPageVO>> searchPage(@RequestBody ScpStoreDemandCalendarPageParamVO queryParam) {
        return ApiResult.ok(scpStoreDemandCalendarService.searchPage(queryParam));
    }


    @PostMapping("/delete")
    @ApiOperation("门店订货日历-删除")
    public ApiResult deleteStoreCalendar(@RequestBody @Valid List<ScpStoreDemandCalendarParamVO> param) {
        scpStoreDemandCalendarService.deleteStoreCalendar(param);
        return ApiResult.ok();
    }

    @PostMapping("/detail")
    @ApiOperation("门店订货日历-详情")
    public ApiResult findStoreCalendarDetail(@RequestBody ScpStoreDemandCalendarParamVO param) {
        return ApiResult.ok(scpStoreDemandCalendarService.findStoreCalendarDetail(param));
    }

    @PostMapping("/listStore")
    @ApiOperation("日历门店信息-查询")
    public ApiResult<List<ScpCalendarStoreRespVO>> listCalendarStoreByParam(@RequestBody @Valid ScpCalendarStoreQueryParamVO param){
        return ApiResult.ok(scpStoreDemandCalendarService.listCalendarStoreByParam(param));
    }



}
