package com.elitesland.scp.domain.convert.alloc;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.infr.dto.alloc.ScpAllocSettingDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * @Author: ryan.xu
 * @since 2024/07/12
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpAllocSettingConvert {
    ScpAllocSettingConvert INSTANCE = Mappers.getMapper(ScpAllocSettingConvert.class);

    ScpAllocSettingRespVO dtoToRespVO(ScpAllocSettingDTO settingDTO);

    ScpAllocSettingDTO doToDto(ScpAllocSettingDO settingDO);

    ScpAllocSettingDO saveVoToDO(ScpAllocSettingSaveVO saveVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpAllocSettingSaveVO saveVO, @MappingTarget ScpAllocSettingDO settingDO);

}
