package com.elitesland.scp.domain.entity.order;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;

@Entity
@Table(name = "scp_order_template")
@org.hibernate.annotations.Table(appliesTo = "scp_order_template", comment = "订货集模板")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货集模板", description = "订货集模板")
@Where(clause = "delete_flag = 0")
public class ScpOrderTemplateDO extends BaseModel implements Serializable {
    @ApiModelProperty("模板类型")
    @Comment("模板类型")
    @Column(name = "type", columnDefinition = "VARCHAR(50) comment '模板类型'")
    private String type;

    @ApiModelProperty("单据类型")
    @Comment("单据类型")
    @Column(name = "doc_type", columnDefinition = "VARCHAR(50) comment '单据类型'")
    private String docType;

    @ApiModelProperty("应用门店代码")
    @Comment("应用门店代码")
    @Column(name = "store_code", columnDefinition = "VARCHAR(50) comment '应用门店代码'")
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    @Comment("应用门店名称")
    @Column(name = "store_name", columnDefinition = "VARCHAR(100) comment '应用门店名称'")
    private String storeName;

    @ApiModelProperty("所属区域")
    @Comment("所属区域")
    @Column(name = "region_code", columnDefinition = "VARCHAR(50) comment '所属区域'")
    private String regionCode;

    @ApiModelProperty("订单截至时间点")
    @Comment("订单截至时间点")
    @Column(name = "deadline_time_point", columnDefinition = "DATETIME comment '订单截至时间点'")
    private LocalTime deadlineTime;

    @ApiModelProperty("开始日期")
    @Comment("开始日期")
    @Column(name = "start_date", columnDefinition = "DATE comment '开始日期'")
    private LocalDate startDate;

    @ApiModelProperty("结束日期")
    @Comment("结束日期")
    @Column(name = "end_date", columnDefinition = "DATE comment '结束日期'")
    private LocalDate endDate;

    @ApiModelProperty("是否启用")
    @Comment("是否启用")
    @Column(name = "is_active", columnDefinition = "tinyint comment '是否启用'")
    private Integer isActive;
}
