package com.elitesland.scp.domain.entity.storereceive;

import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "scp_store_receive_d")
@org.hibernate.annotations.Table(appliesTo = "scp_store_receive_d", comment = "门店收/退货明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class StoreReceiveDDO extends BaseModel implements Serializable {

    @Comment("主表id")
    @Column()
    private Long masId;

    @Comment("明细id")
    @Column()
    private Long did;

    @Comment("商品id")
    @Column()
    private Long itemId;

    @Comment("单价")
    @Column()
    private BigDecimal price;

    @Comment("计划数量")
    @Column()
    private BigDecimal qty;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;
}
