package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.order.param.SalSoSaveDTO;
import com.elitesland.order.service.SalSoRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiOrderRpcService {
    private final SalSoRpcService salSoRpcService;

    /**
     * 创建销售订单
     *
     * @param salSoSaveDTO
     */
    public void createSalSo(SalSoSaveDTO salSoSaveDTO) {
        ApiResult<Long> outerOrder = salSoRpcService.createOuterOrder(salSoSaveDTO);
        if (!outerOrder.isSuccess()) {
            log.error("推送销售订单:{}", outerOrder.getMsg());
            throw new BusinessException("推送销售订单:" + outerOrder.getMsg());
        }
    }

}
