package com.elitesland.scp.utils.excel;

import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import lombok.AllArgsConstructor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;



/**
 * @author jeesie
 * @description:
 * @datetime 2025年 01月 20日 17:31
 * @version: 1.0
 */
@AllArgsConstructor
public class AliasRowWriteHandle implements RowWriteHandler {

    @Override
    public void beforeRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Integer rowIndex, Integer relativeRowIndex, Boolean isHead){
        if (relativeRowIndex == 1) {
            Sheet sheet = writeSheetHolder.getSheet();
            Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
            Row aliasRow = sheet.createRow(1);

            // 创建单元格并设置别名
            org.apache.poi.ss.usermodel.Cell cell = aliasRow.createCell(0);
            cell.setCellValue("ouCode");

            // 可以根据需要设置其他单元格的别名
            // 例如，如果需要在第二列插入别名
            cell = aliasRow.createCell(1);
            cell.setCellValue("ouName");

            cell = aliasRow.createCell(2);
            cell.setCellValue("whCode");

            cell = aliasRow.createCell(3);
            cell.setCellValue("whName");

            cell = aliasRow.createCell(4);
            cell.setCellValue("itemCode");

            cell = aliasRow.createCell(5);
            cell.setCellValue("itemName");


            cell = aliasRow.createCell(6);
            cell.setCellValue("safetyQty");

            cell = aliasRow.createCell(7);
            cell.setCellValue("targetQty");

            cell = aliasRow.createCell(8);
            cell.setCellValue("planUom");

            cell = aliasRow.createCell(9);
            cell.setCellValue("planUomName");

            // 设置样式（可选）
            // CellStyle style = workbook.createCellStyle();
            // cell.setCellStyle(style);
        }
    }

    @Override
    public void afterRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {

    }

    @Override
    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {

    }


}
