package com.elitesland.scp.job.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.job.service.ScpDemandOrderCloseJobService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "订货单延时关闭定时任务接口")
@RestController
@RequestMapping(value = "/job/order", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpDemandOrderCloseJobController {

    private final ScpDemandOrderCloseJobService scpDemandOrderCloseJobService;

    @ApiOperation("订货单延时关闭")
    @PostMapping("/close")
    public ApiResult<String> autoCloseDemandOrder() {
        scpDemandOrderCloseJobService.autoCloseDemandOrder();
        return ApiResult.ok();
    }
}
