/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAddItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDelParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderDServiceImpl
implements ScpDemandOrderDService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDServiceImpl.class);
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RedisTemplate redisClient;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDMgmtRespVO> findDemandOrderDByMasId(Long masId) {
        List<ScpDemandOrderDDTO> itemList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(masId);
        if (CollUtil.isEmpty(itemList)) {
            return Collections.emptyList();
        }
        Map<String, String> docClsMap = this.rmiSysUDCService.getCodeMap("yst-supp", "DOC_CLS");
        Map<String, String> payStatusMap = this.rmiSysUDCService.getCodeMap(ScpUdcEnum.PAY_STATUS_NO_PAY.getModel(), ScpUdcEnum.PAY_STATUS_WAIT_PAY.getCode());
        Map<String, String> suppTypeMap = this.rmiSysUDCService.getCodeMap(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getModel(), ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getCode());
        ArrayList<ScpDemandOrderDMgmtRespVO> mgmtRespVOS = new ArrayList<ScpDemandOrderDMgmtRespVO>();
        Map<Long, List<ScpDemandOrderDDTO>> soureIdMap = itemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSourceId));
        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : soureIdMap.entrySet()) {
            List<ScpDemandOrderDMgmtRespVO.SupplyItem> supplyItems = entry.getValue().stream().map(row -> {
                ScpDemandOrderDMgmtRespVO.SupplyItem supplyItem = ScpDemandOrderDConvert.INSTANCE.dtoToSupplyItem((ScpDemandOrderDDTO)row);
                supplyItem.setSupplyTypeName((String)suppTypeMap.get(supplyItem.getSupplyType()));
                if (payStatusMap.containsKey(row.getPayStatus())) {
                    supplyItem.setPayStatusName((String)payStatusMap.get(row.getPayStatus()));
                }
                if (docClsMap.containsKey(row.getSrcDocCls())) {
                    supplyItem.setSrcDocClsName((String)docClsMap.get(row.getSrcDocCls()));
                }
                return supplyItem;
            }).collect(Collectors.toList());
            ScpDemandOrderDMgmtRespVO mgmtRespVO = ScpDemandOrderDConvert.INSTANCE.dtoToMgmtRespVO(entry.getValue().get(0));
            mgmtRespVO.setItemList(supplyItems);
            mgmtRespVOS.add(mgmtRespVO);
        }
        return mgmtRespVOS.stream().sorted(Comparator.comparing(ScpDemandOrderDMgmtRespVO::getFreightLineFlag)).collect(Collectors.toList());
    }

    @Override
    public void batchSaveDemandOrderDMgmt(Long masId, List<ScpDemandOrderDMgmtSaveVO> saveVOS) {
        List<ScpDemandOrderDSaveVO> batchSaveVOS = saveVOS.stream().filter(row -> row.getFreightLineFlag() == false).flatMap(entity -> {
            String uuid = UUIDUtil.getUUID();
            return entity.getItemList().stream().map(listItem -> {
                ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = ScpDemandOrderDConvert.INSTANCE.mgmtSaveVoToSaveVo((ScpDemandOrderDMgmtSaveVO.SupplyItem)listItem);
                scpDemandOrderDSaveVO.setMasId(entity.getMasId());
                scpDemandOrderDSaveVO.setSourceId(entity.getSourceId());
                scpDemandOrderDSaveVO.setSpuItemCode(entity.getSpuItemCode());
                scpDemandOrderDSaveVO.setSpuItemName(entity.getSpuItemName());
                scpDemandOrderDSaveVO.setItemId(entity.getItemId());
                scpDemandOrderDSaveVO.setItemCode(entity.getItemCode());
                scpDemandOrderDSaveVO.setItemName(entity.getItemName());
                scpDemandOrderDSaveVO.setDemandQuantity(entity.getDemandQuantity());
                scpDemandOrderDSaveVO.setPrice(listItem.getPrice());
                scpDemandOrderDSaveVO.setCurrency(entity.getCurrency());
                scpDemandOrderDSaveVO.setRemark(entity.getRemark());
                scpDemandOrderDSaveVO.setPreRootUuid(uuid);
                scpDemandOrderDSaveVO.setUnit(listItem.getUnit());
                scpDemandOrderDSaveVO.setUnitName(listItem.getUnitName());
                scpDemandOrderDSaveVO.setUom2(listItem.getUom2());
                scpDemandOrderDSaveVO.setUom2Name(listItem.getUom2Name());
                scpDemandOrderDSaveVO.setUomRatio(listItem.getUomRatio());
                scpDemandOrderDSaveVO.setDecimalPlaces(listItem.getDecimalPlaces());
                scpDemandOrderDSaveVO.setSaleOuCode(listItem.getSaleOuCode());
                scpDemandOrderDSaveVO.setSaleOuName(listItem.getSaleOuName());
                scpDemandOrderDSaveVO.setSaleCustCode(listItem.getSaleCustCode());
                scpDemandOrderDSaveVO.setImgUrl(listItem.getImgUrl());
                scpDemandOrderDSaveVO.setItemType(entity.getItemType());
                scpDemandOrderDSaveVO.setActivityId(entity.getActivityId());
                scpDemandOrderDSaveVO.setActivityCode(entity.getActivityCode());
                scpDemandOrderDSaveVO.setMinNum(entity.getMinNum());
                Long id = listItem.getId() == null || listItem.getId() < 0L ? null : listItem.getId();
                scpDemandOrderDSaveVO.setId(id);
                return scpDemandOrderDSaveVO;
            });
        }).collect(Collectors.toList());
        this.batchSaveDemandOrderD(masId, batchSaveVOS);
        List<Long> activitys = batchSaveVOS.stream().map(ScpDemandOrderDSaveVO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activitys)) {
            Optional<ScpDemandOrderDTO> demandOrderById = this.scpDemandOrderDomainService.findDemandOrderById(masId);
            ScpDemandOrderDTO scpDemandOrderDTO = demandOrderById.get();
            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setStoreCode(scpDemandOrderDTO.getDemandWhStCode());
            scpAllocSettingStoreParamVO.setMasIds(activitys);
            List<ScpAllocSettingStoreRespVO> settingStoreList = this.scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            for (ScpAllocSettingStoreRespVO storeRespVO : settingStoreList) {
                if (storeRespVO.getAllocNum() + 1 < storeRespVO.getMaxNum()) continue;
                this.redisClient.delete((Object)("SCP:ALLOC:SETTING:" + scpDemandOrderDTO.getDemandWhStCode()));
            }
            this.scpAllocSettingStoreDomainService.updateAllocNumByParam(activitys, scpDemandOrderDTO.getDemandWhStCode());
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderDRespVO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO) {
        Page<ScpDemandOrderDDO> page = this.scpDemandOrderDDomainService.pageDemandOrderDByMasId(paramVO);
        List records = page.getContent();
        List<ScpDemandOrderDRespVO> scpDemandOrderDRespVOS = ScpDemandOrderDConvert.INSTANCE.doToRespVO(records);
        ItmItemScpBaseRpcParam itmItemRpcDtoParam = new ItmItemScpBaseRpcParam();
        itmItemRpcDtoParam.setItemIds(scpDemandOrderDRespVOS.stream().map(ScpDemandOrderDRespVO::getItemId).collect(Collectors.toList()));
        Map itemMap = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemRpcDtoParam).stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        Map<String, String> uomCodeMap = this.rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        List<ScpDemandOrderDDO> byMasIdAndCombineItemCodeIsNotNull = this.scpDemandOrderDDomainService.findByMasIdAndCombineItemCodeIsNotNull(paramVO);
        List<ScpDemandOrderDRespVO> subScpDemandOrderDRespVOS = ScpDemandOrderDConvert.INSTANCE.doToRespVO(byMasIdAndCombineItemCodeIsNotNull);
        ArrayList<ScpDemandOrderDRespVO> result = new ArrayList<ScpDemandOrderDRespVO>();
        if (CollUtil.isNotEmpty(subScpDemandOrderDRespVOS)) {
            Map<String, List<ScpDemandOrderDRespVO>> collect = subScpDemandOrderDRespVOS.stream().collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getCombineItemCode));
            ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
            param.setItemCodes(new ArrayList<String>(collect.keySet()));
            List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
            collect.forEach((k, v) -> {
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = new ScpDemandOrderDRespVO();
                scpDemandOrderDRespVO.setItemCode((String)k);
                Optional<ItmItemScpBaseRpcDTO> mainItem = itemRpcDtoByParam.stream().filter(row -> k.equals(row.getItemCode())).findFirst();
                mainItem.ifPresent(row -> {
                    scpDemandOrderDRespVO.setUnit(row.getUom2());
                    if (CollUtil.isNotEmpty((Collection)row.getSkuAttchmentList())) {
                        first = row.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        String url = first.isPresent() ? first.get().getUrl() : ((ItmItemAttachmentRpcDTO)row.getSkuAttchmentList().get(0)).getUrl();
                        scpDemandOrderDRespVO.setUrl(url);
                    } else if (CollUtil.isNotEmpty((Collection)row.getSpuAttchmentList())) {
                        first = row.getSpuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        scpDemandOrderDRespVO.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)row.getSpuAttchmentList().get(0)).getUrl() : first.get().getUrl());
                    }
                    scpDemandOrderDRespVO.setItemAttrName(row.getItemAttrName());
                    scpDemandOrderDRespVO.setAnotherName(row.getAnotherName());
                    scpDemandOrderDRespVO.setItemName(row.getItemName());
                    scpDemandOrderDRespVO.setPlanAmt(v.stream().map(ScpDemandOrderDRespVO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)row.getSubItems().get(0);
                    v.stream().filter(a -> a.getItemId().equals(itmItemScpBaseRpcDTO.getId())).findFirst().ifPresent(b -> {
                        BigDecimal divide = b.getPlanQuantity().divide(itmItemScpBaseRpcDTO.getBomQty(), 0, RoundingMode.FLOOR);
                        scpDemandOrderDRespVO.setPlanQuantity(divide);
                        scpDemandOrderDRespVO.setAllocationDeQuantity(divide);
                    });
                });
                scpDemandOrderDRespVO.setUnitName((String)uomCodeMap.get(scpDemandOrderDRespVO.getUnit()));
                v.forEach(d -> {
                    if (mainItem.isEmpty()) {
                        return;
                    }
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO1 = (ItmItemScpBaseRpcDTO)mainItem.get();
                    List subItems = itmItemScpBaseRpcDTO1.getSubItems().stream().filter(a -> a.getId().equals(d.getItemId())).collect(Collectors.toList());
                    if (CollUtil.isEmpty(subItems)) {
                        return;
                    }
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)subItems.get(0);
                    d.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemScpBaseRpcDTO.getItemAttrName()) ? itmItemScpBaseRpcDTO.getSpec() : itmItemScpBaseRpcDTO.getItemAttrName());
                    d.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    d.setItemName(itmItemScpBaseRpcDTO.getItemName());
                    d.setUnitName((String)uomCodeMap.get(d.getUnit()));
                    List skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
                    List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                        Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        d.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                    } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                        Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        d.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                    }
                });
                scpDemandOrderDRespVO.setSubItems((List<ScpDemandOrderDRespVO>)v);
                result.add(scpDemandOrderDRespVO);
            });
        }
        scpDemandOrderDRespVOS.forEach(d -> {
            if (!itemMap.containsKey(d.getItemId())) {
                return;
            }
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)itemMap.get(d.getItemId());
            d.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemScpBaseRpcDTO.getItemAttrName()) ? itmItemScpBaseRpcDTO.getSpec() : itmItemScpBaseRpcDTO.getItemAttrName());
            d.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
            d.setItemName(itmItemScpBaseRpcDTO.getItemName());
            d.setUnitName((String)uomCodeMap.get(d.getUnit()));
            List skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                d.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                d.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            }
        });
        result.addAll(scpDemandOrderDRespVOS.subList(0, scpDemandOrderDRespVOS.size() - result.size()));
        return PagingVO.builder().records(result).total(page.getTotalElements()).build();
    }

    @Override
    public void remove(Long id) {
        List<ScpDemandOrderDDTO> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(id));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u8ba1\u7b97\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (row.getIsPushed().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u63a8\u9001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.scpDemandOrderDDomainService.deleteByIds(Arrays.asList(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDemandOrderD(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS) {
        List<ScpDemandOrderDSaveVO> modifyDetails = saveVOS.stream().filter(row -> row.getIsPushed() == false).collect(Collectors.toList());
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        this.scpDemandOrderDDomainService.deleteUnPushedItem(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        TimeInterval timer = new TimeInterval();
        modifyDetails.stream().collect(Collectors.groupingBy(ScpDemandOrderDSaveVO::groupByUuid)).forEach((id, list) -> ScpDemandOrderDServiceImpl.distributeDemandQty(list, masId, lineNo));
        log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6\uff0c\u5206\u914d\u8017\u65f6\uff1a{}", (Object)timer.intervalMs());
        this.checkStock(modifyDetails);
        this.scpDemandOrderDDomainService.batchSave(modifyDetails, lineNo, source);
        this.scpDemandOrderDomainService.updateAllocStatusAndPayStatusById(masId);
    }

    @Override
    public void saveDemandOrderD(ScpDemandOrderDSaveVO scpDemandOrderDSaveVO) {
        if (Boolean.TRUE.equals(scpDemandOrderDSaveVO.getIsCalculated())) {
            throw new BusinessException(ApiCode.FAIL, "\u6b64\u5546\u54c1\u5df2\u5206\u914d");
        }
        this.scpDemandOrderDDomainService.saveDemandOrderD(scpDemandOrderDSaveVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByParam(ScpDemandOrderDelParamVO paramVO) {
        List<Long> activityIds;
        Optional<ScpDemandOrderDTO> demandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(paramVO.getMasId());
        if (paramVO.getDId() == null) {
            List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_WT.getValueCode(), ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
            if (!docStatusList.contains(demandOrderDTO.get().getDocStatus())) {
                throw new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
            return;
        }
        List<ScpDemandOrderDDTO> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(paramVO.getDId()));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u8ba1\u7b97\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (row.getIsPushed().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u63a8\u9001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        List<Long> sourceIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getSourceId).distinct().collect(Collectors.toList());
        this.scpDemandOrderDDomainService.deleteBySourceIds(sourceIds);
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(paramVO.getMasId());
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            this.scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(activityIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            this.scpAllocSettingStoreDomainService.updateAllocNumByParam(activityIds, demandOrderDTO.get().getDemandWhStCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItem(Long masId, List<ScpDemandOrderAddItemParamVO> saveVOS) {
        Optional<ScpDemandOrderRespVO> demandOrderRespVO = this.scpDemandOrderService.findDemandOrderById(masId);
        if (demandOrderRespVO.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderRespVO scpDemandOrderRespVO = demandOrderRespVO.get();
        ArrayList<ScpDemandOrderDSaveVO> scpDemandOrderDSaveVOS = new ArrayList<ScpDemandOrderDSaveVO>();
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        saveVOS.forEach(row -> {
            ScpDemandOrderItemParamVO scpDemandOrderItemParamVO = new ScpDemandOrderItemParamVO();
            scpDemandOrderItemParamVO.setItemId(row.getItemId());
            scpDemandOrderItemParamVO.setItemCode(row.getItemCode());
            scpDemandOrderItemParamVO.setItemName(row.getItemName());
            scpDemandOrderItemParamVO.setSpuItemCode(row.getSpuItemCode());
            scpDemandOrderItemParamVO.setType(scpDemandOrderRespVO.getType());
            scpDemandOrderItemParamVO.setDemandWhStCode(scpDemandOrderRespVO.getDemandWhStCode());
            scpDemandOrderItemParamVO.setDemandDate(scpDemandOrderRespVO.getDemandDate());
            scpDemandOrderItemParamVO.setDemandQuantity(row.getDemandQuantity());
            scpDemandOrderItemParamVO.setUnit(row.getUom());
            scpDemandOrderItemParamVO.setUnitName(row.getUomName());
            scpDemandOrderItemParamVO.setSpuItemName(row.getSpuItemName());
            List<ScpDemandOrderDRespVO> itemList = this.scpDemandOrderService.getItemList(scpDemandOrderItemParamVO);
            List<ScpDemandOrderDSaveVO> intentionList = ScpDemandOrderDConvert.INSTANCE.respsVosToSaveVos(itemList);
            ScpDemandOrderDServiceImpl.distributeDemandQty(intentionList, masId, lineNo);
            scpDemandOrderDSaveVOS.addAll(intentionList);
        });
        this.scpDemandOrderDDomainService.batchSave(scpDemandOrderDSaveVOS, lineNo);
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDRespVO> findDemandOrderDBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId).stream().map(ScpDemandOrderDConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
    }

    private static void distributeDemandQty(List<ScpDemandOrderDSaveVO> list, Long masId, AtomicInteger index) {
        String orderSetting = SysUtils.getOrderSetting();
        for (int i = 0; i < list.size(); ++i) {
            ScpDemandOrderDSaveVO saveVO = list.get(i);
            saveVO.setLineNo(new BigDecimal(index.getAndIncrement()));
            saveVO.setMasId(masId);
            saveVO.setCurrency(StrUtil.isNotBlank((CharSequence)saveVO.getCurrency()) ? saveVO.getCurrency() : "CNY");
            if (!"1".equals(orderSetting)) continue;
            saveVO.setIsCalculated(Boolean.TRUE);
            saveVO.setPlanQuantity(saveVO.getAllocationDeQuantity());
            if (saveVO.getPrice() == null) continue;
            saveVO.setPrice(SysUtils.processPriceScale(saveVO.getPrice()));
            BigDecimal amt = saveVO.getPrice().multiply(saveVO.getPlanQuantity());
            saveVO.setPlanAmt(SysUtils.processAmtScale(amt));
        }
    }

    private void checkStock(List<ScpDemandOrderDSaveVO> saveVOList) {
        List itemIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || row.getFreightLineFlag() == false) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDSaveVO::getItemId).distinct().collect(Collectors.toList());
        List whIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || row.getFreightLineFlag() == false) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDSaveVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
            log.info("\u6821\u9a8c\u5e93\u5b58\u5546\u54c1\u6216\u8005\u4ed3\u5e93\u4e3a\u7a7a,\u65e0\u9700\u67e5\u8be2\u5e93\u5b58");
            return;
        }
        InvWhItemTotalStkRpcParam param = new InvWhItemTotalStkRpcParam();
        param.setWhIds(whIds);
        param.setItemIds(itemIds);
        param.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
        List<InvWhItemTotalStkRpcDTO> stkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(param);
        if (CollUtil.isEmpty(stkRpcDTOS)) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVOList.get(0).getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
        }
        Map<String, InvWhItemTotalStkRpcDTO> stkMap = stkRpcDTOS.stream().collect(Collectors.toMap(row -> row.getWhId() + "@" + row.getItemId(), Function.identity()));
        for (ScpDemandOrderDSaveVO saveVO : saveVOList) {
            if (saveVO.getFreightLineFlag() != null && saveVO.getFreightLineFlag().booleanValue() || !ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(saveVO.getSupplyType())) continue;
            this.checkStockAvailability(saveVO, stkMap);
        }
    }

    private void checkStockAvailability(ScpDemandOrderDSaveVO saveVO, Map<String, InvWhItemTotalStkRpcDTO> stkMap) {
        String key = saveVO.getSuppWhId() + "@" + saveVO.getItemId();
        InvWhItemTotalStkRpcDTO invWhItemTotalStkRpcDTO = stkMap.get(key);
        if (invWhItemTotalStkRpcDTO == null) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
        }
        BigDecimal avalQty = invWhItemTotalStkRpcDTO.getAvalQty();
        if (invWhItemTotalStkRpcDTO.getUomRatio() == null) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u8f85\u52a9\u5355\u4f4d\u8f6c\u6362\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saveVO.getPlanQuantity().multiply(invWhItemTotalStkRpcDTO.getUomRatio()).compareTo(avalQty) > 0) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u5e93\u5b58\u53ef\u7528\u91cf\u4e3a:" + invWhItemTotalStkRpcDTO.getAvalQty2() + ",\u4e0d\u53ef\u8d85\u8fc7\u8be5\u6570\u91cf");
        }
    }

    public ScpDemandOrderDServiceImpl(ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDomainService scpDemandOrderDomainService, RmiSysUDCService rmiSysUDCService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, RmiItemService rmiItemService, RmiInvStkRpcService rmiInvStkRpcService, RedisTemplate redisClient, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService) {
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.rmiItemService = rmiItemService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.redisClient = redisClient;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
    }
}

