/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.stock;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockImportVO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepo;
import com.elitesland.support.provider.item.dto.ItmItemSkuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemSkuBusinessRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ScpPredictStStockImportServiceImpl
implements DataImport<ScpPredictStStockImportVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpPredictStStockImportServiceImpl.class);
    private final InvWhProvider invWhProvider;
    private final ItmItemRpcService itemRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final ScpPredictStStockRepo scpPredictStStockRepo;

    public String getTmplCode() {
        return "predict_st_stock_import";
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<String> executeImport(List<ScpPredictStStockImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        HashMap errorMap = new HashMap();
        ArrayList<String> errorList = new ArrayList<String>();
        HashMap<CallSite, Integer> uniqueMap = new HashMap<CallSite, Integer>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            String uniqueKey;
            Integer ex;
            ScpPredictStStockImportVO importVO = dataList.get(i2);
            importVO.setLine(i2 + 1);
            errorMap.put(importVO.getLine(), new ArrayList());
            if (importVO.getStIdStr() == null) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u9884\u6d4b\u6279\u6b21ID]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                try {
                    importVO.setStId(Long.parseLong(importVO.getStIdStr()));
                }
                catch (Exception e) {
                    ((List)errorMap.get(importVO.getLine())).add("\u5217[\u9884\u6d4b\u6279\u6b21ID]\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            }
            if (!StringUtils.hasText((String)importVO.getOuCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importVO.getWhCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u4ed3\u5e93\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importVO.getItemCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importVO.getPlanUom())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u8ba1\u5212\u5355\u4f4d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((ex = (Integer)uniqueMap.get(uniqueKey = importVO.getStId().toString() + importVO.getOuCode() + importVO.getWhCode() + importVO.getItemCode())) != null) {
                ((List)errorMap.get(importVO.getLine())).add("\u540c\u6279\u6b21\uff0c\u5217[\u516c\u53f8\u7f16\u7801]-[\u4ed3\u5e93\u7f16\u7801]-[\u5546\u54c1\u7f16\u7801] \u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d,\u8bf7\u68c0\u67e5");
                ((List)errorMap.get(ex)).add("\u540c\u6279\u6b21\uff0c\u5217[\u516c\u53f8\u7f16\u7801]-[\u4ed3\u5e93\u7f16\u7801]-[\u5546\u54c1\u7f16\u7801] \u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
            } else {
                uniqueMap.put((CallSite)((Object)uniqueKey), i2);
            }
            if (importVO.getSafetyQty() == null) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u5b89\u5168\u5e93\u5b58]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (importVO.getTargetQty() != null) continue;
            ((List)errorMap.get(importVO.getLine())).add("\u5217[\u76ee\u6807\u5e93\u5b58]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        if (Boolean.TRUE.equals(this.getErrorResult(errorList))) {
            return errorList;
        }
        List<Long> stIds = dataList.stream().map(ScpPredictStStockImportVO::getStId).distinct().collect(Collectors.toList());
        List itemCodes = dataList.stream().map(ScpPredictStStockImportVO::getItemCode).distinct().collect(Collectors.toList());
        List ouCodes = dataList.stream().map(ScpPredictStStockImportVO::getOuCode).distinct().collect(Collectors.toList());
        List whCodes = dataList.stream().map(ScpPredictStStockImportVO::getWhCode).distinct().collect(Collectors.toList());
        ItmItemSkuBusinessRpcDtoParam itmItemRpcDtoParam = new ItmItemSkuBusinessRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List itemInfos = this.itemRpcService.findItemSkuBusinessByParam(itmItemRpcDtoParam);
        Map<String, ItmItemSkuBusinessRpcDTO> itemMap = itemInfos.stream().collect(Collectors.toMap(ItmItemSkuBusinessRpcDTO::getItemCode, i -> i, (o, n) -> n));
        List invWhRpcSimpleDTOS = (List)this.invWhProvider.findSimpleWhByWhCodes(whCodes).computeData();
        Map<String, InvWhRpcSimpleDTO> whMap = invWhRpcSimpleDTOS.stream().collect(Collectors.toMap(i -> i.getOuId() + i.getWhCode(), i -> i, (o, n) -> n));
        Map<String, InvWhRpcSimpleDTO> whCodeMap = invWhRpcSimpleDTOS.stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhCode, i -> i, (o, n) -> n));
        List simpleByOuCodes = this.orgOuRpcService.findSimpleByOuCodes(ouCodes);
        Map<String, OrgOuRpcSimpleDTO> ouMap = simpleByOuCodes.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, i -> i, (o, n) -> n));
        log.info("\u4ed3\u5e93\u5b57\u5178:{}", (Object)JSONUtil.toJsonStr(whCodeMap));
        List<ScpPredictStStockDO> predictStStockDOS = this.scpPredictStStockRepo.findAllByStIdIn(stIds);
        Map<String, List<ScpPredictStStockDO>> stStockMap = predictStStockDOS.stream().collect(Collectors.groupingBy(d -> d.getStId().toString() + d.getOuCode() + d.getWhCode() + d.getItemCode()));
        ArrayList<ScpPredictStStockDO> updates = new ArrayList<ScpPredictStStockDO>();
        for (ScpPredictStStockImportVO importVO : dataList) {
            String key = importVO.getStId().toString() + importVO.getOuCode() + importVO.getWhCode() + importVO.getItemCode();
            if (stStockMap.get(key) == null) {
                ((List)errorMap.get(importVO.getLine())).add("\u6570\u636e\u4e0d\u5b58\u5728");
                continue;
            }
            List<ScpPredictStStockDO> stockDOList = stStockMap.get(key);
            if (stockDOList.size() != 1) {
                ((List)errorMap.get(importVO.getLine())).add("\u6570\u636e\u5b58\u5728\u591a\u6761");
                continue;
            }
            ScpPredictStStockDO scpPredictStStockDO = stockDOList.get(0);
            if (!Objects.equals(scpPredictStStockDO.getOuCode(), importVO.getOuCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]\u4e0d\u4e00\u81f4");
            } else if (!Objects.equals(scpPredictStStockDO.getWhCode(), importVO.getWhCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u4ed3\u5e93\u7f16\u7801]\u4e0d\u4e00\u81f4");
            } else if (!Objects.equals(scpPredictStStockDO.getItemCode(), importVO.getItemCode())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u4e00\u81f4");
            } else if (!Objects.equals(scpPredictStStockDO.getSafetyQty(), importVO.getSafetyQty())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u5b89\u5168\u5e93\u5b58]\u4e0d\u4e00\u81f4");
            } else if (!Objects.equals(scpPredictStStockDO.getTargetQty(), importVO.getTargetQty())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u76ee\u6807\u5e93\u5b58]\u4e0d\u4e00\u81f4");
            } else if (!Objects.equals(scpPredictStStockDO.getPlanUom(), importVO.getPlanUom())) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u8ba1\u5212\u5355\u4f4d]\u4e0d\u4e00\u81f4");
            }
            if (ouMap.get(importVO.getOuCode()) == null) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]\u4e0d\u5b58\u5728");
            } else if (whMap.get(ouMap.get(importVO.getOuCode()).getId() + importVO.getWhCode()) == null) {
                ((List)errorMap.get(importVO.getLine())).add(String.format("\u5217\u3010\u516c\u53f8\u7f16\u7801\u3011\u4e0d\u5c5e\u4e8e \u4ed3\u5e93 %s", importVO.getWhCode()));
            }
            if (itemMap.get(importVO.getItemCode()) == null) {
                ((List)errorMap.get(importVO.getLine())).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u5b58\u5728");
            }
            scpPredictStStockDO.setPredTargetQty(importVO.getPredTargetQty());
            scpPredictStStockDO.setPredSafetyQty(importVO.getPredSafetyQty());
            scpPredictStStockDO.setModifyTime(LocalDateTime.now());
            updates.add(scpPredictStStockDO);
        }
        if (!CollectionUtils.isEmpty(updates)) {
            List stStockDOS = updates.stream().filter(d -> d.getBusinessId() != null).collect(Collectors.toList());
            this.scpPredictStStockRepo.saveAll(stStockDOS);
        }
        for (Integer line : errorMap.keySet()) {
            if (((List)errorMap.get(line)).isEmpty() || Objects.equals(errorList.get(line - 1), null)) continue;
            errorList.set(line - 1, (String)errorList.get(line - 1) + String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        return errorList;
    }

    @Nullable
    private Boolean getErrorResult(List<String> errorList) {
        Boolean flag = false;
        errorList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                if (!StringUtils.hasText((String)s)) {
                    return null;
                }
                return s;
            }
        });
        for (String s : errorList) {
            if (!StringUtils.hasText((String)s)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public ScpPredictStStockImportServiceImpl(InvWhProvider invWhProvider, ItmItemRpcService itemRpcService, OrgOuRpcService orgOuRpcService, ScpPredictStStockRepo scpPredictStStockRepo) {
        this.invWhProvider = invWhProvider;
        this.itemRpcService = itemRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.scpPredictStStockRepo = scpPredictStStockRepo;
    }
}

