/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.domain.entity.setting.QScpOrderSettingDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpOrderSettingRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpOrderSettingDO scpOrderSettingDO = QScpOrderSettingDO.scpOrderSettingDO;
    private final QBean<ScpOrderSettingPageRespVO> pageList;

    public long countOrderSetting(ScpOrderSettingPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scpOrderSettingDO.count()).from((EntityPath)scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpOrderSettingPageRespVO> queryOrderSetting(ScpOrderSettingPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpOrderSettingDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereOrderSettingPage(ScpOrderSettingPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.type.eq((Object)paramVO.getType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void enableDemandSet(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scpOrderSettingDO).set((Path)ScpOrderSettingRepoProc.scpOrderSettingDO.status, (Object)enable).where(new Predicate[]{ScpOrderSettingRepoProc.scpOrderSettingDO.id.in(ids)});
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.id.in(ids));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)scpOrderSettingDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public List<ScpOrderSettingRespVO> findByParam(ScpOrderSettingParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpOrderSettingRespVO.class, (Expression[])new Expression[]{ScpOrderSettingRepoProc.scpOrderSettingDO.id, ScpOrderSettingRepoProc.scpOrderSettingDO.docType, ScpOrderSettingRepoProc.scpOrderSettingDO.firstPriority, ScpOrderSettingRepoProc.scpOrderSettingDO.secPriority, ScpOrderSettingRepoProc.scpOrderSettingDO.type, ScpOrderSettingRepoProc.scpOrderSettingDO.itemCate, ScpOrderSettingRepoProc.scpOrderSettingDO.whnetFreightFlag, ScpOrderSettingRepoProc.scpOrderSettingDO.suppFreightFlag, ScpOrderSettingRepoProc.scpOrderSettingDO.purScene, ScpOrderSettingRepoProc.scpOrderSettingDO.purSceneName, ScpOrderSettingRepoProc.scpOrderSettingDO.trnType, ScpOrderSettingRepoProc.scpOrderSettingDO.status, ScpOrderSettingRepoProc.scpOrderSettingDO.freeFreightAmt, ScpOrderSettingRepoProc.scpOrderSettingDO.freeFreightFlag})).from((EntityPath)scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSetting(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereOrderSetting(ScpOrderSettingParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getItemCate())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.itemCate.like("%" + paramVO.getItemCate() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemCates())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.itemCate.in(paramVO.getItemCates()));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getTrnType())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.trnType.eq((Object)paramVO.getTrnType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(ScpOrderSettingRepoProc.scpOrderSettingDO.type.eq((Object)paramVO.getType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpOrderSettingRespVO> findEnabledSetting() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpOrderSettingRespVO.class, (Expression[])new Expression[]{ScpOrderSettingRepoProc.scpOrderSettingDO.id, ScpOrderSettingRepoProc.scpOrderSettingDO.docType, ScpOrderSettingRepoProc.scpOrderSettingDO.type, ScpOrderSettingRepoProc.scpOrderSettingDO.itemCate, ScpOrderSettingRepoProc.scpOrderSettingDO.firstPriority})).from((EntityPath)scpOrderSettingDO)).where((Predicate)ScpOrderSettingRepoProc.scpOrderSettingDO.status.eq(Boolean.TRUE));
        return jpaQuery.fetch();
    }

    public ScpOrderSettingRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpOrderSettingPageRespVO.class, (Expression[])new Expression[]{ScpOrderSettingRepoProc.scpOrderSettingDO.id, ScpOrderSettingRepoProc.scpOrderSettingDO.docType, ScpOrderSettingRepoProc.scpOrderSettingDO.itemCate, ScpOrderSettingRepoProc.scpOrderSettingDO.purScene, ScpOrderSettingRepoProc.scpOrderSettingDO.purSceneName, ScpOrderSettingRepoProc.scpOrderSettingDO.trnType, ScpOrderSettingRepoProc.scpOrderSettingDO.firstPriority, ScpOrderSettingRepoProc.scpOrderSettingDO.secPriority, ScpOrderSettingRepoProc.scpOrderSettingDO.whnetFreightFlag, ScpOrderSettingRepoProc.scpOrderSettingDO.suppFreightFlag, ScpOrderSettingRepoProc.scpOrderSettingDO.status, ScpOrderSettingRepoProc.scpOrderSettingDO.creator, ScpOrderSettingRepoProc.scpOrderSettingDO.createUserId, ScpOrderSettingRepoProc.scpOrderSettingDO.createTime, ScpOrderSettingRepoProc.scpOrderSettingDO.updater, ScpOrderSettingRepoProc.scpOrderSettingDO.modifyUserId, ScpOrderSettingRepoProc.scpOrderSettingDO.modifyTime, ScpOrderSettingRepoProc.scpOrderSettingDO.remark, ScpOrderSettingRepoProc.scpOrderSettingDO.type, ScpOrderSettingRepoProc.scpOrderSettingDO.freeFreightFlag, ScpOrderSettingRepoProc.scpOrderSettingDO.freeFreightAmt});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

