package com.elitesland.scp.application.facade.vo.resp.app;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemQualifyRpcDTO;
import com.elitesland.support.provider.item.dto.SpuImageDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品展示(我常订)
 * @author : wz
 * @date : 2024-3-27
 */
@Data
@ApiModel(value = "商品展示(我常订)", description = "商品展示(我常订)")
public class AppItemActivityRespVO implements Serializable {

    /** 商品id */
    @ApiModelProperty(name = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /** 商品名称 */
    @ApiModelProperty(name = "商品名称")
    private String itemName;

    /** 商品编码 */
    @ApiModelProperty(name = "商品编码")
    private String itemCode;

    /** 累计订购次数 */
    @ApiModelProperty(name = "累计订购次数")
    private BigDecimal sumTimes ;

    /** 累计订购数量 */
    @ApiModelProperty(name = "累计订购数量")
    private BigDecimal sumQuantity ;

    /** 单位 */
    @ApiModelProperty(name = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom ;
    private String uomName;

    /** 价格 */
    @ApiModelProperty(name = "价格")
    private BigDecimal price ;

    /** 商品图片 */
    private List<ItmItemAttachmentProviderDTO> spuImages;

    /**
     * 商品SKU规格
     */
    @ApiModelProperty("商品SKU规格")
    private String itemAttr;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String spec;

    /**
     * sku对应的spuId
     */
    @ApiModelProperty("sku对应的spuId")
    private Long spuId;

    /**
     *spu编码
     */
    @ApiModelProperty("spu编码")
    private String spuCode;

    /**
     *spu名称
     */
    @ApiModelProperty("spu名称")
    private String spuName;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;


    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;


}