package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderSubmitMqParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class AppDemandOrderServiceImpl implements AppDemandOrderService {

    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final SysAreaRpcService sysAreaRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TransactionTemplate transactionTemplate;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long submit(ScpDemandOrderSubmitVO saveVO) {
        List<ScpDemandOrderDSubmitVO> itemList = saveVO.getItemList();
        if (CollUtil.isEmpty(itemList)) {
            throw new BusinessException("订货单明细不能为空");
        }
        OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(orgStoreRpcService.getByCode(saveVO.getDemandWhStCode())).orElseThrow(() -> new BusinessException("门店不存在"));
        saveVO.setStoreLevel(orgStore.getStoreLevel());
        saveVO.setStoreType2(orgStore.getStoreType2());
        String itemCode = SysUtils.getOrderItemSetting();
        //构建订货单明细
        List<ScpDemandOrderDSaveVO> saveItemList = buildSaveItemList(itemList, itemCode);

        Long id = scpDemandOrderService.saveDemandOrder(ScpDemandOrderConvert.INSTANCE.submitVoToSaveVO(saveVO));
        scpDemandOrderDService.batchSaveDemandOrderD(id, "MG", saveItemList);

        //清空采购车
        clearCheckedStoreCartItems(saveVO, saveItemList);
        String orderSetting = SysUtils.getOrderSetting();
        if ("0".equals(orderSetting)) {
            return id;
        }
        //获取当前操作人id和name
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("当前登录用户信息:{}", JSONUtil.toJsonStr(currentUserDTO));
        if (ObjectUtils.isEmpty(currentUserDTO) || currentUserDTO.getDetail() == null) {
            throw new BusinessException("查询当前登录用户失败");
        }
        //事物提交之后写入mq队列,进行订单推送
        transactionCommitHandler.handle(() -> {
            ScpOrderSubmitMqParam orderSubmitMqParam = new ScpOrderSubmitMqParam();
            orderSubmitMqParam.setDemandOrderId(id);
            orderSubmitMqParam.setAgentEmpId(currentUserDTO.getDetail().getEmployeeId());
            orderSubmitMqParam.setBusinessKey(ScpOrderSubmitMqParam.SUBMIT_CHANNEL);
            orderSubmitMqParam.setDemandWhStCode(saveVO.getDemandWhStCode());
            List<Long> activityIds = saveItemList.stream().map(ScpDemandOrderDSaveVO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            orderSubmitMqParam.setActivityIds(activityIds);
            messageQueueTemplate.publishMessageSync("yst-suplan", ScpOrderSubmitMqParam.SUBMIT_CHANNEL, orderSubmitMqParam);
        });
        return id;
    }

    /**
     * 构建保存订货单明细
     *
     * @param itemList
     * @param itemCode
     * @return
     */
    private static List<ScpDemandOrderDSaveVO> buildSaveItemList(List<ScpDemandOrderDSubmitVO> itemList, String itemCode) {
        List<ScpDemandOrderDSaveVO> saveItemList = itemList.stream()
                .flatMap(item -> item.getItemSpecObjectVOS().stream()
                        .flatMap(row -> {
                            String uuid = UUIDUtil.getUUID();
                            return row.getWhAllocObjects().stream()
                                    .map(wh -> buildScpDemandOrderDVO(item, row, wh, uuid, itemCode));
                        }))
                .collect(Collectors.toList());
        return saveItemList;
    }

    /**
     * 清空采购车
     *
     * @param saveVO
     * @param saveItemList
     */
    private void clearCheckedStoreCartItems(ScpDemandOrderSubmitVO saveVO, List<ScpDemandOrderDSaveVO> saveItemList) {
        for (ScpDemandOrderDSaveVO item : saveItemList) {
            cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()));
        }
        //清除主品采购车
        for (ScpDemandOrderDSaveVO scpDemandOrderDSaveVO : saveItemList.stream().filter(item -> StringUtils.hasLength(item.getCombineItemCode())).toList()) {
            cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey("", scpDemandOrderDSaveVO.getCombineItemCode()));
        }

    }

    /**
     * 构建订货单明细
     *
     * @param item
     * @param row
     * @param wh
     * @return
     */
    private static ScpDemandOrderDSaveVO buildScpDemandOrderDVO(ScpDemandOrderDSubmitVO item, ScpDemandOrderDSubmitVO.ItemSpecObjectVO row,
                                                                ScpDemandOrderDSubmitVO.WhAllocObject wh, String uuid, String freightItemCode) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(wh.getQty());
        scpDemandOrderDSaveVO.setRatio(wh.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(wh.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(wh.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(wh.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(wh.getSupplyWhName());
        scpDemandOrderDSaveVO.setSpuItemCode(item.getSpuCode());
        scpDemandOrderDSaveVO.setSpuItemName(item.getSpuName());
        scpDemandOrderDSaveVO.setItemId(row.getItemId());
        scpDemandOrderDSaveVO.setItemCode(row.getItemCode());
        scpDemandOrderDSaveVO.setItemName(row.getItemName());
        scpDemandOrderDSaveVO.setDemandQuantity(row.getDemandQuantity());
        scpDemandOrderDSaveVO.setUnit(row.getUom());
        scpDemandOrderDSaveVO.setUnitName(row.getUomName());
        scpDemandOrderDSaveVO.setPrice(wh.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(wh.getOuId());
        scpDemandOrderDSaveVO.setOuCode(wh.getOuCode());
        scpDemandOrderDSaveVO.setOuName(wh.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(row.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(row.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(row.getUomRatio());
        if (row.getUomRatio() != null) {
            scpDemandOrderDSaveVO.setQty2(wh.getQty().multiply(row.getUomRatio()).setScale(row.getDecimalPlaces(), RoundingMode.HALF_UP));
        }
        if (wh.getItemPrice() != null) {
            scpDemandOrderDSaveVO.setDemandAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(wh.getItemPrice())));
        }
        scpDemandOrderDSaveVO.setFreightFlag(wh.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(wh.getFreightRatio());
        scpDemandOrderDSaveVO.setFreightAmt(wh.getFreightAmt());
        scpDemandOrderDSaveVO.setSaleCustCode(wh.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(wh.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(wh.getSaleOuName());
        scpDemandOrderDSaveVO.setItemType(row.getItemType());
        scpDemandOrderDSaveVO.setPreRootUuid(uuid);
        scpDemandOrderDSaveVO.setImgUrl(item.getUrl());
        scpDemandOrderDSaveVO.setFreightLineFlag(freightItemCode.equals(row.getItemCode()));
        scpDemandOrderDSaveVO.setActivityId(row.getActivityId());
        scpDemandOrderDSaveVO.setActivityCode(row.getActivityCode());
        scpDemandOrderDSaveVO.setMinNum(row.getMinNum());
        scpDemandOrderDSaveVO.setCombineItemCode(item.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemName(item.getCombineItemName());
        return scpDemandOrderDSaveVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveDemandOrderD(List<ScpDemandOrderDSaveVO> saveVOS) {
        BigDecimal maxLineNo = scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(saveVOS.get(0).getMasId());
        //设置行号
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        for (ScpDemandOrderDSaveVO saveVO : saveVOS) {
            if (saveVO.getId() != null) {
                saveVO.setLineNo(BigDecimal.valueOf(lineNo.getAndIncrement()));
            }
        }
        scpDemandOrderDDomainService.batchSave(saveVOS, lineNo);
    }

    @Override
    public void addCart(Long id) {
        ScpDemandOrderRespVO demandOrder = scpDemandOrderService.findDemandOrderById(id).orElseThrow(new BusinessException("数据不存在"));
        List<ScpDemandOrderDMgmtRespVO> demandItemList = scpDemandOrderDService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(demandItemList)) {
            return;
        }
        //门店编码
        String storeCode = demandOrder.getDemandWhStCode();
        //单据类型
        String docType = demandOrder.getDocType();
        List<StoreCartSaveVO> cartSaveVOS = new ArrayList<>();
        String orderItemSetting = SysUtils.getOrderItemSetting();
        //查询商品图片
        List<Long> itemIds = demandItemList.stream().map(ScpDemandOrderDMgmtRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> itemList = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        Map<Long, ItmItemScpBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));

        //构建购物车保存属性
        for (ScpDemandOrderDMgmtRespVO item : demandItemList) {
            //过滤掉运费商品
            if (orderItemSetting.equals(item.getItemCode())) {
                continue;
            }
            StoreCartSaveVO cartSaveVO = new StoreCartSaveVO();
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = itemMap.get(item.getItemId());
            cartSaveVO.setDemandWhStCode(storeCode);
            cartSaveVO.setCartType(docType);
            cartSaveVO.setItemId(item.getItemId());
            cartSaveVO.setItemCode(item.getItemCode());
            cartSaveVO.setItemName(itmItemScpBaseRpcDTO.getItemName());
            cartSaveVO.setUom(item.getUnit());
            cartSaveVO.setUomName(item.getUnitName());
            cartSaveVO.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
            cartSaveVO.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
            cartSaveVO.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
            cartSaveVO.setQty(item.getDemandQuantity());
            cartSaveVO.setSpec(itmItemScpBaseRpcDTO.getSpec());
            var skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            var spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty(skuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? skuAttchmentList.get(0).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
            }
            cartSaveVO.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
            cartSaveVO.setItemCateName(itmItemScpBaseRpcDTO.getItemCateName());
            cartSaveVOS.add(cartSaveVO);
        }

        //实时获取价格
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(docType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        var priceParamVOS = cartSaveVOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, demandOrder.getType());
        //获取价格
        cartSaveVOS.forEach(row -> {
            if (priceMap.containsKey(row.getItemCode())) {
                row.setItemPrice(SysUtils.processPriceScale(priceMap.get(row.getItemCode()).get(0).getPrice()));
            }
        });
        //添加购物车
        scpStoreCartService.batchSaveCart(storeCode, docType, cartSaveVOS);
    }

    @Override
    @SysCodeProc
    public ScpDemandOrderRespVO findDemandOrderById(Long id) {
        ScpDemandOrderRespVO orderRespVO = scpDemandOrderService.findDemandOrderById(id).get();
        //转换区域名称
        Map<String, String> areaMap = buildAddr(orderRespVO.getRecvProvince(), orderRespVO.getRecvCity(), orderRespVO.getRecvCounty());
        if (CollUtil.isNotEmpty(areaMap)) {
            orderRespVO.setRecvProvinceName(areaMap.get(orderRespVO.getRecvProvince()));
            orderRespVO.setRecvCityName(areaMap.get(orderRespVO.getRecvCity()));
            orderRespVO.setRecvCountyName(areaMap.get(orderRespVO.getRecvCounty()));
        }
        //合计数据
        List<ScpDemandOrderDDTO> demandOrderD = scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        //循环订单明细
        AtomicReference<BigDecimal> itemTotalCount = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> noPayAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderD) {
            if (row.getPlanQuantity() != null) {
                itemTotalCount.updateAndGet(v -> v.add(row.getPlanQuantity()));
            }
            if (row.getPlanAmt() != null) {
                amt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                continue;
            }
            if (row.getPayStatus() != null && ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode().equals(row.getPayStatus())) {
                noPayAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
            if (row.getFreightLineFlag()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
        }
        orderRespVO.setItemTotalCount(itemTotalCount.get());
        orderRespVO.setAmt(amt.get());
        orderRespVO.setNoPayAmt(noPayAmt.get());
        orderRespVO.setGoodAmt(goodAmt.get());
        orderRespVO.setFreightAmt(freightAmt.get());
        return orderRespVO;
    }

    @Override
    @SysCodeProc
    public AppPayOrderRespVO findPayOrderById(Long srcDocId) {
        AppPayOrderRespVO appPayOrderRespVO = scpDemandOrderDomainService.payOrderById(srcDocId);
        ScpDemandOrderDTO scpDemandOrderDTO = scpDemandOrderDomainService.findDemandOrderById(appPayOrderRespVO.getDocId()).get();
        appPayOrderRespVO.setDocCode(scpDemandOrderDTO.getDocCode());
        appPayOrderRespVO.setDocType(scpDemandOrderDTO.getDocType());
        appPayOrderRespVO.setCreateTime(scpDemandOrderDTO.getCreateTime());
        appPayOrderRespVO.setRecvContactName(scpDemandOrderDTO.getRecvContactName());
        appPayOrderRespVO.setRecvContactTel(scpDemandOrderDTO.getRecvContactTel());
        //如果是在线支付查询微企付订单并且更新订单支付状态
        String payStatus = queryWqfAndUpdatePayStatus(appPayOrderRespVO.getSrcDocNo(), appPayOrderRespVO.getPayStatus(), appPayOrderRespVO.getOnlinePayFlag());
        appPayOrderRespVO.setPayStatus(payStatus);
        Map<String, String> stringStringMap = this.buildAddr(scpDemandOrderDTO.getRecvProvince(), scpDemandOrderDTO.getRecvCity(),
                scpDemandOrderDTO.getRecvCounty());
        if (CollUtil.isNotEmpty(stringStringMap)) {
            appPayOrderRespVO.setRecvProvinceName(stringStringMap.get(scpDemandOrderDTO.getRecvProvince()));
            appPayOrderRespVO.setRecvCityName(stringStringMap.get(scpDemandOrderDTO.getRecvCity()));
            appPayOrderRespVO.setRecvCountyName(stringStringMap.get(scpDemandOrderDTO.getRecvCounty()));
        }
        if (!redisUtils.hasKey(ScpConstant.SCP_ONLINE_PAY + appPayOrderRespVO.getSrcDocNo())) {
            return appPayOrderRespVO;
        }
        appPayOrderRespVO.setCountdown(messageDelyQueueService.getOrderExpireTime(ScpConstant.SCP_ONLINE_PAY + appPayOrderRespVO.getSrcDocNo()));
        return appPayOrderRespVO;
    }

    private String queryWqfAndUpdatePayStatus(String srcDocNo, String payStatus, Boolean onlinePayFlag) {
        // 如果在线支付订单需要查询微企付订单支付信息
        if (!onlinePayFlag || ScpUdcEnum.PAY_STATUS_PAYED.getValueCode().equals(payStatus)) {
            return payStatus;
        }
        try {
            Payment payment = Payment.retrieveByOutPaymentId(srcDocNo);
            List<String> payStatusList = List.of("CLOSED", "PROCESSING");
            if (payStatusList.contains(payment.getPayStatus())) {
                return payStatus;
            }
            String updatePayStatus = "SUCCEEDED".equals(payment.getPayStatus()) ? ScpUdcEnum.PAY_STATUS_PAYED.getValueCode() : ScpUdcEnum.PAY_STATUS_PAYING.getValueCode();
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            transactionTemplate.execute(transactionStatus -> {
                try {
                    scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(srcDocNo, updatePayStatus);
                    return "ok";
                } catch (Exception e) {
                    log.error("更新订货单失败:{}", e.getMessage(), e);
                    // 回滚
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            return updatePayStatus;
        } catch (EntpayException e) {
            log.error("查询银行信息失败:{}", e);
        }
        return payStatus;
    }

    @Override
    public AppPayOrderItemRespVO findPayOrderItemById(Long srcDocId) {
        AppPayOrderItemRespVO result = new AppPayOrderItemRespVO();
        List<ScpDemandOrderDDTO> demandOrderDDTOS = scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId);
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            throw new BusinessException("订单明细不存在");
        }
        Map<String, String> uomCodeMap = rmiSysUDCService.getCodeMap("yst-supp", "UOM");

        List<Long> itemIds = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemScpBaseRpcDTO> scpItemMap = rmiItemService.findScpItemMap(itemIds);

        List<String> combineItemCodes = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getCombineItemCode).collect(Collectors.toList());
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(combineItemCodes);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);

        //合计商品数量
        BigDecimal totalNum = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amt = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        result.setAmt(amt);
        result.setTotalNum(totalNum);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderDDTOS) {
            if (row.getPlanAmt() == null) {
                continue;
            }
            if (row.getFreightLineFlag()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
        }
        result.setGoodAmt(goodAmt.get());
        result.setFreightAmt(freightAmt.get());
        result.setCateNum(demandOrderDDTOS.size());

        //过滤商品子品，获取组合商品信息
        List<ScpDemandOrderDDTO> subItemList = demandOrderDDTOS.stream().filter(row -> StringUtils.hasLength(row.getCombineItemCode())).collect(Collectors.toList());

        Map<String, List<ScpDemandOrderDDTO>> subItemMap = new HashMap<>();
        if(CollUtil.isNotEmpty(subItemList)) {
            demandOrderDDTOS.removeAll(subItemList);
            subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
        }

        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemSpecObjectVOList = new ArrayList<>();
        //构建商品明细信息
        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList = demandOrderDDTOS.stream().map(row -> {
            AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
            specObj.setItemCode(row.getItemCode());
            specObj.setItemName(row.getItemName());
            specObj.setUom(row.getUnit());
            if (uomCodeMap.containsKey(row.getUnit())) {
                specObj.setUomName(uomCodeMap.get(row.getUnit()));
            }
            if (scpItemMap.containsKey(row.getItemId())) {
                ItmItemScpBaseRpcDTO item = scpItemMap.get(row.getItemId());
                specObj.setItemAttrName(StrUtil.isBlank(item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                specObj.setAnotherName(item.getAnotherName());
                var spuAttchmentList = item.getSpuAttchmentList();
                if (CollUtil.isNotEmpty(item.getSkuAttchmentList())) {
                    Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    String url = first.isPresent() ? first.get().getUrl() : item.getSkuAttchmentList().get(0).getUrl();
                    specObj.setUrl(url);
                } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    specObj.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
                }
            }
            specObj.setAmt(row.getPlanAmt());
            specObj.setQty(row.getPlanQuantity());
            return specObj;
        }).collect(Collectors.toList());

        //设置商品子品
        if(!subItemMap.isEmpty()){
            subItemMap.forEach((combineItemCode, values) -> {
                AppPayOrderItemRespVO.ItemSpecObjectVO mainItem = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                mainItem.setItemCode(combineItemCode);
                mainItem.setItemName(values.get(0).getCombineItemName());
                itemRpcDtoByParam.stream().filter(row -> combineItemCode.equals(row.getItemCode()))
                        .findFirst()
                        .ifPresent(row -> {
                            mainItem.setUom(row.getUom2());
                            if (CollUtil.isNotEmpty(row.getSkuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                String url = first.isPresent() ? first.get().getUrl() : row.getSkuAttchmentList().get(0).getUrl();
                                mainItem.setUrl(url);
                            } else if (CollUtil.isNotEmpty(row.getSpuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSpuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                mainItem.setUrl(first.isEmpty() ? row.getSpuAttchmentList().get(0).getUrl() : first.get().getUrl());
                            }
                            mainItem.setItemAttrName(row.getItemAttrName());
                            mainItem.setAnotherName(row.getAnotherName());
                            mainItem.setAmt(values.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                            ScpDemandOrderDDTO scpDemandOrderDDTO = values.get(0);
                            row.getSubItems().stream().filter(a -> a.getId().equals(scpDemandOrderDDTO.getItemId()))
                                    .findFirst().ifPresent(b -> {
                                        mainItem.setQty(scpDemandOrderDDTO.getPlanQuantity().divide(b.getBomQty(), 0, RoundingMode.FLOOR));
                                    });
                        });
                if (uomCodeMap.containsKey(mainItem.getUom())) {
                    mainItem.setUomName(uomCodeMap.get(mainItem.getUom()));
                }
                List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList2 = values.stream().map(row -> {
                    AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                    specObj.setItemCode(row.getItemCode());
                    specObj.setItemName(row.getItemName());
                    specObj.setUom(row.getUnit());
                    if (uomCodeMap.containsKey(row.getUnit())) {
                        specObj.setUomName(uomCodeMap.get(row.getUnit()));
                    }
                    if (scpItemMap.containsKey(row.getItemId())) {
                        ItmItemScpBaseRpcDTO item = scpItemMap.get(row.getItemId());
                        specObj.setItemAttrName(StrUtil.isBlank(item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                        specObj.setAnotherName(item.getAnotherName());
                        var spuAttchmentList = item.getSpuAttchmentList();
                        if (CollUtil.isNotEmpty(item.getSkuAttchmentList())) {
                            Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            String url = first.isPresent() ? first.get().getUrl() : item.getSkuAttchmentList().get(0).getUrl();
                            specObj.setUrl(url);
                        } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                            Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            specObj.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
                        }
                    }
                    specObj.setAmt(row.getPlanAmt());
                    specObj.setQty(row.getPlanQuantity());
                    return specObj;
                }).collect(Collectors.toList());
                mainItem.setItemList(itemList2);
                itemSpecObjectVOList.add(mainItem);
            });

        }

        itemSpecObjectVOList.addAll(itemList);
        result.setItemList(itemSpecObjectVOList);
        return result;
    }

    @Override
    @SysCodeProc
    public List<AppRelateOrderRespVO> findRelateOrderById(Long id) {
        List<AppRelateOrderRespVO> result = new ArrayList<>();
        List<ScpDemandOrderDDTO> orderDDTOList = scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(orderDDTOList)) {
            throw new BusinessException("关联单据不存在");
        }
        Map<String, String> uomCodeMap = rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        Map<String, List<ScpDemandOrderDDTO>> orderMap = orderDDTOList.stream().filter(row -> row.getSrcDocId() != null).collect(Collectors.groupingBy(row -> row.getSrcDocNo() + "@" + row.getSaleOuCode()));
        // 循环orderMap
        for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : orderMap.entrySet()) {
            String srcDocNo = entry.getKey().split("@")[0];
            AppRelateOrderRespVO appRelateOrderRespVO = new AppRelateOrderRespVO();
            // 获取关联单据明细
            List<ScpDemandOrderDDTO> value = entry.getValue();
            //明细总金额
            BigDecimal amt = value.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

            List<String> combineItemCodes = value.stream().map(ScpDemandOrderDDTO::getCombineItemCode).collect(Collectors.toList());
            ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
            param.setItemCodes(combineItemCodes);
            List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);

            //组装主品展示
            Map<String, List<ScpDemandOrderDDTO>> subItemMap = new HashMap<>();
            List<ScpDemandOrderDDTO> subItemList = value.stream().filter(row -> StringUtils.hasLength(row.getCombineItemCode())).collect(Collectors.toList());
            if(CollUtil.isNotEmpty(subItemList)) {
                value.removeAll(subItemList);
                subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
            }
            List<AppRelateOrderRespVO.ItemRespVO> allItemList = new ArrayList<>();
            List<AppRelateOrderRespVO.ItemRespVO> inItemList = value.stream().map(row -> {
                AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                itemRespVO.setItemCode(row.getItemCode());
                itemRespVO.setItemName(row.getItemName());
                itemRespVO.setQty(row.getPlanQuantity());
                itemRespVO.setAmt(row.getPlanAmt());
                itemRespVO.setUom(row.getUnit());
                if (uomCodeMap.containsKey(row.getUnit())) {
                    itemRespVO.setUomName(uomCodeMap.get(row.getUnit()));
                }
                return itemRespVO;
            }).collect(Collectors.toList());
            if(!subItemMap.isEmpty()){
                for (Map.Entry<String, List<ScpDemandOrderDDTO>> subItemEntry : subItemMap.entrySet()) {
                    List<AppRelateOrderRespVO.ItemRespVO> subItemRespVOList = subItemEntry.getValue().stream().map(row -> {
                        AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                        itemRespVO.setItemCode(row.getItemCode());
                        itemRespVO.setItemName(row.getItemName());
                        itemRespVO.setQty(row.getPlanQuantity());
                        itemRespVO.setAmt(row.getPlanAmt());
                        itemRespVO.setUom(row.getUnit());
                        if (uomCodeMap.containsKey(row.getUnit())) {
                            itemRespVO.setUomName(uomCodeMap.get(row.getUnit()));
                        }
                        return itemRespVO;
                    }).collect(Collectors.toList());
                    AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                    List<ScpDemandOrderDDTO> value1 = subItemEntry.getValue();
                    itemRespVO.setItemCode(subItemEntry.getKey());
                    itemRespVO.setItemName(value1.get(0).getCombineItemName());
                    itemRpcDtoByParam.stream().filter(row -> subItemEntry.getKey().equals(row.getItemCode()))
                            .findFirst()
                            .ifPresent(row -> {
                                itemRespVO.setUom(row.getUom());
                                itemRespVO.setAmt(subItemEntry.getValue().stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                                ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = row.getSubItems().get(0);
                                subItemEntry.getValue().stream().filter(a -> a.getItemId().equals(itmItemScpBaseRpcDTO.getId()))
                                        .findFirst().ifPresent(b -> {
                                            itemRespVO.setQty(b.getPlanQuantity().divide(itmItemScpBaseRpcDTO.getBomQty(), 0, RoundingMode.FLOOR));
                                        });
                            });
                    itemRespVO.setItemList(subItemRespVOList);
                    allItemList.add(itemRespVO);
                }
            }
            allItemList.addAll(inItemList);
            appRelateOrderRespVO.setItemList(allItemList);
            // 获取关联单据
            ScpDemandOrderDDTO scpDemandOrderDDTO = entry.getValue().get(0);
            //如果是在线支付查询微企付订单并且更新订单支付状态
            String payStatus = queryWqfAndUpdatePayStatus(srcDocNo, scpDemandOrderDDTO.getPayStatus(), scpDemandOrderDDTO.getOnlinePayFlag());
            appRelateOrderRespVO.setPayStatus(payStatus);
            appRelateOrderRespVO.setSrcDocNo(srcDocNo);
            appRelateOrderRespVO.setSrcDocId(scpDemandOrderDDTO.getSrcDocId());
            appRelateOrderRespVO.setSrcDocCls(scpDemandOrderDDTO.getSrcDocCls());
            appRelateOrderRespVO.setSaleOuName(scpDemandOrderDDTO.getSaleOuName());
            appRelateOrderRespVO.setSaleOuCode(scpDemandOrderDDTO.getSaleOuCode());
            appRelateOrderRespVO.setCreateTime(scpDemandOrderDDTO.getCreateTime());
            appRelateOrderRespVO.setAmt(amt);
            appRelateOrderRespVO.setPayerName(scpDemandOrderDDTO.getPayerName());
            result.add(appRelateOrderRespVO);
        }
        return result;
    }

    @Override
    public ScpOrderPayRespVO payInfo(String docCls, Long id) {
        ScpOrderPayRespVO scpOrderPayRespVO = new ScpOrderPayRespVO();
        LocalDateTime createTime = scpDemandOrderDDomainService.findDocCreateTimeBySrcDocId(id);
        if (createTime == null) {
            throw new BusinessException("订单不存在");
        }
        scpOrderPayRespVO.setDocDateTime(createTime);
        if ("STKTRO".equals(docCls)) {
            List<InvTroPayRpcDTO> invTroPayList = rmiInvStkRpcService.payInfo(id);
            if (CollUtil.isNotEmpty(invTroPayList)) {
                BigDecimal totalAmt = invTroPayList.stream().map(InvTroPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                List<ScpOrderPayRespVO.PayItem> payItems = ScpDemandOrderConvert.INSTANCE.troDtosToRespVOS(invTroPayList);
                scpOrderPayRespVO.setItemList(payItems);
                scpOrderPayRespVO.setAmt(totalAmt);
                scpOrderPayRespVO.setPayDateTime(invTroPayList.get(0).getReceiptDate());
            }
        }
        if ("PO".equals(docCls)) {
            List<PurPoPayRpcDTO> purPoPayList = rmiPurRpcService.payInfo(id);
            if (CollUtil.isNotEmpty(purPoPayList)) {
                BigDecimal totalAmt = purPoPayList.stream().map(PurPoPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                List<ScpOrderPayRespVO.PayItem> payItems = ScpDemandOrderConvert.INSTANCE.purDtosToRespVOS(purPoPayList);
                scpOrderPayRespVO.setItemList(payItems);
                scpOrderPayRespVO.setAmt(totalAmt);
                scpOrderPayRespVO.setPayDateTime(purPoPayList.get(0).getReceiptDate());
            }
        }
        return scpOrderPayRespVO;
    }

    private Map<String, String> buildAddr(String province, String city, String county) {
        //收货地址
        Set<String> areaCodes = new HashSet<>();
        areaCodes.add(province);
        areaCodes.add(city);
        areaCodes.add(county);
        SysAreaQueryDTO comCityCodeRpcDtoParam = new SysAreaQueryDTO();
        comCityCodeRpcDtoParam.setAreaCodes(areaCodes);
        List<SysAreaRespDTO> rpcDtos = sysAreaRpcService.queryList(comCityCodeRpcDtoParam).getData();
        if (CollUtil.isNotEmpty(rpcDtos)) {
            return rpcDtos.stream().collect(Collectors.toMap(t -> t.getAreaCode(), t -> t.getAreaName(), (t1, t2) -> t1));
        }
        return new HashMap<>();
    }
}
