package com.elitesland.scp.application.service.feedback;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackApproveVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.enums.ProcDefKey;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.WorkFlowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:08:05
 */
@Service("scpStoreFeedbackService")
@RequiredArgsConstructor
@Slf4j
public class ScpStoreFeedbackServiceImpl implements ScpStoreFeedbackService {
    
    private final ScpStoreFeedbackDomainService scpStoreFeedbackDomainService;

    private final WorkflowService workflowService;

    private final WorkFlowUtil workFlowUtil;

    private final TransactionTemplate transactionTemplate;

    private final SensitiveWordBs sensitiveWordBs;

    private final RmiSysUserRpcService rmiSysUserRpcService;


    @Override
    @SysCodeProc
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param){
        return scpStoreFeedbackDomainService.search(param);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreFeedbackRespVO> searchByPc(ScpStoreFeedbackQueryParamVO param){
        param.setFilteredFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode());
        return scpStoreFeedbackDomainService.search(param);
    }

    @Override
    public void exportZip(ScpStoreFeedbackQueryParamVO param, HttpServletRequest request, HttpServletResponse response){
        param.setFilteredFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode());
        scpStoreFeedbackDomainService.exportZip(param, request, response);
    }

    @Override
    @SysCodeProc
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        Optional<ScpStoreFeedbackRespVO> idOne = scpStoreFeedbackDomainService.findIdOne(id);
        idOne.ifPresent(item -> {
            if (item.getFileUrl() != null)
                item.setFileUrlList(JSONObject.parseArray(item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            String replace = sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return idOne;
    }

    @Override
    @Transactional
    public Long createOrUpdate(ScpStoreFeedbackSaveVO param){
       return scpStoreFeedbackDomainService.createOne(param);
    }

    @Override
    @Transactional
    public void approveBatch(ScpStoreFeedbackApproveVO params){
        if(!CollectionUtils.isEmpty(params.getIds())){
            List<ScpStoreFeedbackRespVO> idBatch = scpStoreFeedbackDomainService.findIdBatch(params.getIds());
            if(!CollectionUtils.isEmpty(idBatch)) {
                idBatch.stream().filter(vo -> ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode().equals(vo.getApprovalStatus()))
                                .findAny().ifPresent(vo -> {
                                    throw new BusinessException("反馈商品已审批通过，不能重复审批: " + vo.getItemName());
                                });
                idBatch.forEach(vo -> {
                    if(params.getIsApprove()){
                        scpStoreFeedbackDomainService.statusChangeByProcess(vo.getId(), ProcInstStatus.APPROVED, "");
                    }else {
                        scpStoreFeedbackDomainService.statusChangeByProcess(vo.getId(), ProcInstStatus.REJECTED, "");
                    }
                });
            }
        }
    }
    @Override
    @Transactional
    public List<Long> createOrUpdateBatch(List<ScpStoreFeedbackSaveVO> params){

        //设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        //开启事务(工作流服务没结束前要根据单据id查询业务单据信息,所以要给保存方法开启独立事务)
        transactionTemplate.execute(transactionStatus -> {
            try {
                //先删后保存单子
                List<Long> ids = params.stream().map(ScpStoreFeedbackSaveVO::getId).filter(Objects::nonNull).toList();
                if(!CollectionUtils.isEmpty(ids)){
                    List<ScpStoreFeedbackRespVO> idBatch = scpStoreFeedbackDomainService.findIdBatch(ids);
                    if(!CollectionUtils.isEmpty(idBatch)) {
                        idBatch.forEach(vo -> {
                            if (!ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode().equals(vo.getFeedbackStatus()))
                                throw new RuntimeException("反馈商品状态不是草稿，不能修改或提交: " + vo.getItemName());
                        });
                        scpStoreFeedbackDomainService.deleteBatch(ids);
                    }
                }
                params.forEach(param->{
                    if(!StringUtils.hasLength(param.getDcoNo())){
                        param.setDcoNo(rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.MDFK, new ArrayList<>()));
                    }
                    param.setFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode());
                    if(param.getIsSubmit()!=null&&param.getIsSubmit()){
                        param.setFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode());
                        param.setApprovalStatus(ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode());
                    }
                    if(!CollectionUtils.isEmpty(param.getFileUrlList())){
                        param.setFileUrl(JSONObject.toJSONString(param.getFileUrlList()));
                    }
                    Long one = scpStoreFeedbackDomainService.createOne(param);
                    param.setId( one);
                });
                return null;
            } catch (RuntimeException e) {
                log.error("createFeedback error:{}", e);
                //回滚
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
//        params.forEach(param->{
//            if(param.getIsSubmit()!=null&&param.getIsSubmit()){
//                if (param.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(param.getProcInstStatus())) {
//                    param.setFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode());
//                    param.setApprovalStatus(ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode());
//                    submit(param, param.getId());
//                }
//            }
//        });


        return params.stream().map(ScpStoreFeedbackSaveVO::getId).collect(Collectors.toList());
    }

    private void submit(ScpStoreFeedbackSaveVO param, Long id) {
        //启动流程这里可以自定义
        String procInstName = "门店反馈流程-"+ param.getFeedbackStoreName();
        log.info("门店反馈启动流程入参: " + "processDefinitionKey:"+ ProcDefKey.FEEDBACK_PROCESS.name()+",procInstName："+procInstName+",businessKey: "+ id + ""+",null,tenantId："+"1");
        WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(ProcDefKey.FEEDBACK_PROCESS.name(), procInstName, id + "", null));
        log.info("门店反馈启动流程返回:" + processInfoWorkflowResult);
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
        }
        //修改业务审批数据:流程状态用于判断
        String procInstId = processInfoWorkflowResult.getData().getProcInstId();
        param.setProcInstId(procInstId);
        param.setSubmitTime(LocalDateTime.now());
        param.setProcInstStatus(processInfoWorkflowResult.getData().getProcInstStatus());
        scpStoreFeedbackDomainService.createOne(param);
    }
}


