package com.elitesland.scp.domain.entity.wqf;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: ryan.xu
 * @Date: 2025/2/24
 * @Description:
 */

@Entity
@Table(name = "scp_wqf_ent_account")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scp_wqf_ent_account", comment = "微企付商户账户表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scp_wqf_ent_account", description = "微企付商户账户表")
public class ScpWqfEntAccountDO extends BaseModel {
    private static final long serialVersionUID = -7234922868683108335L;

    @ApiModelProperty("apply_no")
    @Comment("申请单号")
    @Column()
    private String applyNo;

    @ApiModelProperty("公司ID")
    @Comment("公司ID")
    @Column()
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Comment("公司编码")
    @Column()
    private String ouCode;

    @ApiModelProperty("公司商户号")
    @Comment("公司商户号")
    @Column()
    private String entId;

    @ApiModelProperty("门店ID")
    @Comment("门店ID")
    @Column()
    private Long storeId;

    @ApiModelProperty("门店编码")
    @Comment("门店编码")
    @Column()
    private String storeCode;

    @ApiModelProperty("门店商户号")
    @Comment("门店商户号")
    @Column()
    private String entAcctId;

    @ApiModelProperty("账户类型")
    @Comment("账户类型")
    @Column()
    private String accountType;

    @ApiModelProperty("门店充值子账号")
    @Comment("门店充值子账号")
    @Column()
    private String bankAccount;

    @ApiModelProperty("开户银行")
    @Comment("开户银行")
    @Column()
    private String openBank;

    @ApiModelProperty("联行号")
    @Comment("联行号")
    @Column(name = "bank_branch_code")
    private String bankBranchCode;

    @ApiModelProperty("支行名")
    @Comment("支行名")
    @Column(name = "branch_name")
    private String branchName;

    @ApiModelProperty("启用状态")
    @Comment("启用状态")
    @Column()
    private Boolean status;

}
