package com.elitesland.scp.job.task;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.job.config.JobConstant;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhiyu.he
 * @date 2025/9/14 9:21
 */
@Component
@Slf4j
public class ScpManInfoHandler {

    @Autowired
    private ScpsmanInfoService scpsmanInfoService;

    @XxlJob(JobConstant.SCP_MAN_INFO_CREATE)
    public ReturnT<String> scpDemandSetHandler(String param) {
        try {
            scpsmanInfoService.autoManInfo();
        } catch (Exception e) {
            log.error("创建订货员任务执行失败：", e);
            throw new BusinessException("创建订货员任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
