package com.elitesland.scp.lakalapay.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
//import com.elitesland.scp.domain.entity.lakalapay.LakalaPayRecordDO;
//import com.elitesland.scp.infr.repo.lakalapay.LakalaPayRecordRepo;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitesland.scp.domain.entity.lakalapay.LakalaPayRecordDO;
import com.elitesland.scp.infr.repo.lakalapay.LakalaPayRecordRepo;
import com.elitesland.scp.lakalapay.config.LakalaProperties;
import com.elitesland.scp.lakalapay.vo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpMethod;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 用来请求商龙开放平台接口的deme，前提引入httpClient依赖包
 * <dependency>
 * <groupId>org.apache.httpcomponents</groupId>
 * <artifactId>httpclient</artifactId>
 * <version>4.5.13</version>
 * </dependency>
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class TcslPay {
    // 商龙开放平台接口访问地址,例如 测试环境：http://open-test.tcsl.com.cn/api/，
    //                          线上环境：https://openapi.tcsl.com.cn/
//    String host = "http://open-test.tcsl.com.cn/api/";
//
//    // 接口名，
//    String pay = "yzj/wuuxiangcloudfunds/third/external/payment/checkoutPay";//替换成开放平台接口文档里对应的接口名称
//    String queryAccountDtl = "yzj/wuuxiangcloudfunds/third/external/account/accountDetails";//替换成开放平台接口文档里对应的接口名称
//    String queryBalance = "yzj/wuuxiangcloudfunds/third/external/account/balance/query";//替换成开放平台接口文档里对应的接口名称
//    String queryResult = "yzj/wuuxiangcloudfunds/third/external/payment/checkoutPay/query";//替换成开放平台接口文档里对应的接口名称
//
//
//    //开放平台业务接口，目前只支持HTTP POST一种请求方式
//    String appSecret = "****";//你的appSecret，注意替换对应环境的appsecret
//    String appKey = "*****";

    private final LakalaProperties lakalaProperties;

    private final LakalaPayRecordRepo lakalaPayRecordRepo;

    // 在方法上添加重试注解
    @Retryable(value = {Exception.class}, maxAttempts = 3, backoff = @Backoff(delay = 1000))
    public OnlineLklPayOrderResponseVO pay(OnlineLklPayOrderParamVO payOrderParamVO) {
        //业务入参数
        Map<String, Object> paramsMap = new HashMap<>();
//        channelCode	渠道编码		是	string	 LklSmb-拉卡拉全渠道（苏商）,上送 LklSmb
//        outTradeNo	商户交易单号	是	string	必须唯一，长度限制：60
//        outTradeTime	商户交易日期时间	是	string	时间格式：yyyy-MM-dd HH:mm:ss
//        payerAccountNo	付款方账号	是	string	付款方账户号
//        payerName	付款方名称	否	string	付款方账户名称
//        postscript		银行附言	否	string	长度限制100字符
//        remark	备注	否	string	长度限制100字符
//        transFeeTakeFlag	手续费承担方标识	否	string
//        payExpireTime	支付过期时间	否	string	时间格式：yyyy-MM-dd HH:mm:ss 暂时无用，不传
//        body	商品名称	否	string	长度限制100字符
//        dcCode	收支编码	否	string
//        outBussNo	外部系统业务单号	否	string	外部系统业务单号
        paramsMap.put("channelCode", "LklSmb");
        paramsMap.put("outTradeNo", payOrderParamVO.getDocNo());
        paramsMap.put("outTradeTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        paramsMap.put("payerAccountNo", payOrderParamVO.getPayerNo());
        paramsMap.put("payerName", payOrderParamVO.getPayerName());
//        paramsMap.put("postscript", "");
        paramsMap.put("remark", payOrderParamVO.getRemark());
//        paramsMap.put("transFeeTakeFlag", "");
//        paramsMap.put("payExpireTime", "");
//        paramsMap.put("body", "");
//        paramsMap.put("dcCode", "");
        paramsMap.put("outBussNo", payOrderParamVO.getDocNo());
        paramsMap.put("payeeList", payOrderParamVO.getPayeeInfo());

        //存入中间表
        LakalaPayRecordDO lakalaPayRecordDO = new LakalaPayRecordDO();
        lakalaPayRecordDO.setOutTradeNo(payOrderParamVO.getDocNo());
        lakalaPayRecordDO.setOutTradeTime(LocalDateTime.now());
        lakalaPayRecordDO.setChannelCode("LklSmb");
        lakalaPayRecordDO.setPayResult(false);
        lakalaPayRecordDO.setPayerAccountNo(payOrderParamVO.getPayerNo());
        lakalaPayRecordDO.setPayerName(payOrderParamVO.getPayerName());
        lakalaPayRecordDO.setRemark(payOrderParamVO.getRemark());
        lakalaPayRecordDO.setPayeeList(JSONObject.toJSONString(payOrderParamVO.getPayeeInfo()));

        JSONObject send = send(JSONObject.toJSONString(paramsMap), lakalaProperties.getPay());
        lakalaPayRecordDO.setTraceId(send.getString("traceID"));
        lakalaPayRecordDO.setResponseParam(JSONObject.toJSONString( send));
        lakalaPayRecordRepo.save(lakalaPayRecordDO);
        return JSONObject.parseObject(send.toJSONString(), OnlineLklPayOrderResponseVO.class);
    }

    public JSONObject send(String params,String methodName) {
//        appSecret = "acwf56s21w75l2mwedhlekbyq6xkd7ek";
//        appKey="lyq6zg4tosmk2rjrwngbwlzdbbei9kaq";

        //参数1：头参数
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("groupID", "G301705"); //集团id，不可为空，在开放平台进行开通时候填写的那个G号
        headerMap.put("traceID", UUID.randomUUID().toString());//业务方的traceID，问题排查时，提供该traceID,注意保证唯一性,自己去生成就行
        headerMap.put("Proxy-Client-IP", "192.168.28.30");//请传入真实IP，用于校验ip白名单

        //参数2：系统级必传参数，每个接口必传这几个值，签名算法中会用到，不能缺少
        Map<String, String> systemParamsMap = new HashMap<>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", lakalaProperties.getAppKey());//注意替换对应环境的appkey

        systemParamsMap.put("version", "1");//固定值
        systemParamsMap.put("charset", "UTF-8");//固定值

        //参数类型3：业务入参数
        Map<String, String> bizParamsMap = new HashMap<>();
        bizParamsMap.put("biz", params);
//        bizParamsMap.put("biz", "{\"outTradeNo\":\"00441207916460685358035645863974\",\"channelCode\":\"LklSmb\",\"outTradeTime\":\"2023-07-17 14:44:12\",\"payerAccountNo\":\"123payer\",\"payeeList\":[{\"payeeAccountNo\":\"222123\",\"subOutTradeNo\":\"122222222222222222222\",\"subTradeAmount\":1.01}]}");//把请求报文进行json压缩后放入这里就行，我这里目前传了一个空对象
        try {
            //生成用来签名的完整url路径
            String urlForGenSig = genUrlForGenSig(lakalaProperties.getHost(), methodName, systemParamsMap, bizParamsMap);
            log.info("完整url路径: " + urlForGenSig);
            //生成签名
            String sig = getSig(lakalaProperties.getAppSecret(), urlForGenSig);
            //发送请求
            log.info("Request Body : " + JSONObject.toJSONString(params));
            String response = sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            // 输出响应响应体
            log.info("Response Body : " + response);
            JSONObject jsonObject = JSONObject.parseObject(response);
            String code = jsonObject.getString("code");
            if (code == null || !code.equals("0")) {
                throw new BusinessException("获取支付链接失败！"+ response);
            }
            JSONObject data = jsonObject.getJSONObject("data");
            Integer returnCode = data.getInteger("returnCode");
            String errorCode = data.getString("errorCode");
            if (returnCode == null || errorCode == null) {
                throw new BusinessException("获取支付链接失败！"+ response);
            }
            if (returnCode != 1 || !errorCode.equals("200")) {
                throw new BusinessException("获取支付链接失败！"+ jsonObject.getString("errMsg"));
            }
            JSONObject data1 = data.getJSONObject("data");
            data1.put("traceID", headerMap.get("traceID"));
            return data1;
        } catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }

    }

    public OnlineLklPayOrderResultResponseVO queryResult(String docNo) {
        //业务入参数
        Map<String, Object> paramsMap = new HashMap<>();
        paramsMap.put("outTradeNo", docNo);

        JSONObject send = send(JSONObject.toJSONString(paramsMap),lakalaProperties.getQueryResult());

        return JSONObject.parseObject(send.toJSONString(), OnlineLklPayOrderResultResponseVO.class);
    }

    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        //业务入参数
        Map<String, Object> paramsMap = new HashMap<>();
        paramsMap.put("brandId", param.getBrandId());
        paramsMap.put("accountNo",param.getAccountNo());

        JSONObject send = send(JSONObject.toJSONString(paramsMap),lakalaProperties.getQueryBalance());

        return JSONObject.parseObject(send.toJSONString(), BalanceResponseVO.class);
    }

    public JSONObject queryAccountDtl(QueryAccountDtlParamVO param) {
        //业务入参数
        Map<String, Object> paramsMap = new HashMap<>();
        paramsMap.put("brandId", param.getBrandId());
        paramsMap.put("accountNo",param.getAccountNo());
        paramsMap.put("startTime",param.getStartTime());
        paramsMap.put("endTime",param.getEndTime());

        JSONObject send = send(JSONObject.toJSONString(paramsMap),lakalaProperties.getQueryAccountDtl());

        return send;
    }

    private String sendRequest(String url, String sig, Map<String, String> headersMap, Map<String, String> paramsMap)
            throws RuntimeException {
        String requestUrl = url + "&sig=" + sig;
        HttpPost httpPost = new HttpPost(requestUrl);
        CloseableHttpResponse response = null;
        try {
            //设置参数
//            List<BasicNameValuePair> nameValuePairList = convertToEntity(paramsMap);
//            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
//            httpPost.setEntity(uefEntity);
            headersMap.forEach((k, v) -> httpPost.addHeader(k, v));
            CloseableHttpClient httpClient = HttpClients.createDefault();
            // 设置请求头
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");

            // 设置请求体
            String requestBody = paramsMap.get("biz");
            httpPost.setEntity(new StringEntity(requestBody, StandardCharsets.UTF_8));
            response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();

            return EntityUtils.toString(entity, "UTF-8");

        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        } finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

    }

    public String getSig(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));

            return toHex(bytes);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("不支持HmacSHA256算法", e);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("不支持utf8编码", e);
        } catch (Exception e) {
            throw new RuntimeException("hs256签名失败", e);
        }

    }

    public String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }

        return hexstr.toString();
    }

    public String genUrlForGenSig(String host, String methodName, Map<String, String> systemParamsMap,
                                         Map<String, String> applicationParamsMap) throws UnsupportedEncodingException {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.putAll(systemParamsMap);
        //如果应用级参数不为空，则组合应用级参数
        if (applicationParamsMap != null) {
            paramMap.putAll(applicationParamsMap);
        }
        return host + methodName + "?" + getSortedParamStr(paramMap);
    }

    /**
     * 构造自然排序请求参数
     *
     * @param params 请求
     * @return 字符串
     */
    public String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        Set<String> sortedParams = new TreeSet<>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            // 排除sign
            if (null != value && !"".equals(value) && !"sig".equalsIgnoreCase(key) && !"biz".equalsIgnoreCase(key)) {
                sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
            }
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    /**
     * 对象转化为参数列表
     *
     * @param applicationParamsMap
     * @return
     */
    public List<BasicNameValuePair> convertToEntity(Map<String, String> applicationParamsMap)
            throws RuntimeException {
        List<BasicNameValuePair> formParam = new ArrayList<>();
        try {
            if (applicationParamsMap != null) {
                for (Map.Entry<String, String> entry : applicationParamsMap.entrySet()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    formParam.add(nameValuePair);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("1");
        }
        return formParam;
    }
}
