/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarSaveVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import com.elitesland.scp.domain.convert.calendar.ScpStoreDemandCalendarConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpStoreDemandCalendarServiceImpl
implements ScpStoreDemandCalendarService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreDemandCalendarServiceImpl.class);
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final ScpOrderSettingService scpOrderSettingService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO param) {
        PagingVO<ScpStoreDemandCalendarPageVO> page;
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
            if (userAuthority.isEmpty()) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            this.extractedAuthorityParam(param, userAuthority);
        }
        if (CollectionUtils.isNotEmpty((Collection)(page = this.storeDemandCalendarDomainService.searchPage(param)).getRecords())) {
            List<String> strings = page.getRecords().stream().map(d -> d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth()).collect(Collectors.toList());
            List<ScpStoreDemandCalendarDO> calendardos = this.storeDemandCalendarDomainService.findByConcatYearAndMonthKey(strings);
            Map<String, List<ScpStoreDemandCalendarDO>> listMap = calendardos.stream().collect(Collectors.groupingBy(v -> v.getStoreCode() + v.getItemType2() + v.getYear() + v.getMonth()));
            page.getRecords().forEach(d -> {
                List calendarDOList = (List)listMap.get(d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth());
                d.setId(((ScpStoreDemandCalendarDO)calendarDOList.get(0)).getId());
                if (CollectionUtils.isNotEmpty((Collection)calendarDOList)) {
                    List details = calendarDOList.stream().map(m -> {
                        ScpStoreDemandCalendarPageVO.CalendarDayDetail detail = ScpStoreDemandCalendarConvert.INSTANCE.doToPageVo((ScpStoreDemandCalendarDO)m);
                        detail.setDay(m.getDay());
                        detail.setWorkStatus(m.getWorkStatus());
                        return detail;
                    }).collect(Collectors.toList());
                    List<ScpStoreDemandCalendarPageVO.CalendarDayDetail> sortList = details.stream().filter(v -> v.getDay() != null).sorted(this.getComparing()).collect(Collectors.toList());
                    d.setDayDetails(sortList);
                }
            });
        }
        return page;
    }

    private void extractedAuthorityParam(BaseScpmanAuthorityParam queryParam, PagingVO<ScpManAuthorityPageRespVO> userAuthority) {
        List<String> whCodes = userAuthority.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> stores = userAuthority.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhCodes(whCodes);
        queryParam.setStores(stores);
        queryParam.setScpmanAuthority(Boolean.TRUE);
    }

    private Comparator<ScpStoreDemandCalendarPageVO.CalendarDayDetail> getComparing() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveStoreCalendar(ScpStoreDemandCalendarSaveVO createParam) {
        if (CollectionUtils.isEmpty(createParam.getItemType2s())) {
            throw new BusinessException(ApiCode.FAIL, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u5546\u54c1\u7c7b\u578b");
        }
        if (createParam.getItemType2s().contains("all")) {
            ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
            List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = this.scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
            createParam.setItemType2s(scpOrderSettingRespVOS.stream().map(ScpOrderSettingRespVO::getDocType).collect(Collectors.toList()));
        }
        List<ScpStoreDemandCalendarSaveVO.CalendarDayDetail> dayDetails = createParam.getDayDetails();
        ArrayList calendarDOList = new ArrayList();
        createParam.getItemType2s().forEach(itemType2 -> calendarDOList.addAll(dayDetails.stream().map(d -> {
            ScpStoreDemandCalendarDO demandCalendarDO = ScpStoreDemandCalendarConvert.INSTANCE.saveVoToDo((ScpStoreDemandCalendarSaveVO.CalendarDayDetail)d);
            demandCalendarDO.setDay(d.getDay());
            demandCalendarDO.setWorkStatus(d.getWorkStatus());
            demandCalendarDO.setStoreCode(createParam.getStoreCode());
            demandCalendarDO.setStoreId(createParam.getStoreId());
            demandCalendarDO.setStoreName(createParam.getStoreName());
            demandCalendarDO.setYear(createParam.getYear());
            demandCalendarDO.setMonth(createParam.getMonth());
            demandCalendarDO.setType(createParam.getType());
            demandCalendarDO.setItemType2((String)itemType2);
            return demandCalendarDO;
        }).collect(Collectors.toList())));
        List<String> concatKey = calendarDOList.stream().map(d -> d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth() + d.getDay()).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> existList = this.storeDemandCalendarDomainService.findByStoreDayCalendar(concatKey);
        List<ScpStoreDemandCalendarDO> saveList = calendarDOList.stream().filter(d -> d.getId() == null).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> updateList = calendarDOList.stream().filter(d -> d.getId() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saveList)) {
            List existKeys;
            List saveKey = saveList.stream().map(d -> d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth() + d.getDay()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(existList) && CollectionUtils.isNotEmpty(existKeys = existList.stream().filter(d -> saveKey.contains(d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth() + d.getDay())).map(d -> d.getStoreCode() + "_" + d.getItemType2() + "_" + d.getYear() + "_" + d.getMonth()).distinct().collect(Collectors.toList()))) {
                throw new BusinessException(ApiCode.FAIL, String.join((CharSequence)",", existKeys) + "\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
            }
            this.storeDemandCalendarDomainService.createBatch(saveList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.storeDemandCalendarDomainService.createBatch(updateList);
        }
    }

    @Override
    @SysCodeProc
    public List<ScpStoreDemandCalendarRespVO> listCalendarVOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam) {
        return ScpStoreDemandCalendarConvert.INSTANCE.dtoToRespVO(this.storeDemandCalendarDomainService.listCalendarDTOs(scpStoreDemandCalendarParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteStoreCalendar(List<ScpStoreDemandCalendarParamVO> deleteParams) {
        long nullcount = deleteParams.stream().filter(d -> d.getYear() == null).count();
        if (nullcount > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5e74\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long nullcount2 = deleteParams.stream().filter(d -> d.getMonth() == null).count();
        if (nullcount2 > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> concatKey = deleteParams.stream().map(d -> d.getStoreCode() + d.getItemType2() + d.getYear() + d.getMonth()).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> demandCalendarDOS = this.storeDemandCalendarDomainService.findByConcatYearAndMonthKey(concatKey);
        if (CollectionUtils.isNotEmpty(demandCalendarDOS)) {
            List<Long> ids = demandCalendarDOS.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
            this.storeDemandCalendarDomainService.deleteBatch(ids);
        }
    }

    @Override
    @SysCodeProc
    public ScpStoreDemandCalendarRespVO findStoreCalendarDetail(ScpStoreDemandCalendarParamVO param) {
        ScpStoreDemandCalendarRespVO vo = new ScpStoreDemandCalendarRespVO();
        List<ScpStoreDemandCalendarDTO> calendarDOS = this.storeDemandCalendarDomainService.findStoreCalendarByParam(param);
        if (CollectionUtils.isEmpty(calendarDOS)) {
            return vo;
        }
        if (param.getMonth() != null && param.getYear() != null) {
            List calendarRespVOS = calendarDOS.stream().map(ScpStoreDemandCalendarConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            ScpStoreDemandCalendarRespVO calendarRespVO = (ScpStoreDemandCalendarRespVO)calendarRespVOS.get(0);
            BeanCopyUtil.beanCopyWithIngore((Object)calendarRespVO, (Object)vo, (String[])BeanCopyUtil.getNullAndIgnorePropertyNames((Object)calendarRespVO, (String[])new String[0]));
            List<ScpStoreDemandCalendarRespVO> vos = calendarRespVOS.stream().filter(d -> d.getDay() != null).sorted(this.getComparing2()).collect(Collectors.toList());
            vo.setDayDetails(vos);
            List<String> years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            List<String> days = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getDay).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
            vo.setExistDaysOfMonth(days);
        } else if (param.getYear() != null && param.getMonth() == null) {
            List<String> years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
        } else if (param.getYear() == null && param.getMonth() == null) {
            List<String> years = calendarDOS.stream().map(ScpStoreDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
        }
        return vo;
    }

    @Override
    public Boolean isExistStoreByDateAndWorkStatus(ScpCalendarStoreQueryParamVO paramVO) {
        return CollectionUtils.isNotEmpty(this.storeDemandCalendarDomainService.listStoreByQueryParam(paramVO));
    }

    @Override
    public List<ScpCalendarStoreRespVO> listCalendarStoreByParam(ScpCalendarStoreQueryParamVO paramVO) {
        return this.storeDemandCalendarDomainService.listStoreByQueryParam(paramVO);
    }

    private Comparator<ScpStoreDemandCalendarRespVO> getComparing2() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public ScpStoreDemandCalendarServiceImpl(ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService, ScpDemandAuthorityService scpDemandAuthorityService, ScpOrderSettingService scpOrderSettingService) {
        this.storeDemandCalendarDomainService = storeDemandCalendarDomainService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.scpOrderSettingService = scpOrderSettingService;
    }
}

