/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.cart;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.sale.api.vo.resp.crm.GiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcParam;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusAllParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartClearParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartCountParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartDeleteItemParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartToOrderFailRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartToOrderSuccessRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckParamVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderConfirmRespVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartQueryParamVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.domain.convert.cart.ScpStoreCartConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.rmi.RmiSalService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import io.seata.common.util.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

@Service
public class ScpStoreCartServiceImpl
implements ScpStoreCartService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCartServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final RmiItemService rmiItemService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ItmItemRpcService itmItemRpcService;
    private final ScpStoreOrderFreightService scpStoreOrderFreightService;
    private final RmiSalService rmiSalService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpOrderSettingService scpOrderSettingService;

    @Override
    public List<CartDetailRespVO> detail(CartDetailParamVO paramVO) {
        Long currentUserId;
        String cartType;
        String storeCode = paramVO.getDemandWhStCode();
        List<ScpStoreCartDO> cartDOS = this.cartRedisUtil.getStoreCartItems(storeCode, cartType = paramVO.getCartType(), currentUserId = UserService.currentUserId());
        if (CollUtil.isEmpty(cartDOS)) {
            return new ArrayList<CartDetailRespVO>();
        }
        List<String> keyList = cartDOS.stream().map(cartSaveVO -> cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + this.getTwoDigitMonth() + LocalDate.now().getDayOfMonth()).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> existList = this.storeDemandCalendarDomainService.findByStoreDayCalendar(keyList);
        cartDOS.forEach(cartSaveVO -> {
            Optional<ScpStoreDemandCalendarDO> e;
            if (CollUtil.isEmpty((Collection)existList)) {
                cartSaveVO.setInOrderCycle(false);
            }
            if ((e = existList.stream().filter(a -> a.getStoreCode().equals(cartSaveVO.getDemandWhStCode()) && a.getItemType2().equals(cartSaveVO.getDocType())).findAny()).isEmpty()) {
                cartSaveVO.setInOrderCycle(false);
            }
            if (e.isPresent() && e.get().getWorkStatus().equals("E")) {
                cartSaveVO.setInOrderCycle(false);
            } else {
                cartSaveVO.setInOrderCycle(e.isPresent() && e.get().getWorkStatus().equals("W"));
            }
        });
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(cartType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = cartDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            priceParamVO.setCombineItemCode(row.getCombineItemCode());
            priceParamVO.setCombineItemFlag(row.getCombineItemFlag());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), stockMapRef);
        ArrayList<CartDetailRespVO> resultList = new ArrayList<CartDetailRespVO>();
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuMap = cartDOS.stream().collect(Collectors.groupingBy(a -> a.getSpuCode() + "/" + a.getCombineItemCode()));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuMap.entrySet()) {
            CartDetailRespVO vo = new CartDetailRespVO();
            List<ScpStoreCartDO> storeCartDOS = entry.getValue();
            ScpStoreCartDO storeCartDO = storeCartDOS.get(0);
            vo.setSpuId(storeCartDO.getSpuId());
            vo.setSpuCode(storeCartDO.getSpuCode());
            vo.setSpuName(storeCartDO.getSpuName());
            vo.setSpec(storeCartDO.getSpec());
            vo.setUrl(storeCartDO.getUrl());
            vo.setAnotherName(storeCartDO.getAnotherName());
            vo.setCombineItemCode(storeCartDO.getCombineItemCode());
            vo.setCombineItemName(storeCartDO.getCombineItemName());
            vo.setCombineItemFlag(storeCartDO.getCombineItemFlag());
            vo.setCombineQty(SysUtils.processStoreQtyScale(storeCartDO.getCombineQty()));
            vo.setCollectFlag(this.collectRedisUtil.existsSpuInUser(storeCode, currentUserId, SysUtils.getItemKey(storeCartDO.getCombineItemCode(), storeCartDO.getItemCode())));
            ArrayList<CartDetailRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<CartDetailRespVO.ItemSpecObjectVO>();
            for (ScpStoreCartDO scpCartDO : storeCartDOS) {
                List<PriPriceRpcDTO> priPriceRpcDTOS2;
                CartDetailRespVO.ItemSpecObjectVO detailVo = new CartDetailRespVO.ItemSpecObjectVO();
                detailVo.setUom(scpCartDO.getUom());
                detailVo.setUomName(scpCartDO.getUomName());
                detailVo.setItemId(scpCartDO.getItemId());
                detailVo.setItemCode(scpCartDO.getItemCode());
                detailVo.setItemName(scpCartDO.getItemName());
                List<PriPriceRpcDTO> priPriceRpcDTOS = priceMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()));
                if (CollUtil.isNotEmpty(priPriceRpcDTOS)) {
                    detailVo.setItemPrice(priPriceRpcDTOS.get(0).getPrice());
                }
                if (scpCartDO.getCombineItemFlag() != null && scpCartDO.getCombineItemFlag().booleanValue() && StringUtils.isEmpty((CharSequence)scpCartDO.getCombineItemCode()) && CollUtil.isNotEmpty(priPriceRpcDTOS2 = priceMap.get(SysUtils.getItemKey(scpCartDO.getItemCode(), scpCartDO.getItemCode())))) {
                    detailVo.setItemPrice(priPriceRpcDTOS2.get(0).getPrice());
                }
                detailVo.setQty(SysUtils.processStoreQtyScale(scpCartDO.getQty()));
                detailVo.setCombineQty(SysUtils.processStoreQtyScale(scpCartDO.getCombineQty()));
                detailVo.setStatus(scpCartDO.getSelectedStatus());
                detailVo.setUom2(scpCartDO.getUom2());
                detailVo.setUom2Name(scpCartDO.getUom2Name());
                detailVo.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                detailVo.setUomRatio(scpCartDO.getUomRatio());
                detailVo.setItemAttrName(scpCartDO.getItemAttrName());
                if (stockMap.containsKey(scpCartDO.getItemCode())) {
                    detailVo.setAvalQty(stockMap.get(scpCartDO.getItemCode()));
                } else {
                    detailVo.setAvalQty(BigDecimal.ZERO);
                }
                detailVo.setMoq(scpCartDO.getMoq());
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            boolean allSelected = itemSpecObjectVOS.stream().allMatch(item -> item.getStatus() != null && item.getStatus().equals(1));
            vo.setStatus(allSelected ? 1 : 0);
            BigDecimal totalAmt = itemSpecObjectVOS.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getItemPrice())).map(CartDetailRespVO.ItemSpecObjectVO::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalAmt(totalAmt);
            vo.setInOrderCycle(storeCartDO.getInOrderCycle());
            resultList.add(vo);
        }
        this.refreshCartPrice(paramVO, currentUserId, cartDOS, priceMap);
        List<CartDetailRespVO> itemResultList = resultList.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<CartDetailRespVO>> subItemMap = resultList.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(CartDetailRespVO::getCombineItemCode));
        if (CollectionUtils.isNotEmpty(itemResultList)) {
            List<CartDetailRespVO> combineItemList = itemResultList.stream().filter(a -> Objects.nonNull(a.getCombineItemFlag()) && a.getCombineItemFlag() != false).collect(Collectors.toList());
            combineItemList.forEach(d -> {
                ArrayList<CartDetailRespVO> subItemList = new ArrayList<CartDetailRespVO>();
                d.getItemSpecObjectVOS().forEach(item -> {
                    List cartDetailRespVOS = (List)subItemMap.get(item.getItemCode());
                    subItemList.addAll(cartDetailRespVOS);
                });
                d.setSubItemList(subItemList);
                BigDecimal mainStkQty = BigDecimal.ZERO;
                for (int i = 0; i < d.getSubItemList().size(); ++i) {
                    BigDecimal qty;
                    CartDetailRespVO detail = d.getSubItemList().get(i);
                    if (detail == null) continue;
                    BigDecimal avalQty = stockMap.getOrDefault(detail.getItemSpecObjectVOS().get(0).getItemCode(), BigDecimal.ZERO);
                    if (!Boolean.TRUE.equals(detail.getCombineItemFlag()) || (qty = detail.getCombineQty()) == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal divide = avalQty.divide(qty, 0, RoundingMode.FLOOR);
                    if (i == 1) {
                        mainStkQty = divide;
                        continue;
                    }
                    if (divide.compareTo(mainStkQty) >= 0) continue;
                    mainStkQty = divide;
                }
                if (d.getCombineItemFlag() != null && d.getCombineItemFlag().booleanValue()) {
                    d.getItemSpecObjectVOS().get(0).setAvalQty(mainStkQty);
                }
            });
            List spuIds = itemResultList.stream().map(CartDetailRespVO::getSpuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List skuImgByItemIds = this.itmItemRpcService.findSkuImgByItemIds(spuIds);
            if (CollectionUtils.isNotEmpty((Collection)skuImgByItemIds)) {
                Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
                itemResultList.forEach(d -> {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)listMap.get(d.getSpuId())))) {
                        d.setFileCode(((ItmItemAttachmentProviderDTO)((List)listMap.get(d.getSpuId())).get(0)).getFileCode());
                    }
                });
            }
        }
        return itemResultList;
    }

    private void refreshCartPrice(CartDetailParamVO paramVO, Long currentUserId, List<ScpStoreCartDO> cartDOS, Map<String, List<PriPriceRpcDTO>> priceMap) {
        BoundHashOperations<String, Object, Object> storeCartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        for (ScpStoreCartDO cartDO : cartDOS) {
            List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(cartDO.getItemCode());
            if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                cartDO.setItemPrice(SysUtils.processPriceScale(priceRpcDTOS.get(0).getPrice()));
            }
            storeCartOps.put((Object)SysUtils.generateRedisKey("SKU", cartDO.getCombineItemCode(), cartDO.getItemCode()), (Object)JSONUtil.toJsonStr((Object)cartDO));
        }
    }

    @Override
    public Map<String, Integer> getCartCount(StoreCartQueryParamVO param) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Long currentUserId = UserService.currentUserId();
        List<ScpOrderSettingRespVO> enabledSettings = this.scpOrderSettingDomainService.findEnabledSetting();
        for (ScpOrderSettingRespVO setting : enabledSettings) {
            List<ScpStoreCartDO> cartDOS = this.cartRedisUtil.getStoreCartItems(param.getDemandWhStCode(), setting.getDocType(), currentUserId);
            cartDOS = cartDOS.stream().filter(cartDO -> StringUtils.isBlank((CharSequence)cartDO.getCombineItemCode())).collect(Collectors.toList());
            result.put(setting.getDocType(), CollUtil.isNotEmpty(cartDOS) ? cartDOS.size() : 0);
        }
        result.values().stream().reduce(Integer::sum).ifPresent(total -> result.put("total", (Integer)total));
        return result;
    }

    @Override
    public String saveCart(StoreCartSaveVO cartSaveVO) {
        ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
        scpOrderSettingParamVO.setItemCate(cartSaveVO.getItemType());
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = this.scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
        if (!CollUtil.isEmpty(scpOrderSettingRespVOS)) {
            cartSaveVO.setDocType(scpOrderSettingRespVOS.get(0).getDocType());
        }
        String key = cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + this.getTwoDigitMonth() + LocalDate.now().getDayOfMonth();
        List<ScpStoreDemandCalendarDO> existList = this.storeDemandCalendarDomainService.findByStoreDayCalendar(List.of(key));
        Object msg = "";
        if (CollUtil.isEmpty(existList) || existList.get(0).getWorkStatus().equals("E")) {
            msg = "\u8be5\u5546\u54c1[" + cartSaveVO.getItemName() + "]\u4e0d\u5728\u8ba2\u8d27\u5468\u671f\uff0c\u65e0\u6cd5\u4e0b\u5355";
        }
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        ScpStoreCartServiceImpl.saveOrUpdateCart(cartSaveVO, cartOps);
        return msg;
    }

    @Override
    public void clearCart(CartClearParamVO clearParamVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(clearParamVO.getDemandWhStCode(), clearParamVO.getCartType(), currentUserId);
        Set keys = cartOps.keys();
        if (CollUtil.isNotEmpty((Collection)keys)) {
            cartOps.delete(keys.toArray());
        }
    }

    private String getTwoDigitMonth() {
        LocalDate date = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
        return date.format(formatter);
    }

    @Override
    public String batchSaveCart(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS) {
        ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = this.scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
        cartSaveVOS.forEach(cartSaveVO -> scpOrderSettingRespVOS.stream().filter(scpOrderSettingRespVO -> scpOrderSettingRespVO.getItemCates().contains(cartSaveVO.getItemType())).findAny().ifPresent(a -> cartSaveVO.setDocType(a.getDocType())));
        List<String> keyList = cartSaveVOS.stream().map(cartSaveVO -> cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + this.getTwoDigitMonth() + LocalDate.now().getDayOfMonth()).collect(Collectors.toList());
        List<ScpStoreDemandCalendarDO> existList = this.storeDemandCalendarDomainService.findByStoreDayCalendar(keyList);
        List<Object> itemNameList = new ArrayList();
        if (CollUtil.isEmpty(existList)) {
            itemNameList = cartSaveVOS.stream().map(StoreCartSaveVO::getItemName).collect(Collectors.toList());
        }
        ArrayList finalItemNameList = itemNameList;
        cartSaveVOS.forEach(cartSaveVO -> {
            Optional<ScpStoreDemandCalendarDO> e = existList.stream().filter(a -> a.getStoreCode().equals(cartSaveVO.getDemandWhStCode()) && a.getItemType2().equals(cartSaveVO.getDocType())).findAny();
            if (e.isEmpty()) {
                finalItemNameList.add(cartSaveVO.getItemName());
            }
            if (e.isPresent() && e.get().getWorkStatus().equals("E")) {
                finalItemNameList.add(cartSaveVO.getItemName());
            }
        });
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(storeCode, cartType, currentUserId);
        cartSaveVOS.forEach(cartSaveVO -> ScpStoreCartServiceImpl.saveOrUpdateCart(cartSaveVO, cartOps));
        if (CollUtil.isNotEmpty(itemNameList)) {
            return "\u8be5\u5546\u54c1[" + itemNameList + "]\u4e0d\u5728\u8ba2\u8d27\u5468\u671f\uff0c\u65e0\u6cd5\u4e0b\u5355";
        }
        return "";
    }

    @Override
    public void deleteItem(CartDeleteItemParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        for (CartDeleteItemParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (String itemKey : vo.getItemKeys()) {
                BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", itemKey)});
            }
        }
    }

    @Override
    public CartDataSummaryRespVO dataSummary(CartDataSummaryParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> scpCartDOS = this.cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        if (CollUtil.isEmpty(scpCartDOS)) {
            return new CartDataSummaryRespVO().setItemTypeNum(0).setQtyTotal(BigDecimal.ZERO).setAmtTotal(BigDecimal.ZERO);
        }
        List filteredCartDOS = scpCartDOS.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<ScpStoreCartDO>> spuMap = filteredCartDOS.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        CartDataSummaryRespVO resultVo = new CartDataSummaryRespVO();
        resultVo.setItemTypeNum(spuMap.size());
        BigDecimal qty = filteredCartDOS.stream().map(ScpStoreCartDO::getQty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmt = filteredCartDOS.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getItemPrice())).map(ScpStoreCartDO::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultVo.setQtyTotal(SysUtils.processQtyScale(qty));
        resultVo.setAmtTotal(SysUtils.processAmtScale(totalAmt));
        return resultVo;
    }

    @Override
    public void changeSelectedStatus(CartChangeSelectedStatusParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        String demandWhStCode = paramVO.getDemandWhStCode();
        for (CartChangeSelectedStatusParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (CartChangeSelectedStatusParamVO.InnerItemSpecObjectVO item : vo.getInnerItemSpecObjectVOS()) {
                if (item.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ScpStoreCartDO cartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()), demandWhStCode, paramVO.getCartType(), currentUserId);
                if (cartItem == null) {
                    log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u7269\u6599\uff1a{},\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66\u91cd\u8bd5", (Object)item.getItemId());
                    continue;
                }
                cartItem.setSelectedStatus(item.getStatus());
                String redisValue = JSON.toJSONString((Object)cartItem);
                BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", item.getCombineItemCode(), item.getItemCode()), (Object)redisValue);
            }
        }
    }

    @Override
    public void changeSelectedStatusAll(CartChangeSelectedStatusAllParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartItems = this.cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        cartItems.forEach(row -> {
            row.setSelectedStatus(paramVO.getStatus());
            String redisValue = JSON.toJSONString((Object)row);
            cartOps.put((Object)SysUtils.generateRedisKey("SKU", row.getCombineItemCode(), row.getItemCode()), (Object)redisValue);
        });
    }

    @Override
    public void updateCount(CartCountParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        BoundHashOperations<String, Object, Object> cartOps = this.cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartCountParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartCountParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                if (product == null) {
                    log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u7269\u6599\uff1a{},\u8bf7\u5237\u65b0\u8d2d\u7269\u8f66\u91cd\u8bd5", (Object)itemSpecObjectVO.getItemId());
                    continue;
                }
                if (itemSpecObjectVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode())});
                    continue;
                }
                ScpStoreCartDO storeCartDO = (ScpStoreCartDO)JSON.parseObject((String)product, ScpStoreCartDO.class);
                storeCartDO.setQty(itemSpecObjectVO.getQty());
                String cartItemJson = JSON.toJSONString((Object)storeCartDO);
                cartOps.put((Object)SysUtils.generateRedisKey("SKU", itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), (Object)cartItemJson);
            }
        }
    }

    @Override
    public OrderCheckRespVO order(OrderCheckParamVO paramVO) {
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        ArrayList<CartToOrderSuccessRespVO> successList = new ArrayList<CartToOrderSuccessRespVO>();
        ArrayList<CartToOrderFailRespVO> failList = new ArrayList<CartToOrderFailRespVO>();
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = this.rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("\u8bf7\u5148\u914d\u7f6e\u6216\u542f\u7528\u5355\u636e\u7c7b\u578b:" + paramVO.getDocType());
        }
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> dataList = this.cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getDocType(), currentUserId);
        if (CollUtil.isEmpty(dataList)) {
            log.info("\u7528\u6237:{},\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a", (Object)currentUserId);
            return new OrderCheckRespVO();
        }
        List filerCarts = dataList.stream().filter(row -> Objects.nonNull(row.getCombineItemFlag()) && row.getCombineItemFlag() != false && StringUtils.isEmpty((CharSequence)row.getCombineItemCode())).collect(Collectors.toList());
        dataList.removeAll(filerCarts);
        this.addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, dataList);
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        List<String> itemCodes = dataList.stream().map(ScpStoreCartDO::getItemCode).collect(Collectors.toList());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), itemCodes);
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<OrderConfirmRespVO> confirmRespVOS = new ArrayList<OrderConfirmRespVO>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        block2: for (ScpStoreCartDO cartDO : dataList) {
            ArrayList<OrderConfirmRespVO> inConfirmList = new ArrayList<OrderConfirmRespVO>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.suppAllocStrategy(cartDO, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(this.whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
                }
                if (inConfirmList.isEmpty()) continue;
                confirmRespVOS.addAll(inConfirmList);
                continue block2;
            }
        }
        Map<String, List<OrderConfirmRespVO>> confirmMap = this.buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(confirmRespVOS);
        CompletableFuture<List> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty((Collection)priceParamList)) {
                return new ArrayList();
            }
            return this.rmiPriceRpcService.findPriceByParam(priceParamList);
        }, (Executor)this.taskExecutor);
        ArrayList param = new ArrayList();
        List<ScpStoreCartDO> scpStoreCartDOList = dataList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCombineItemCode())).collect(Collectors.toList());
        scpStoreCartDOList.forEach(item -> {
            ItmBomPriceRpcDtoParam item2 = new ItmBomPriceRpcDtoParam();
            item2.setItemCode(item.getItemCode());
            item2.setCombineItemCode(item.getCombineItemCode());
            item2.setUom(item.getUom());
            param.add(item2);
        });
        CompletableFuture<List> subItemPriceFuture1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty((Collection)priceParamList)) {
                return new ArrayList();
            }
            return this.rmiPriceRpcService.findBomPriceByParam(param);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.getWhStockMap(stockParam, stockMapRef, confirmRespVOS), (Executor)this.taskExecutor);
        List<ScpStoreCartDO> finalDataList = dataList;
        CompletableFuture<Map> future3 = CompletableFuture.supplyAsync(() -> this.getItemMoq(orgStore.getOuCode(), finalDataList), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2, future3, subItemPriceFuture1).join();
        List<PriPriceRpcDTO> priceList = new ArrayList();
        Map itemMoqMap = new HashMap();
        try {
            priceList = future1.get();
            priceList.addAll(subItemPriceFuture1.get());
            itemMoqMap = future3.get();
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u548c\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\u62a5\u9519\uff1a" + e.toString());
        }
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode) || list.get(0).getActivityCode() != null) continue;
            ItmItemSpuBusinessRpcDTO itemInfo = (ItmItemSpuBusinessRpcDTO)((List)itemMoqMap.get(spuCode)).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            if (itemInfo.getMoq() == null || totalQty.compareTo(itemInfo.getMoq()) >= 0) continue;
            throw new BusinessException("\u5546\u54c1\uff1a" + list.get(0).getItemName() + "\u5c0f\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf");
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = this.buildPriceMap(priceList, priceParamList);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuCodeMap = dataList.stream().collect(Collectors.groupingBy(a -> a.getSpuCode() + "@" + a.getCombineItemCode()));
        ArrayList<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<ScpDemandOrderDSaveVO>();
        ArrayList<ScpDemandOrderDSaveVO> saveGiftVOList = new ArrayList<ScpDemandOrderDSaveVO>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        ScpStoreOrderFreightPageParamVO orderFreightModelQueryParam = new ScpStoreOrderFreightPageParamVO();
        orderFreightModelQueryParam.setStoreCodes(Arrays.asList("ALL", demandWhStCode));
        List<ScpStoreOrderFreightPageRespVO> orderFreightModels = this.scpStoreOrderFreightService.listStoreOrderFreight(orderFreightModelQueryParam);
        Boolean freeFreightFlag = this.calculateFreeFreightFlag(paramVO.getDocType(), dataList);
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());
            successVO.setCombineItemFlag(first.getCombineItemFlag());
            successVO.setCombineItemCode(first.getCombineItemCode());
            successVO.setCombineItemName(first.getCombineItemName());
            ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<CartToOrderSuccessRespVO.ItemSpecObjectVO>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                String itemCode = scpCartDO.getItemCode();
                String activityCode = scpCartDO.getActivityCode();
                List<OrderConfirmRespVO> confirmList = confirmMap.get(itemCode + scpCartDO.getCombineItemCode() + activityCode);
                if (CollUtil.isEmpty(confirmList)) {
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("\u5339\u914d\u4e0d\u5230\u4ed3\u5e93\u6216\u4f9b\u5e94\u5546");
                    failList.add(failVO);
                    continue;
                }
                ArrayList<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<CartToOrderSuccessRespVO.WhAllocObject>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
                    String ouCode = orderConfirmRespVO.getSaleOuCode();
                    if (StrUtil.isBlank((CharSequence)ouCode)) {
                        whAllocObject.setItemPrice(BigDecimal.ZERO);
                    } else {
                        List<PriPriceRpcDTO> priceRpcDTOS = StringUtils.isNotEmpty((CharSequence)scpCartDO.getCombineItemCode()) ? priceMap.get(orderConfirmRespVO.getItemCode() + "@" + scpCartDO.getCombineItemCode() + "@null") : priceMap.get(orderConfirmRespVO.getItemCode() + "@null@" + ouCode);
                        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                            whAllocObject.setItemPrice(priceRpcDTOS.get(0).getPrice());
                        } else {
                            log.info("\u8be5\u5546\u54c1\u65e0\u4ef7\u683c, \u7f16\u7801:{},\u540d\u79f0:{}", (Object)itemCode, (Object)scpCartDO.getItemName());
                            CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                            failVO.setItemCode(scpCartDO.getItemCode());
                            failVO.setItemName(scpCartDO.getItemName());
                            failVO.setMsg("\u8be5\u5546\u54c1\u65e0\u4ef7\u683c");
                            failList.add(failVO);
                            continue;
                        }
                    }
                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType())) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank((CharSequence)activityCode)) continue;
                                throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u53ef\u7528\u91cf\u4e3a:" + avalQty + ",\u4e0d\u53ef\u8d85\u8fc7\u8be5\u6570\u91cf");
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (!StrUtil.isBlank((CharSequence)activityCode)) continue;
                            throw new BusinessException("\u5546\u54c1\u3010" + scpCartDO.getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    if (!freeFreightFlag.booleanValue()) {
                        ScpStoreCartServiceImpl.buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList, orderFreightModels);
                    }
                    this.buildSimpleGiftOrderItem(scpCartDO, whAllocObject, saveGiftVOList, orgStore, successList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) continue;
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode(activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (!CollUtil.isNotEmpty(itemSpecObjectVOS)) continue;
            successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            successList.add(successVO);
        }
        if (CollUtil.isNotEmpty(saveVOList)) {
            this.buildFreightItem(saveVOList, resultVO, successList);
        }
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.size() == 0);
        Integer itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item2 : order.getItemSpecObjectVOS()) {
                itemTypeNum = itemTypeNum + 1;
                qtyTotal.updateAndGet(v -> v.add(item2.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item2.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());
        return resultVO;
    }

    private Boolean calculateFreeFreightFlag(String docType, List<ScpStoreCartDO> dataList) {
        BigDecimal totalAmt;
        ScpOrderSettingParamVO orderSettingParamVO = new ScpOrderSettingParamVO();
        orderSettingParamVO.setDocType(docType);
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = this.scpOrderSettingService.queryOrderSettingList(orderSettingParamVO);
        ScpOrderSettingRespVO scpOrderSettingRespVO = !CollUtil.isEmpty(scpOrderSettingRespVOS) ? scpOrderSettingRespVOS.get(0) : null;
        if (scpOrderSettingRespVO != null && scpOrderSettingRespVO.getFreeFreightFlag().booleanValue() && scpOrderSettingRespVO.getFreeFreightAmt() != null && (totalAmt = dataList.stream().filter(row -> row.getTotalAmt() != null).map(ScpStoreCartDO::getTotalAmt).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))).compareTo(scpOrderSettingRespVO.getFreeFreightAmt()) > -1) {
            return true;
        }
        return false;
    }

    private Map<String, List<ItmItemSpuBusinessRpcDTO>> getItemMoq(String storeOuCode, List<ScpStoreCartDO> dataList) {
        List<String> spuCodes = dataList.stream().map(ScpStoreCartDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = this.rmiItemService.findMoqByParam(spuCodes, storeOuCode);
        return moqMap;
    }

    private void addAllocSettingItem(Long currentUserId, String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List itemTypes = StrUtil.split((CharSequence)orderSetting.getItemCate(), (CharSequence)",");
        List<ScpAllocSettingItemRespVO> allocSettingItemList = this.scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(demandWhStCode, orderSetting.getDocType(), itemTypes);
        List itemIds = allocSettingItemList.stream().map(ScpAllocSettingItemRespVO::getItemId).collect(Collectors.toList());
        if (CollUtil.isEmpty(itemIds)) {
            return;
        }
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemIds(itemIds);
        List<ItmItemBaseRpcDTO> itemList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        Map itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        List allocItemList = allocSettingItemList.stream().map(row -> {
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = (ItmItemBaseRpcDTO)itemMap.get(row.getItemId());
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setUserId(currentUserId);
            storeCartDO.setDemandWhStCode(demandWhStCode);
            storeCartDO.setItemId(row.getItemId());
            storeCartDO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            storeCartDO.setItemName(itmItemBaseRpcDTO.getItemName());
            storeCartDO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
            storeCartDO.setUom(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUomName(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setSpuId(itmItemBaseRpcDTO.getSpuId());
            storeCartDO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
            storeCartDO.setSpuName(itmItemBaseRpcDTO.getSpuName());
            storeCartDO.setSpec(itmItemBaseRpcDTO.getSpec());
            storeCartDO.setQty(row.getMinNum());
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setUom2(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUom2Name(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            storeCartDO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
            storeCartDO.setItemType(itmItemBaseRpcDTO.getItemType2());
            storeCartDO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
            storeCartDO.setActivityCode(row.getActivityCode());
            storeCartDO.setActivityId(row.getMasId());
            storeCartDO.setItemCateCode(itmItemBaseRpcDTO.getItemCateCode());
            storeCartDO.setMinNum(row.getMinNum());
            storeCartDO.setUrl(row.getImgUrl());
            return storeCartDO;
        }).collect(Collectors.toList());
        dataList.addAll(allocItemList);
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<OrderConfirmRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("\u67e5\u8be2\u5e93\u5b58\u5546\u54c1\u6216\u8005\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u65e0\u9700\u67e5\u8be2");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap, List<OrderConfirmRespVO> confirmRespVOS) {
        if (stkRpcParam == null) {
            return;
        }
        Map itemCodeAndWhId = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).collect(Collectors.groupingBy(OrderConfirmRespVO::getItemCode, Collectors.mapping(OrderConfirmRespVO::getSuppWhId, Collectors.toList())));
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isNotEmpty(invWhItemTotalStkRpcDTOS)) {
            for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
                List longs = itemCodeAndWhId.get(dto.getItemCode());
                if (!longs.contains(dto.getWhId())) continue;
                stockMap.updateAndGet(currentMap -> {
                    currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                    return currentMap;
                });
            }
        }
    }

    private void buildFreightItem(List<ScpDemandOrderDSaveVO> saveVOList, OrderCheckRespVO resultVO, List<CartToOrderSuccessRespVO> successList) {
        ArrayList<CartToOrderSuccessRespVO> freightItemList = new ArrayList<CartToOrderSuccessRespVO>();
        String itemCode = SysUtils.getOrderItemSetting();
        String orderItemImgUrlSetting = SysUtils.getOrderItemImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("\u8fd0\u8d39\u5546\u54c1\u7f16\u7801\uff1a" + itemCode + "\u4e0d\u5b58\u5728");
        }
        ItmItemBaseRpcDTO shipmentItem = itemBaseRpcDTOList.get(0);
        Map<String, List<ScpDemandOrderDSaveVO>> whCodeMap = saveVOList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode()));
        BigDecimal freightAmt = BigDecimal.ZERO;
        for (Map.Entry<String, List<ScpDemandOrderDSaveVO>> entry : whCodeMap.entrySet()) {
            List<ScpDemandOrderDSaveVO> list = entry.getValue();
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            ScpDemandOrderDSaveVO oldSaveVO = list.get(0);
            BigDecimal amt = list.stream().filter(row -> row.getPlanAmt() != null).map(ScpDemandOrderDSaveVO::getPlanAmt).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            whAllocObject.setItemPrice(SysUtils.processAmtScale(amt));
            whAllocObject.setRatio(oldSaveVO.getRatio());
            whAllocObject.setQty(BigDecimal.ONE);
            whAllocObject.setOuId(oldSaveVO.getOuId());
            whAllocObject.setOuCode(oldSaveVO.getOuCode());
            whAllocObject.setOuName(oldSaveVO.getOuName());
            whAllocObject.setSupplyType(oldSaveVO.getSupplyType());
            whAllocObject.setSupplyWhCode(oldSaveVO.getSuppWhCode());
            whAllocObject.setSupplyWhId(oldSaveVO.getSuppWhId());
            whAllocObject.setSupplyWhName(oldSaveVO.getSuppWhName());
            whAllocObject.setFreightFlag(oldSaveVO.getFreightFlag());
            whAllocObject.setFreightRatio(oldSaveVO.getFreightRatio());
            whAllocObject.setSaleOuCode(oldSaveVO.getSaleOuCode());
            whAllocObject.setSaleOuName(oldSaveVO.getSaleOuName());
            whAllocObject.setSaleCustCode(oldSaveVO.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);
            itemSpecObjectVO.setItemId(shipmentItem.getId());
            itemSpecObjectVO.setItemCode(shipmentItem.getItemCode());
            itemSpecObjectVO.setItemName(shipmentItem.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(shipmentItem.getUom2());
            itemSpecObjectVO.setUomName(shipmentItem.getUom2Name());
            itemSpecObjectVO.setUom2(shipmentItem.getUom());
            itemSpecObjectVO.setUom2Name(shipmentItem.getUomName());
            itemSpecObjectVO.setDecimalPlaces(shipmentItem.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(shipmentItem.getUomRatio2());
            itemSpecObjectVO.setItemType(shipmentItem.getItemType2());
            itemSpecObjectVO.setItemAttrName(shipmentItem.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(whAllocObject.getItemPrice());
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);
            successVO.setSpuId(shipmentItem.getSpuId());
            successVO.setSpuCode(shipmentItem.getSpuCode());
            successVO.setSpuName(shipmentItem.getSpuName());
            successVO.setAnotherName(shipmentItem.getAnotherName());
            successVO.setSpec(shipmentItem.getSpec());
            successVO.setUrl(orderItemImgUrlSetting);
            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                freightItemList.add(successVO);
            }
            freightAmt = SysUtils.processAmtScale(freightAmt.add(amt));
        }
        resultVO.setFreightAmt(freightAmt);
        successList.addAll(freightItemList);
    }

    private static void buildSimpleOrderItem(ScpStoreCartDO scpCartDO, OrderConfirmRespVO orderConfirmRespVO, CartToOrderSuccessRespVO.WhAllocObject whAllocObject, List<ScpDemandOrderDSaveVO> saveVOList, List<ScpStoreOrderFreightPageRespVO> orderFreightModels) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setRatio(whAllocObject.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(whAllocObject.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSupplyWhName());
        scpDemandOrderDSaveVO.setDemandQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setPrice(whAllocObject.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(whAllocObject.getOuId());
        scpDemandOrderDSaveVO.setOuCode(whAllocObject.getOuCode());
        scpDemandOrderDSaveVO.setOuName(whAllocObject.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(scpCartDO.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(scpCartDO.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(scpCartDO.getUomRatio());
        if (!orderConfirmRespVO.getFreightFlag().booleanValue()) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)orderConfirmRespVO.getSaleOuCode())) {
            return;
        }
        String supplyType = orderConfirmRespVO.getSupplyType();
        String whCode = orderConfirmRespVO.getSuppWhCode();
        String storeCode = scpCartDO.getDemandWhStCode();
        String itemCode = scpCartDO.getItemCode();
        ScpStoreOrderFreightPageRespVO matchedConfig = ScpStoreCartServiceImpl.getMatchedOrderFreightConfig(supplyType, whCode, storeCode, itemCode, orderFreightModels);
        BigDecimal planAmount = BigDecimal.ZERO;
        BigDecimal freightRate = BigDecimal.ZERO;
        if (matchedConfig.getFreightRate() != null) {
            planAmount = SysUtils.processAmtScale(whAllocObject.getAmt().multiply(matchedConfig.getFreightRate().divide(BigDecimal.valueOf(100L))));
            freightRate = matchedConfig.getFreightRate().divide(BigDecimal.valueOf(100L));
        } else if (matchedConfig.getAmountPerQuantity() != null) {
            planAmount = matchedConfig.getAmountPerQuantity().multiply(whAllocObject.getQty());
            freightRate = planAmount.divide(whAllocObject.getAmt(), 8, RoundingMode.HALF_UP);
        }
        whAllocObject.setFreightRatio(freightRate);
        whAllocObject.setFreightAmt(planAmount);
        scpDemandOrderDSaveVO.setPlanAmt(planAmount);
        scpDemandOrderDSaveVO.setFreightFlag(whAllocObject.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(whAllocObject.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(whAllocObject.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(whAllocObject.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(whAllocObject.getSaleOuName());
        saveVOList.add(scpDemandOrderDSaveVO);
    }

    private void buildSimpleGiftOrderItem(ScpStoreCartDO scpCartDO, CartToOrderSuccessRespVO.WhAllocObject whAllocObjectMain, List<ScpDemandOrderDSaveVO> saveGiftVOList, OrgStoreBaseRpcDTO orgStore, List<CartToOrderSuccessRespVO> successList) {
        MktDiscountGiftRpcParam mktDiscountGiftRpcParam = new MktDiscountGiftRpcParam();
        mktDiscountGiftRpcParam.setItemCode(scpCartDO.getItemCode());
        mktDiscountGiftRpcParam.setOuCode(whAllocObjectMain.getSaleOuCode());
        mktDiscountGiftRpcParam.setCustCode(orgStore.getCustCode());
        mktDiscountGiftRpcParam.setNum(Long.valueOf(scpCartDO.getQty().longValue()));
        mktDiscountGiftRpcParam.setSum(scpCartDO.getTotalAmt());
        MktDiscountGiftRpcDTO discountGift = this.rmiSalService.findDiscountGift(mktDiscountGiftRpcParam);
        if (Objects.isNull(discountGift)) {
            return;
        }
        List gifts = discountGift.getGifts();
        if (CollUtil.isEmpty((Collection)gifts)) {
            return;
        }
        List itemCodes = gifts.stream().map(GiftRpcDTO::getItemCode).collect(Collectors.toList());
        if (CollUtil.isEmpty(itemCodes)) {
            return;
        }
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(itemCodes);
        List<ItmItemBaseRpcDTO> itemList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<Long> spuIds = itemList.stream().map(ItmItemBaseRpcDTO::getSpuId).collect(Collectors.toList());
        Map<String, Long> itemCodeIdMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, ItmItemBaseRpcDTO::getId));
        Map<String, Long> itemCodeSpuIdMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, ItmItemBaseRpcDTO::getSpuId));
        Map itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        List<ItmItemAttachmentProviderDTO> itemImages = this.rmiItemService.findSkuImgByItemIds(spuIds);
        Map<Long, String> itemImageMap = itemImages.stream().filter(ItmItemAttachmentProviderDTO::getMajor).collect(Collectors.toMap(ItmItemAttachmentProviderDTO::getItemId, ItmItemAttachmentProviderDTO::getUrl, (u1, u2) -> u1));
        for (GiftRpcDTO gift : gifts) {
            String itemCode = gift.getItemCode();
            Long itemId = itemCodeIdMap.get(itemCode);
            Long spuId = itemCodeSpuIdMap.get(itemCode);
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = (ItmItemBaseRpcDTO)itemMap.get(itemId);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            whAllocObject.setItemPrice(BigDecimal.ZERO);
            whAllocObject.setRatio(whAllocObjectMain.getRatio());
            whAllocObject.setQty(BigDecimal.ONE);
            whAllocObject.setOuId(whAllocObjectMain.getOuId());
            whAllocObject.setOuCode(whAllocObjectMain.getOuCode());
            whAllocObject.setOuName(whAllocObjectMain.getOuName());
            whAllocObject.setSupplyType(whAllocObjectMain.getSupplyType());
            whAllocObject.setSupplyWhCode(whAllocObjectMain.getSupplyWhCode());
            whAllocObject.setSupplyWhId(whAllocObjectMain.getSupplyWhId());
            whAllocObject.setSupplyWhName(whAllocObjectMain.getSupplyWhName());
            whAllocObject.setSaleOuCode(whAllocObjectMain.getSaleOuCode());
            whAllocObject.setSaleOuName(whAllocObjectMain.getSaleOuName());
            whAllocObject.setSaleCustCode(whAllocObjectMain.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);
            itemSpecObjectVO.setItemId(itmItemBaseRpcDTO.getId());
            itemSpecObjectVO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            itemSpecObjectVO.setItemName(itmItemBaseRpcDTO.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(itmItemBaseRpcDTO.getUom2());
            itemSpecObjectVO.setUomName(itmItemBaseRpcDTO.getUom2Name());
            itemSpecObjectVO.setUom2(itmItemBaseRpcDTO.getUom());
            itemSpecObjectVO.setUom2Name(itmItemBaseRpcDTO.getUomName());
            itemSpecObjectVO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            itemSpecObjectVO.setItemType(itmItemBaseRpcDTO.getItemType2());
            itemSpecObjectVO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(BigDecimal.ZERO);
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);
            successVO.setSpuId(itmItemBaseRpcDTO.getSpuId());
            successVO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
            successVO.setSpuName(itmItemBaseRpcDTO.getSpuName());
            successVO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
            successVO.setSpec(itmItemBaseRpcDTO.getSpec());
            successVO.setUrl(itemImageMap.get(spuId));
            successVO.setGiftFlag(true);
            successVO.setGiftBindItemId(scpCartDO.getItemId());
            if (!CollUtil.isNotEmpty(itemSpecObjectVOS)) continue;
            successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            successList.add(successVO);
        }
    }

    private static ScpStoreOrderFreightPageRespVO getMatchedOrderFreightConfig(String supplyType, String whCode, String storeCode, String itemCode, List<ScpStoreOrderFreightPageRespVO> orderFreightModels) {
        ScpStoreOrderFreightPageRespVO matchedConfig = null;
        if (supplyType.equals(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode())) {
            List modelList = orderFreightModels.stream().filter(e -> e.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode())).filter(e -> e.getWhCode() != null && !e.getWhCode().isBlank()).collect(Collectors.toList());
            matchedConfig = modelList.stream().filter(e -> whCode.equals(e.getWhCode()) && storeCode.equals(e.getStoreCode()) && itemCode.equals(e.getItemCode())).findFirst().orElse(null);
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> whCode.equals(e.getWhCode()) && "ALL".equalsIgnoreCase(e.getStoreCode()) && itemCode.equals(e.getItemCode())).findFirst().orElse(null);
            }
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> whCode.equals(e.getWhCode()) && storeCode.equals(e.getStoreCode()) && e.getItemCode() == null).findFirst().orElse(null);
            }
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> whCode.equals(e.getWhCode()) && "ALL".equalsIgnoreCase(e.getStoreCode()) && e.getItemCode() == null).findFirst().orElse(null);
            }
        } else {
            List modelList = orderFreightModels.stream().filter(e -> e.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode())).collect(Collectors.toList());
            matchedConfig = modelList.stream().filter(e -> storeCode.equals(e.getStoreCode()) && itemCode.equals(e.getItemCode())).findFirst().orElse(null);
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> "ALL".equalsIgnoreCase(e.getStoreCode()) && itemCode.equals(e.getItemCode())).findFirst().orElse(null);
            }
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> storeCode.equals(e.getStoreCode()) && e.getItemCode() == null).findFirst().orElse(null);
            }
            if (matchedConfig == null) {
                matchedConfig = modelList.stream().filter(e -> "ALL".equalsIgnoreCase(e.getStoreCode()) && e.getItemCode() == null).findFirst().orElse(null);
            }
        }
        if (matchedConfig == null) {
            throw new BusinessException("\u5b58\u5728\u672a\u8bbe\u7f6e\u8fd0\u8d39\u7684\u7269\u6599\uff0c\u4e0b\u5355\u5931\u8d25");
        }
        return matchedConfig;
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            this.getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<String, List<PriPriceRpcDTO>>();
            }
        } else {
            Map<String, List<PriPriceRpcDTO>> inPriceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            this.getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getCombineItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = (ItmPriPriceRpcDtoParam)BeanUtils.copyProperties((Object)row, ItmPriPriceRpcDtoParam.class, (String[])new String[0]);
            ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("\u67e5\u8be2\u57fa\u672c\u5355\u4f4d\u4ef7\u683c:{}", (Object)JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)BeanUtils.copyProperties((Object)row, PriPriceRpcDTO.class, (String[])new String[0]);
                ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)simpleItem.getDecimalPlaces(), 4));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private Map<String, List<OrderConfirmRespVO>> buildConfirmMap(List<OrderConfirmRespVO> confirmList) {
        if (CollUtil.isEmpty(confirmList)) {
            return new HashMap<String, List<OrderConfirmRespVO>>();
        }
        return confirmList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + row.getCombineItemCode() + row.getActivityCode()));
    }

    private List<OrderConfirmRespVO> suppAllocStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap, List<ItmPriPriceRpcDtoParam> priceParamList, AtomicReference<Map<String, BigDecimal>> stockMap) {
        ArrayList<OrderConfirmRespVO> result = new ArrayList<OrderConfirmRespVO>();
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("\u4f9b\u5e94\u5546\u914d\u989d\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<OrderConfirmRespVO>();
        }
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (orgStore.getFreightFlag2().booleanValue() && freightFlag.booleanValue()) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<OrderConfirmRespVO> whnetStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap, List<ItmPriPriceRpcDtoParam> priceParamList) {
        ArrayList<OrderConfirmRespVO> result = new ArrayList<OrderConfirmRespVO>();
        List<ScpWhNetRelationRpcDTO> whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("\u5546\u54c1\u7f16\u7801\uff1a{},\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u4fe1\u606f\uff1a{}", (Object)cartDO.getItemCode(), (Object)JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<OrderConfirmRespVO>();
        }
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank((CharSequence)row.getOuCode())) continue;
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode("CNY");
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency("CNY");
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            if (orgStore.getFreightFlag().booleanValue() && freightFlag.booleanValue()) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private static void saveOrUpdateCart(StoreCartSaveVO cartSaveVO, BoundHashOperations<String, Object, Object> cartOps) {
        String product = (String)cartOps.get((Object)SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
        if (StrUtil.isBlank((CharSequence)product) && cartSaveVO.getQty().compareTo(BigDecimal.ZERO) <= 0) {
            log.error("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u5546\u54c1:{}\uff0c\u8f93\u5165\u6570\u91cf\u9700\u8981\u5927\u4e8e\u96f6", (Object)cartSaveVO.getItemCode());
            throw new BusinessException("\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u6b64\u5546\u54c1\uff0c\u8f93\u5165\u6570\u91cf\u9700\u8981\u5927\u4e8e\u96f6");
        }
        if (StrUtil.isBlank((CharSequence)product)) {
            ScpStoreCartDO storeCartDO = ScpStoreCartConvert.INSTANCE.saveVoToDo(cartSaveVO);
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            cartOps.put((Object)SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()), (Object)JSON.toJSONString((Object)storeCartDO));
        } else if (cartSaveVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
            cartOps.delete(new Object[]{SysUtils.generateRedisKey("SKU", cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode())});
        } else {
            ScpStoreCartDO storeCartDO = (ScpStoreCartDO)JSON.parseObject((String)product, ScpStoreCartDO.class);
            storeCartDO.setQty(cartSaveVO.getQty());
            storeCartDO.setMoq(cartSaveVO.getMoq());
            String cartItemJson = JSON.toJSONString((Object)storeCartDO);
            cartOps.put((Object)SysUtils.generateRedisKey("SKU", storeCartDO.getCombineItemCode(), storeCartDO.getItemCode()), (Object)cartItemJson);
        }
    }

    public ScpStoreCartServiceImpl(CartRedisUtil cartRedisUtil, CollectRedisUtil collectRedisUtil, RmiItemService rmiItemService, RmiPriceRpcService rmiPriceRpcService, ScpSupplyAllocationService scpSupplyAllocationService, ScpWhNetRelationService scpWhNetRelationService, RmiOrgStoreRpcService rmiOrgStoreRpcService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService, RmiInvStkRpcService rmiInvStkRpcService, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService, ItmItemRpcService itmItemRpcService, ScpStoreOrderFreightService scpStoreOrderFreightService, RmiSalService rmiSalService, ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService, ScpOrderSettingService scpOrderSettingService) {
        this.cartRedisUtil = cartRedisUtil;
        this.collectRedisUtil = collectRedisUtil;
        this.rmiItemService = rmiItemService;
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.scpSupplyAllocationService = scpSupplyAllocationService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
        this.itmItemRpcService = itmItemRpcService;
        this.scpStoreOrderFreightService = scpStoreOrderFreightService;
        this.rmiSalService = rmiSalService;
        this.storeDemandCalendarDomainService = storeDemandCalendarDomainService;
        this.scpOrderSettingService = scpOrderSettingService;
    }
}

