/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppInvStkRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CommonPriceServiceImpl
implements CommonPriceService {
    private static final Logger log = LoggerFactory.getLogger(CommonPriceServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final RmiItemService rmiItemService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiInvStkRpcService rmiInvStkRpcService;

    @Override
    public Map<String, List<PriPriceRpcDTO>> getPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode, ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap) {
        List<PriPriceRpcDTO> bomPriceList;
        CopyOnWriteArrayList priceList = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<ItmBomPriceRpcDtoParam> bomPriceParams = new ArrayList<ItmBomPriceRpcDtoParam>();
        List<ScpStoreCartDO> dataList = paramVOList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            return storeCartDO;
        }).collect(Collectors.toList());
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findWhNetByParam(storeCode, type, dataList);
        List<String> itemCodes = paramVOList.stream().map(AppItemActivityItemPriceParamVO::getItemCode).distinct().collect(Collectors.toList());
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(storeCode, type, itemCodes);
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        ArrayList<AppInvStkRespVO> suppPriorityList = new ArrayList<AppInvStkRespVO>();
        ArrayList<AppInvStkRespVO> whPriorityList = new ArrayList<AppInvStkRespVO>();
        for (AppItemActivityItemPriceParamVO activity : paramVOList) {
            AppInvStkRespVO stkParam = new AppInvStkRespVO();
            for (String priority : priorities) {
                ItmPriPriceRpcDtoParam priceParam = null;
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    priceParam = this.buildSuppPriceParamList(supplyAllocationMap, activity, priceList, stkParam);
                    if (stkParam.getItemId() != null) {
                        suppPriorityList.add(stkParam);
                    }
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    priceParam = this.buildWhPriceParamList(whNetMap, activity, priceList, stkParam);
                    if (stkParam.getItemId() != null) {
                        whPriorityList.add(stkParam);
                    }
                }
                if (priceParam != null && priceParam.getItemCode() == null) break;
                if (priceParam == null || priceParam.getItemCode() == null) continue;
                priceParamList.add(priceParam);
                break;
            }
            if (!Boolean.TRUE.equals(activity.getCombineItemFlag())) continue;
            ItmBomPriceRpcDtoParam bomPriceParam = new ItmBomPriceRpcDtoParam();
            bomPriceParam.setItemCode(activity.getItemCode());
            bomPriceParam.setCombineItemCode(activity.getCombineItemCode());
            bomPriceParam.setUom(activity.getUom());
            bomPriceParams.add(bomPriceParam);
        }
        if (CollUtil.isEmpty(priceParamList) && CollUtil.isNotEmpty((Collection)priceList)) {
            this.queryInvStock(suppPriorityList, stockMap, whPriorityList);
            return priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
        }
        if (CollUtil.isEmpty(priceParamList) && CollUtil.isEmpty((Collection)priceList)) {
            return new HashMap<String, List<PriPriceRpcDTO>>();
        }
        if (stockMap == null) {
            return this.getItemPrice(priceParamList, priceList);
        }
        Map<Object, Object> bomPriceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bomPriceParams) && CollectionUtils.isNotEmpty(bomPriceList = this.rmiPriceRpcService.findBomAndMainItemPriceByParam(bomPriceParams))) {
            try {
                bomPriceMap = bomPriceList.stream().collect(Collectors.groupingBy(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode())));
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u5b50\u4ef6\u548c\u4e3b\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u5b50\u4ef6\u548c\u4e3b\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a" + e);
            }
        }
        CompletableFuture<Map> future1 = CompletableFuture.supplyAsync(() -> this.getItemPrice(priceParamList, priceList), (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.queryInvStock(suppPriorityList, stockMap, whPriorityList), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        try {
            bomPriceMap.putAll(future1.get());
            return bomPriceMap;
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a" + e.toString());
        }
    }

    private void queryInvStock(List<AppInvStkRespVO> suppPriorityList, AtomicReference<Map<String, BigDecimal>> stockMap, List<AppInvStkRespVO> whPriorityList) {
        if (stockMap == null) {
            return;
        }
        for (AppInvStkRespVO stk : suppPriorityList) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(stk.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
        }
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(whPriorityList);
        this.getWhStockMap(stockParam, stockMap, whPriorityList);
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<AppInvStkRespVO> whPriorityList) {
        if (CollUtil.isNotEmpty(whPriorityList)) {
            List itemIds = whPriorityList.stream().map(AppInvStkRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List whIds = whPriorityList.stream().map(AppInvStkRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap, List<AppInvStkRespVO> whPriorityList) {
        if (stkRpcParam == null) {
            return;
        }
        Map itemCodeAndWhId = whPriorityList.stream().collect(Collectors.groupingBy(AppInvStkRespVO::getItemCode, Collectors.mapping(AppInvStkRespVO::getWhId, Collectors.toList())));
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isNotEmpty(invWhItemTotalStkRpcDTOS)) {
            for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
                List longs = itemCodeAndWhId.get(dto.getItemCode());
                if (!longs.contains(dto.getWhId())) continue;
                stockMap.updateAndGet(currentMap -> {
                    currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                    return currentMap;
                });
            }
        }
    }

    private Map<String, List<PriPriceRpcDTO>> getItemPrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        List itmPriPriceParamList = BeanUtils.copyToList(priceParamList, ItmPriPriceRpcDtoParam.class);
        List<PriPriceRpcDTO> priceByParam = this.rmiPriceRpcService.findPriceByParam(itmPriPriceParamList);
        if (CollUtil.isNotEmpty(priceByParam)) {
            priceList.addAll(priceByParam);
            Map<String, List<PriPriceRpcDTO>> inPriceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            this.getBasePrice(priceParamList, priceList);
        } else {
            this.getBasePrice(priceParamList, priceList);
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
        log.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(priceMap));
        return priceMap;
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = (ItmPriPriceRpcDtoParam)BeanUtils.copyProperties((Object)row, ItmPriPriceRpcDtoParam.class, (String[])new String[0]);
            ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("\u67e5\u8be2\u57fa\u672c\u5355\u4f4d\u4ef7\u683c:{}", (Object)JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)BeanUtils.copyProperties((Object)row, PriPriceRpcDTO.class, (String[])new String[0]);
                ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)simpleItem.getDecimalPlaces(), 4));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private ItmPriPriceRpcDtoParam buildSuppPriceParamList(Map<String, List<ScpSupplyAllocationRpcDTO>> suppAllocMap, AppItemActivityItemPriceParamVO item, List<PriPriceRpcDTO> priceList, AppInvStkRespVO stkParam) {
        List<ScpSupplyAllocationRpcDTO> suppList = suppAllocMap.get(item.getItemCode());
        if (CollUtil.isEmpty(suppList)) {
            return null;
        }
        stkParam.setItemId(item.getItemId());
        stkParam.setItemCode(item.getItemCode());
        ScpSupplyAllocationRpcDTO supp = suppList.get(0);
        if (StrUtil.isBlank((CharSequence)supp.getSaleOuCode())) {
            PriPriceRpcDTO priPriceRpcDTO = new PriPriceRpcDTO();
            priPriceRpcDTO.setItemId(item.getItemId());
            priPriceRpcDTO.setItemCode(item.getItemCode());
            priPriceRpcDTO.setPrice(BigDecimal.ZERO);
            priPriceRpcDTO.setNetPrice(BigDecimal.ZERO);
            priceList.add(priPriceRpcDTO);
            return new ItmPriPriceRpcDtoParam();
        }
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(item.getItemId());
        priceParam.setCustCode(supp.getSaleCustCode());
        priceParam.setItemCode(item.getItemCode());
        priceParam.setUom(item.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getSaleOuCode());
        return priceParam;
    }

    private ItmPriPriceRpcDtoParam buildWhPriceParamList(Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap, AppItemActivityItemPriceParamVO item, List<PriPriceRpcDTO> priceList, AppInvStkRespVO stkParam) {
        List<ScpWhNetRelationRpcDTO> whNetList = whNetMap.get(item.getItemCode());
        if (CollUtil.isEmpty(whNetList)) {
            return null;
        }
        ScpWhNetRelationRpcDTO supp = whNetList.get(0);
        stkParam.setItemId(item.getItemId());
        stkParam.setItemCode(item.getItemCode());
        stkParam.setWhId(supp.getSupplyWhId());
        if (StrUtil.isBlank((CharSequence)supp.getOuCode())) {
            PriPriceRpcDTO priPriceRpcDTO = new PriPriceRpcDTO();
            priPriceRpcDTO.setItemId(item.getItemId());
            priPriceRpcDTO.setItemCode(item.getItemCode());
            priPriceRpcDTO.setPrice(BigDecimal.ZERO);
            priPriceRpcDTO.setNetPrice(BigDecimal.ZERO);
            priceList.add(priPriceRpcDTO);
            return new ItmPriPriceRpcDtoParam();
        }
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(item.getItemId());
        priceParam.setCustCode(supp.getCustCode());
        priceParam.setItemCode(item.getItemCode());
        priceParam.setUom(item.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getOuCode());
        return priceParam;
    }

    public CommonPriceServiceImpl(RmiPriceRpcService rmiPriceRpcService, RmiItemService rmiItemService, ScpSupplyAllocationService scpSupplyAllocationService, ScpWhNetRelationService scpWhNetRelationService, RmiInvStkRpcService rmiInvStkRpcService) {
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.rmiItemService = rmiItemService;
        this.scpSupplyAllocationService = scpSupplyAllocationService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
    }
}

