/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.user;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkcontact_1_0.Client;
import com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController
@RequestMapping(value={"/api"})
public class UserController {
    @Value(value="${app.clientId}")
    private String clientId;
    @Value(value="${app.clientSecret}")
    private String clientSecret;
    @Autowired
    private UserRpcService userRpcService;
    @Autowired
    private TextEncryptor textEncryptor;
    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;

    @GetMapping(value={"/auth/code"})
    public ResponseEntity<JSONObject> getUsers(@RequestParam String authCode) {
        String corpId;
        ResponseEntity<JSONObject> tokenResp = this.getAccessToken(authCode);
        if (!tokenResp.getStatusCode().is2xxSuccessful()) {
            JSONObject error = new JSONObject();
            error.put("error", tokenResp.getBody());
            return ResponseEntity.status((HttpStatus)tokenResp.getStatusCode()).body((Object)error);
        }
        String accessToken = ((JSONObject)tokenResp.getBody()).getString("accessToken");
        ResponseEntity<JSONObject> userInfoResp = this.getUserInfo(accessToken, corpId = ((JSONObject)tokenResp.getBody()).getString("corpId"));
        if (!userInfoResp.getStatusCode().is2xxSuccessful()) {
            ApiResult mobile = this.userRpcService.getByUsername(Objects.requireNonNull((JSONObject)userInfoResp.getBody()).getString("mobile"));
            if (mobile == null || mobile.getData() == null) {
                return ResponseEntity.status((HttpStatus)userInfoResp.getStatusCode()).body((Object)((JSONObject)userInfoResp.getBody()));
            }
            Long id = ((SysUserBasicDTO)mobile.getData()).getId();
            String encrypt = this.textEncryptor.encrypt(String.valueOf(id));
            AuthUserIdQueryDTO authUserIdQueryDTO = new AuthUserIdQueryDTO();
            authUserIdQueryDTO.setUserIdCypher(encrypt);
            ApiResult oAuthTokenApiResult = this.sysUserPermissionRpcService.authByUserId(authUserIdQueryDTO);
            if (oAuthTokenApiResult.isSuccess()) {
                JSONObject body = (JSONObject)userInfoResp.getBody();
                body.put("accessToken", (Object)Objects.requireNonNull((OAuthToken)oAuthTokenApiResult.getData()).getAccessToken());
                return ResponseEntity.ok((Object)body);
            }
            return userInfoResp;
        }
        return userInfoResp;
    }

    public ResponseEntity<JSONObject> getAccessToken(String authCode) {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        try {
            com.aliyun.dingtalkoauth2_1_0.Client client = new com.aliyun.dingtalkoauth2_1_0.Client(config);
            GetUserTokenRequest getUserTokenRequest = new GetUserTokenRequest().setClientId(this.clientId).setClientSecret(this.clientSecret).setCode(authCode).setGrantType("authorization_code");
            GetUserTokenResponse getUserTokenResponse = client.getUserToken(getUserTokenRequest);
            String corpId = getUserTokenResponse.getBody().getCorpId();
            String accessToken = getUserTokenResponse.getBody().getAccessToken();
            JSONObject response = new JSONObject();
            response.put("corpId", (Object)corpId);
            response.put("accessToken", (Object)accessToken);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            JSONObject error = new JSONObject();
            error.put("error", (Object)("\u83b7\u53d6accessToken\u5931\u8d25: " + e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)error);
        }
    }

    public ResponseEntity<JSONObject> getUserInfo(String accessToken, String corpId) {
        Client client;
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        try {
            client = new Client(config);
        }
        catch (Exception e) {
            JSONObject error = new JSONObject();
            error.put("error", (Object)("\u521d\u59cb\u5316\u9489\u9489Client\u5931\u8d25: " + e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)error);
        }
        GetUserHeaders getUserHeaders = new GetUserHeaders();
        getUserHeaders.xAcsDingtalkAccessToken = accessToken;
        try {
            GetUserResponse resp = client.getUserWithOptions("me", getUserHeaders, new RuntimeOptions());
            JSONObject user = new JSONObject();
            user.put("unionId", (Object)resp.getBody().getUnionId());
            user.put("phone", (Object)resp.getBody().getMobile());
            user.put("nick", (Object)resp.getBody().getNick());
            user.put("stateCode", (Object)resp.getBody().getStateCode());
            user.put("corpId", (Object)corpId);
            return ResponseEntity.ok((Object)user);
        }
        catch (TeaException err) {
            JSONObject error = new JSONObject();
            error.put("error", (Object)("\u9489\u9489\u63a5\u53e3\u5f02\u5e38: " + err.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).body((Object)error);
        }
        catch (Exception _err) {
            JSONObject error = new JSONObject();
            error.put("error", (Object)("\u672a\u77e5\u5f02\u5e38: " + _err.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)error);
        }
    }
}

