package com.elitesland.scp.application.facade.vo.freight;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author Rikyon
 * @description: 门店订单运费分页条件
 * @datetime 2024年 08月 14日 10:24
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpStoreOrderFreightPageParamVO", description = "门店订单运费分页条件")
public class ScpStoreOrderFreightPageParamVO extends PartitionQueryParam  implements Serializable {
    @ApiModelProperty("需求门店编码或'all'")
    private List<String> storeCodeList;

    @ApiModelProperty("需求门店编码")
    private List<String> storeCodes;

    @ApiModelProperty("需求门店名称或'全部'")
    private List<String> storeNameList;

    @ApiModelProperty("订货类型")
    private String orderType;

    @ApiModelProperty("运费收取方式")
    private String freightMethod;

    @ApiModelProperty("仓库编码")
    private List<String> whCodeList;

    @ApiModelProperty("仓库名称")
    private List<String> whNameList;

    @ApiModelProperty("商品编码")
    private List<String> itemCodeList;

    @ApiModelProperty("商品名称")
    private List<String> itemNameList;

    @ApiModelProperty("商品品类")
    private String itemCategoryCode;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer status;
}
