package com.elitesland.scp.application.facade.vo.resp.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 29日 15:04
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpStoreDemandCalendarRespVO", description = "门店日历返回")
public class ScpStoreDemandCalendarRespVO extends BaseViewModel implements Serializable {


    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "年")
    private String year;

    @ApiModelProperty(value = "月")
    private String month;

    @ApiModelProperty(value = "日")
    private String day;

    @ApiModelProperty(value = "工作状态")
    private String workStatus;

    @ApiModelProperty("商品分类")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "日历工作日明细")
    private List<ScpStoreDemandCalendarRespVO> dayDetails;

    @ApiModelProperty(value = "年")
    private List<String> existYears;

    @ApiModelProperty(value = "月")
    private List<String> existMonthsOfYear;

    @ApiModelProperty(value = "日")
    private List<String> existDaysOfMonth;
}
