package com.elitesland.scp.application.out.service;

import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

/**
 * @author feng
 * @program: yst-pur
 * @description: 系统域接口
 * @date 2022-03-17 11:02:27
 */
public interface SystemDubboService {


    /**
     * 根据发号规则编码，生成对应号码
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 选择UDC的值列表
     * @return 生成的号码
     */
    String generateCode(String ruleCode, List<String> runtimeValues);

    List<String> generateCode(String ruleCode, List<String> runtimeValues, Integer num);

    List<Long> findUserIdsByFlowRoles(Long ouId, String customParams);

    /**
     * udc查询
     *
     * @param domain
     * @param udc
     * @return
     */
    Map<String, String> sysUdcGetCodeMap(String domain, String udc);

    SysUserDTO sysUserCurrent();

    /**
     * 22.01
     *
     * @param ids
     * @return
     */
    List<SysUserRpcDTO> findUserByUserIds(List<Long> ids);

    /**
     * 根据id查询用户
     *
     * @param id
     * @return
     */
    Optional<SysUserRpcDTO> findUserByUserId(Long id);

    /**
     * 根据id查询用户
     *
     * @param ids
     * @return
     */
    List<SysUserBasicDTO> findUserByUserIdBatch(Set<Long> ids);
    /**
     * 16.2
     * 根据支付条款代码查询支付条款
     *
     * @param paymentTermCodes 支付条款代码集合
     * @return 支付条款对象
     */

    List<ComPaymentTermRespVO> findPaymentCodeBatch(List<String> paymentTermCodes);

    /**
     * 16.3
     * 根据支付条款代码查询支付条款
     *
     * @param paymentTermCode 支付条款代码
     * @return 支付条款对象
     */

    Optional<ComPaymentTermRespVO> findPaymentByCode(String paymentTermCode);

    /**
     * 查询所有付款条款
     *
     * @return 支付条款对象
     */
    List<ComPaymentTermRespVO> findAllPayment();

    /**
     * 通过货币集合查询货币信息列表
     *
     * @param currCodes 货币编号集合
     * @return 货币集
     */
    List<SysCurrencyRespDTO> findCurrByCodes(List<String> currCodes);

    List<SysCurrencyRespDTO> findAllCurrency();

    /**
     * 根据货币编号获取货币信息
     *
     * @param currCode 货币编号
     * @return 货币信息
     */
    Optional<SysCurrencyRespDTO> findCurrByCode(String currCode);
    /*************************15税率共通comTaxRateService*******************************/
    /**
     * 15.1
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
//    Optional<SysTaxRateRespDTO> getCommonTaxRateRatio(ComCommonTaxRateQueryParamVO param);

    /**
     * 货币汇率转换
     *
     * @param param
     * @return 汇率
     */
//    Double findCurrRateRatio(ComCurrRateQueryParamVO param);

    /**
     * 15.3
     * 根据税率编号集合查询税率信息
     *
     * @param taxRateNos 税率编号
     * @return 税率信息集合
     **/
    List<SysTaxRateRespDTO> findTaxRateBytaxRateNoList(List<String> taxRateNos);

    /**
     * 根据用户id查询员工信息
     * @param userId 用户id
     * @return 结果
     */
    SysEmployeeBasicDTO getEmpByUserId(Long userId);

    List<EmployeePageRespDTO> queryEmpByUserId(Long userId);

    /**
     * 15.4
     * 根据税率编号查询税率信息
     *
     * @param taxRateNo 税率编号
     * @return 税率信息
     */
    Optional<SysTaxRateRespDTO> findTaxRateByTaxRateNo(String taxRateNo);


    /**
     * 根据区域编号集合获取区域信息列表
     *
     * @param areaCodes 区域编号集合
     * @return 区域集
     */
    List<SysAreaRespDTO> findAreaByCodes(List<String> areaCodes);

    List<SysTaxRateRespDTO> findAllTaxRate();

    /**
     * 22.01
     *
     * @param ids
     * @return
     */
    List<SysUserVO> sysUserGetByIds(List<Long> ids);

    List<SysEmployeeBasicDTO> getEmpByIds(Set<Long> empIds);

    List<SysAreaRespDTO> findAllArea();

    /**
     * 商品库存参数配置模块 - 更据计划员工ID查询系统用户账号信息
     *
     * @param calcEmpIds userids
     * @return 系统用户集
     */
    List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds);

    List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes);

    /**
     * 创建用户账号
     *
     * @param param 用户信息
     * @return 用户ID
     */
    ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param);

    SysSettingVO findSysSetting(String settingNo);
}
