package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.order.*;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandOrderDServiceImpl implements ScpDemandOrderDService {

    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RedisTemplate redisClient;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDMgmtRespVO> findDemandOrderDByMasId(Long masId) {
        List<ScpDemandOrderDDTO> itemList = scpDemandOrderDDomainService.findDemandOrderDByMasId(masId);
        if (CollUtil.isEmpty(itemList)) {
            return Collections.emptyList();
        }
        Map<String, String> docClsMap = rmiSysUDCService.getCodeMap("yst-supp", "DOC_CLS");
        Map<String, String> payStatusMap = rmiSysUDCService.getCodeMap(ScpUdcEnum.PAY_STATUS_NO_PAY.getModel(), ScpUdcEnum.PAY_STATUS_WAIT_PAY.getCode());
        Map<String, String> suppTypeMap = rmiSysUDCService.getCodeMap(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getModel(), ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getCode());
        List<ScpDemandOrderDMgmtRespVO> mgmtRespVOS = new ArrayList<>();
        Map<Long, List<ScpDemandOrderDDTO>> soureIdMap = itemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSourceId));
        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : soureIdMap.entrySet()) {
            var supplyItems = entry.getValue().stream().map(row -> {
                ScpDemandOrderDMgmtRespVO.SupplyItem supplyItem = ScpDemandOrderDConvert.INSTANCE.dtoToSupplyItem(row);
                supplyItem.setSupplyTypeName(suppTypeMap.get(supplyItem.getSupplyType()));
                if (payStatusMap.containsKey(row.getPayStatus())) {
                    supplyItem.setPayStatusName(payStatusMap.get(row.getPayStatus()));
                }
                if (docClsMap.containsKey(row.getSrcDocCls())) {
                    supplyItem.setSrcDocClsName(docClsMap.get(row.getSrcDocCls()));
                }
                return supplyItem;
            }).collect(Collectors.toList());
            ScpDemandOrderDMgmtRespVO mgmtRespVO = ScpDemandOrderDConvert.INSTANCE.dtoToMgmtRespVO(entry.getValue().get(0));
            mgmtRespVO.setItemList(supplyItems);
            mgmtRespVOS.add(mgmtRespVO);
        }
        return mgmtRespVOS.stream().sorted(Comparator.comparing(ScpDemandOrderDMgmtRespVO::getFreightLineFlag)).collect(Collectors.toList());
    }



    @Override
    public List<ScpDemandOrderDMgmtRespVO> queryList(ScpDemandOrderDListParamVO scpDemandOrderDParamVO) {
        List<ScpDemandOrderDDTO> itemList = scpDemandOrderDDomainService.queryList(scpDemandOrderDParamVO);
        List<ScpDemandOrderDMgmtRespVO> mgmtRespVOList = ScpDemandOrderDConvert.INSTANCE.dtoListToMgmtRespVOList(itemList);
        return mgmtRespVOList;
    }


    @Override
    public void batchSaveDemandOrderDMgmt(Long masId, List<ScpDemandOrderDMgmtSaveVO> saveVOS) {
        List<ScpDemandOrderDSaveVO> batchSaveVOS = saveVOS.stream().filter(row -> !row.getFreightLineFlag())
                .flatMap(entity -> {
                    String uuid = UUIDUtil.getUUID();
                    return entity.getItemList().stream()
                            .map(listItem -> {
                                ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = ScpDemandOrderDConvert.INSTANCE.mgmtSaveVoToSaveVo(listItem);
                                scpDemandOrderDSaveVO.setMasId(entity.getMasId());
                                scpDemandOrderDSaveVO.setSourceId(entity.getSourceId());
                                scpDemandOrderDSaveVO.setSpuItemCode(entity.getSpuItemCode());
                                scpDemandOrderDSaveVO.setSpuItemName(entity.getSpuItemName());
                                scpDemandOrderDSaveVO.setItemId(entity.getItemId());
                                scpDemandOrderDSaveVO.setItemCode(entity.getItemCode());
                                scpDemandOrderDSaveVO.setItemName(entity.getItemName());
                                scpDemandOrderDSaveVO.setDemandQuantity(entity.getDemandQuantity());
                                scpDemandOrderDSaveVO.setPrice(listItem.getPrice());
                                scpDemandOrderDSaveVO.setCurrency(entity.getCurrency());
                                scpDemandOrderDSaveVO.setRemark(entity.getRemark());
                                scpDemandOrderDSaveVO.setPreRootUuid(uuid);
                                scpDemandOrderDSaveVO.setUnit(listItem.getUnit());
                                scpDemandOrderDSaveVO.setUnitName(listItem.getUnitName());
                                scpDemandOrderDSaveVO.setUom2(listItem.getUom2());
                                scpDemandOrderDSaveVO.setUom2Name(listItem.getUom2Name());
                                scpDemandOrderDSaveVO.setUomRatio(listItem.getUomRatio());
                                scpDemandOrderDSaveVO.setDecimalPlaces(listItem.getDecimalPlaces());
                                scpDemandOrderDSaveVO.setSaleOuCode(listItem.getSaleOuCode());
                                scpDemandOrderDSaveVO.setSaleOuName(listItem.getSaleOuName());
                                scpDemandOrderDSaveVO.setSaleCustCode(listItem.getSaleCustCode());
                                scpDemandOrderDSaveVO.setImgUrl(listItem.getImgUrl());
                                scpDemandOrderDSaveVO.setItemType(entity.getItemType());
                                scpDemandOrderDSaveVO.setActivityId(entity.getActivityId());
                                scpDemandOrderDSaveVO.setActivityCode(entity.getActivityCode());
                                scpDemandOrderDSaveVO.setMinNum(entity.getMinNum());
                                Long id = (listItem.getId() == null || listItem.getId() < 0) ? null : listItem.getId();
                                scpDemandOrderDSaveVO.setId(id);
                                return scpDemandOrderDSaveVO;
                            });
                }).collect(Collectors.toList());
        this.batchSaveDemandOrderD(masId, batchSaveVOS);
        //更新门店已强配次数
        List<Long> activitys = batchSaveVOS.stream().map(ScpDemandOrderDSaveVO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activitys)) {
            Optional<ScpDemandOrderDTO> demandOrderById = scpDemandOrderDomainService.findDemandOrderById(masId);
            ScpDemandOrderDTO scpDemandOrderDTO = demandOrderById.get();

            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setStoreCode(scpDemandOrderDTO.getDemandWhStCode());
            scpAllocSettingStoreParamVO.setMasIds(activitys);
            List<ScpAllocSettingStoreRespVO> settingStoreList = scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            for (ScpAllocSettingStoreRespVO storeRespVO : settingStoreList) {
                if ((storeRespVO.getAllocNum() + 1) >= storeRespVO.getMaxNum()) {
                    redisClient.delete(ScpConstant.ALLOC_SETTING + scpDemandOrderDTO.getDemandWhStCode());
                }
            }
            scpAllocSettingStoreDomainService.updateAllocNumByParam(activitys, scpDemandOrderDTO.getDemandWhStCode());
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderDRespVO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO) {
        Page<ScpDemandOrderDDO> page = scpDemandOrderDDomainService.pageDemandOrderDByMasId(paramVO);
        List<ScpDemandOrderDDO> records = page.getContent();
        List<ScpDemandOrderDRespVO> scpDemandOrderDRespVOS = ScpDemandOrderDConvert.INSTANCE.doToRespVO(records);
        ItmItemScpBaseRpcParam itmItemRpcDtoParam = new ItmItemScpBaseRpcParam();
        itmItemRpcDtoParam.setItemIds(scpDemandOrderDRespVOS.stream().map(ScpDemandOrderDRespVO::getItemId).collect(Collectors.toList()));
        Map<Long, ItmItemScpBaseRpcDTO> itemMap = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemRpcDtoParam).stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId,
                Function.identity()));

        Map<String, String> uomCodeMap = rmiSysUDCService.getCodeMap("yst-supp", "UOM");

        //查询组合品
        List<ScpDemandOrderDDO> byMasIdAndCombineItemCodeIsNotNull = scpDemandOrderDDomainService.findByMasIdAndCombineItemCodeIsNotNull(paramVO);
        List<ScpDemandOrderDRespVO> subScpDemandOrderDRespVOS = ScpDemandOrderDConvert.INSTANCE.doToRespVO(byMasIdAndCombineItemCodeIsNotNull);
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        if(CollUtil.isNotEmpty(subScpDemandOrderDRespVOS)){
            Map<String, List<ScpDemandOrderDRespVO>> collect = subScpDemandOrderDRespVOS.stream().collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getCombineItemCode));

            ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
            param.setItemCodes(new ArrayList<>(collect.keySet()));
            List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);
            collect.forEach((k, v) -> {
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = new ScpDemandOrderDRespVO();
                scpDemandOrderDRespVO.setItemCode(k);
                Optional<ItmItemScpBaseRpcDTO> mainItem = itemRpcDtoByParam.stream().filter(row -> k.equals(row.getItemCode()))
                        .findFirst();
                mainItem.ifPresent(row -> {
                            scpDemandOrderDRespVO.setUnit(row.getUom2());
                            if (CollUtil.isNotEmpty(row.getSkuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                String url = first.isPresent() ? first.get().getUrl() : row.getSkuAttchmentList().get(0).getUrl();
                                scpDemandOrderDRespVO.setUrl(url);
                            } else if (CollUtil.isNotEmpty(row.getSpuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSpuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                scpDemandOrderDRespVO.setUrl(first.isEmpty() ? row.getSpuAttchmentList().get(0).getUrl() : first.get().getUrl());
                            }
                            scpDemandOrderDRespVO.setItemAttrName(row.getItemAttrName());
                            scpDemandOrderDRespVO.setAnotherName(row.getAnotherName());
                            scpDemandOrderDRespVO.setItemName(row.getItemName());
                            scpDemandOrderDRespVO.setPlanAmt(v.stream().map(ScpDemandOrderDRespVO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = row.getSubItems().get(0);
                            v.stream().filter(a -> a.getItemId().equals(itmItemScpBaseRpcDTO.getId()))
                                    .findFirst().ifPresent(b -> {
                                        BigDecimal divide = b.getPlanQuantity().divide(itmItemScpBaseRpcDTO.getBomQty(), 0, RoundingMode.FLOOR);
                                        scpDemandOrderDRespVO.setPlanQuantity( divide);
                                        scpDemandOrderDRespVO.setAllocationDeQuantity( divide);
                                    });
                        });
                scpDemandOrderDRespVO.setUnitName(uomCodeMap.get(scpDemandOrderDRespVO.getUnit()));
                v.forEach(d -> {
                    if(mainItem.isEmpty()){
                        return;
                    }
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO1 = mainItem.get();
                    List<ItmItemScpBaseRpcDTO> subItems =  itmItemScpBaseRpcDTO1.getSubItems().stream().filter(a -> a.getId().equals(d.getItemId())).collect(Collectors.toList());
                    if(CollUtil.isEmpty(subItems)){
                        return;
                    }
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = subItems.get(0);
                    d.setItemAttrName(StrUtil.isBlank(itmItemScpBaseRpcDTO.getItemAttrName()) ? itmItemScpBaseRpcDTO.getSpec() : itmItemScpBaseRpcDTO.getItemAttrName());
                    d.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    d.setItemName(itmItemScpBaseRpcDTO.getItemName());
                    d.setUnitName(uomCodeMap.get(d.getUnit()));
                    //商品图片赋值
                    var skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
                    var spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty(skuAttchmentList)) {
                        Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        d.setUrl(first.isEmpty() ? skuAttchmentList.get(0).getUrl() : first.get().getUrl());
                    } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                        Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        d.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
                    }
                });
                scpDemandOrderDRespVO.setSubItems(v);
                result.add(scpDemandOrderDRespVO);
            });
        }
        scpDemandOrderDRespVOS.forEach(d -> {
            if (!itemMap.containsKey(d.getItemId())) {
                return;
            }
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = itemMap.get(d.getItemId());
            d.setItemAttrName(StrUtil.isBlank(itmItemScpBaseRpcDTO.getItemAttrName()) ? itmItemScpBaseRpcDTO.getSpec() : itmItemScpBaseRpcDTO.getItemAttrName());
            d.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
            d.setItemName(itmItemScpBaseRpcDTO.getItemName());
            d.setUnitName(uomCodeMap.get(d.getUnit()));
            //商品图片赋值
            var skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            var spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty(skuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                d.setUrl(first.isEmpty() ? skuAttchmentList.get(0).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                d.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
            }
        });

        //分页接口组合品和非组合品拼接
        result.addAll(scpDemandOrderDRespVOS.subList(0, scpDemandOrderDRespVOS.size() - result.size()));
        return PagingVO.<ScpDemandOrderDRespVO>builder().records(result).total(page.getTotalElements()).build();
    }

    @Override
    public void remove(Long id) {
        var demandOrderDDTOList = scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(id));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated()) {
                throw new BusinessException("商品名称:" + row.getItemName() + "已计算，不能删除");
            }
            if (row.getIsPushed()) {
                throw new BusinessException("商品名称:" + row.getItemName() + "已推送，不能删除");
            }
        });

        scpDemandOrderDDomainService.deleteByIds(Arrays.asList(id));
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveDemandOrderD(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS) {
        // 明细相关金额、数量小数位,表头相关金额
        var modifyDetails = saveVOS.stream().filter(row -> !row.getIsPushed()).collect(Collectors.toList());
        BigDecimal maxLineNo = scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        // 删除未推送的明细行
        scpDemandOrderDDomainService.deleteUnPushedItem(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        TimeInterval timer = new TimeInterval();
        modifyDetails.stream().collect(Collectors.groupingBy(ScpDemandOrderDSaveVO::groupByUuid)).forEach((id, list) -> {
            // 按比例分配需求数量
            distributeDemandQty(list, masId, lineNo);
        });
        log.info("批量保存订货订单明细，分配耗时：{}", timer.intervalMs());
        //校验库存可供量
        checkStock(modifyDetails);
        scpDemandOrderDDomainService.batchSave(modifyDetails, lineNo, source);
        scpDemandOrderDomainService.updateAllocStatusAndPayStatusById(masId);
    }

    @Override
    public void saveDemandOrderD(ScpDemandOrderDSaveVO scpDemandOrderDSaveVO) {
        if (Boolean.TRUE.equals(scpDemandOrderDSaveVO.getIsCalculated())) {
            throw new BusinessException(ApiCode.FAIL, "此商品已分配");
        }
        scpDemandOrderDDomainService.saveDemandOrderD(scpDemandOrderDSaveVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByParam(ScpDemandOrderDelParamVO paramVO) {
        Optional<ScpDemandOrderDTO> demandOrderDTO = scpDemandOrderDomainService.findDemandOrderById(paramVO.getMasId());
        if (paramVO.getDId() == null) {
            List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_WT.getValueCode(), ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
            if (!docStatusList.contains(demandOrderDTO.get().getDocStatus())) {
                throw new BusinessException("订货单不允许删除");
            }
            scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
            return;
        }
        var demandOrderDDTOList = scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(paramVO.getDId()));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated()) {
                throw new BusinessException("商品名称:" + row.getItemName() + "已计算，不能删除");
            }
            if (row.getIsPushed()) {
                throw new BusinessException("商品名称:" + row.getItemName() + "已推送，不能删除");
            }
        });
        List<Long> sourceIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getSourceId).distinct().collect(Collectors.toList());
        scpDemandOrderDDomainService.deleteBySourceIds(sourceIds);
        // 如果删除了所有明细，表头也要删除
        List<ScpDemandOrderDDTO> demandOrderDDTOS = scpDemandOrderDDomainService.findDemandOrderDByMasId(paramVO.getMasId());
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
        }
        //更新门店已强配次数
        List<Long> activityIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityIds)) {
            scpAllocSettingStoreDomainService.updateAllocNumByParam(activityIds, demandOrderDTO.get().getDemandWhStCode());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addItem(Long masId, List<ScpDemandOrderAddItemParamVO> saveVOS) {
        Optional<ScpDemandOrderRespVO> demandOrderRespVO = scpDemandOrderService.findDemandOrderById(masId);
        if (demandOrderRespVO.isEmpty()) {
            throw new BusinessException("订货订单不存在");
        }
        ScpDemandOrderRespVO scpDemandOrderRespVO = demandOrderRespVO.get();
        List<ScpDemandOrderDSaveVO> scpDemandOrderDSaveVOS = new ArrayList<>();
        BigDecimal maxLineNo = scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        saveVOS.forEach(row -> {
            ScpDemandOrderItemParamVO scpDemandOrderItemParamVO = new ScpDemandOrderItemParamVO();
            scpDemandOrderItemParamVO.setItemId(row.getItemId());
            scpDemandOrderItemParamVO.setItemCode(row.getItemCode());
            scpDemandOrderItemParamVO.setItemName(row.getItemName());
            scpDemandOrderItemParamVO.setSpuItemCode(row.getSpuItemCode());
            scpDemandOrderItemParamVO.setType(scpDemandOrderRespVO.getType());
            scpDemandOrderItemParamVO.setDemandWhStCode(scpDemandOrderRespVO.getDemandWhStCode());
            scpDemandOrderItemParamVO.setDemandDate(scpDemandOrderRespVO.getDemandDate());
            scpDemandOrderItemParamVO.setDemandQuantity(row.getDemandQuantity());
            scpDemandOrderItemParamVO.setUnit(row.getUom());
            scpDemandOrderItemParamVO.setUnitName(row.getUomName());
            scpDemandOrderItemParamVO.setSpuItemName(row.getSpuItemName());
            List<ScpDemandOrderDRespVO> itemList = scpDemandOrderService.getItemList(scpDemandOrderItemParamVO);
            List<ScpDemandOrderDSaveVO> intentionList = ScpDemandOrderDConvert.INSTANCE.respsVosToSaveVos(itemList);
            this.distributeDemandQty(intentionList, masId, lineNo);
            scpDemandOrderDSaveVOS.addAll(intentionList);
        });
        scpDemandOrderDDomainService.batchSave(scpDemandOrderDSaveVOS, lineNo);
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDRespVO> findDemandOrderDBySrcDocId(Long srcDocId) {
        return scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId).stream().map(ScpDemandOrderDConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
    }

    /**
     * 按比例分配需求数量
     *
     * @param list
     */
    private static void distributeDemandQty(List<ScpDemandOrderDSaveVO> list, Long masId, AtomicInteger index) {
        String orderSetting = SysUtils.getOrderSetting();
        for (int i = 0; i < list.size(); i++) {
            ScpDemandOrderDSaveVO saveVO = list.get(i);
            saveVO.setLineNo(new BigDecimal(index.getAndIncrement()));
            saveVO.setMasId(masId);
            saveVO.setCurrency(StrUtil.isNotBlank(saveVO.getCurrency()) ? saveVO.getCurrency() : ScpConstant.CNY);
            // 若系统配置=订货单分配，计算数量 = 分配需求数量
            if ("1".equals(orderSetting)) {
                saveVO.setIsCalculated(Boolean.TRUE);
                saveVO.setPlanQuantity(saveVO.getAllocationDeQuantity());
                if (saveVO.getPrice() == null) {
                    continue;
                }
                // 含税单价
                saveVO.setPrice(SysUtils.processPriceScale(saveVO.getPrice()));
                // 含税总价：含税金额 * 采购数量
                var amt = saveVO.getPrice().multiply(saveVO.getPlanQuantity());
                saveVO.setPlanAmt(SysUtils.processAmtScale(amt));
            }
        }
    }

    /**
     * 校验库存
     *
     * @param saveVOList
     */
    private void checkStock(List<ScpDemandOrderDSaveVO> saveVOList) {
        List<Long> itemIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || !row.getFreightLineFlag()) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType()))
                .map(ScpDemandOrderDSaveVO::getItemId).distinct().collect(Collectors.toList());
        List<Long> whIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || !row.getFreightLineFlag()) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType()))
                .map(ScpDemandOrderDSaveVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
            log.info("校验库存商品或者仓库为空,无需查询库存");
            return;
        }else{
            List<String> itemCodes = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || !row.getFreightLineFlag()) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType()))
                    .map(ScpDemandOrderDSaveVO::getItemCode).distinct().collect(Collectors.toList());
            // 补运费商品
            String exceptItemCode = SysUtils.getBackScpOrderItemSetting();
            if(itemCodes.contains(exceptItemCode) && itemCodes.size()==1){
                log.info("校验库存商品为补缴运费商品,无需查询库存");
                return;
            }
        }
        InvWhItemTotalStkRpcParam param = new InvWhItemTotalStkRpcParam();
        param.setWhIds(whIds);
        param.setItemIds(itemIds);
        param.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
        List<InvWhItemTotalStkRpcDTO> stkRpcDTOS = rmiInvStkRpcService.queryInvWhItemTotalStk(param);
        if (CollUtil.isEmpty(stkRpcDTOS)) {
            throw new BusinessException("商品【" + saveVOList.get(0).getItemName() + "】库存不足");
        }
        Map<String, InvWhItemTotalStkRpcDTO> stkMap = stkRpcDTOS.stream().collect(Collectors.toMap(row -> row.getWhId() + "@" + row.getItemId(), Function.identity()));
        for (ScpDemandOrderDSaveVO saveVO : saveVOList) {
            if ((saveVO.getFreightLineFlag() == null || !saveVO.getFreightLineFlag()) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(saveVO.getSupplyType())) {
                checkStockAvailability(saveVO, stkMap);
            }
        }

    }

    private void checkStockAvailability(ScpDemandOrderDSaveVO saveVO, Map<String, InvWhItemTotalStkRpcDTO> stkMap) {
        String key = saveVO.getSuppWhId() + "@" + saveVO.getItemId();
        InvWhItemTotalStkRpcDTO invWhItemTotalStkRpcDTO = stkMap.get(key);
        if (invWhItemTotalStkRpcDTO == null) {
            throw new BusinessException("商品【" + saveVO.getItemName() + "】库存不足");
        }
        BigDecimal avalQty = invWhItemTotalStkRpcDTO.getAvalQty();
        if (invWhItemTotalStkRpcDTO.getUomRatio() == null) {
            throw new BusinessException("商品【" + saveVO.getItemName() + "】辅助单位转换率不能为空");
        }
        if (saveVO.getPlanQuantity().multiply(invWhItemTotalStkRpcDTO.getUomRatio()).compareTo(avalQty) > 0) {
            throw new BusinessException("商品【" + saveVO.getItemName() + "】库存可用量为:" + invWhItemTotalStkRpcDTO.getAvalQty2() + ",不可超过该数量");
        }
    }

}
