package com.elitesland.scp.application.web.calendar;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.service.calendar.ScpSuppDemandCalendarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * @author jeesie
 * @description:供应商送货日历管理
 * @datetime 2024年 04月 01日 14:36
 * @version: 1.0
 */
@RestController
@RequestMapping(value = "/scp/suppCalendar", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "供应商送货日历管理接口", tags = {"供应商送货日历管理接口"})
@AllArgsConstructor
public class ScpSuppDemandCalendarController {

    private final ScpSuppDemandCalendarService suppDemandCalendarService;

    @PostMapping("/page")
    @ApiOperation("供应商送货日历-列表")
    public ApiResult<PagingVO<ScpSuppDemandCalendarPageVO>> searchPage(@RequestBody ScpSuppDemandCalendarPageParamVO queryParam) {
        return ApiResult.ok(suppDemandCalendarService.searchPage(queryParam));
    }

    @PostMapping("/save")
    @ApiOperation("供应商送货日历-新增/编辑")
    public ApiResult saveSuppCalendar(@RequestBody ScpSuppDemandCalendarSaveVO createParam) {
        suppDemandCalendarService.saveSuppCalendar(createParam);
        return ApiResult.ok();
    }

    @PostMapping("/detail")
    @ApiOperation("供应商送货日历-详情")
    public ApiResult findSuppCalendarDetail(@RequestBody ScpSuppDemandCalendarParamVO param) {
        return ApiResult.ok(suppDemandCalendarService.findSuppCalendarListByParam(param));
    }

    @PostMapping("/delete")
    @ApiOperation("供应商送货日历-删除")
    public ApiResult deleteSuppCalendar(@RequestBody @Valid List<ScpSuppDemandCalendarParamVO> param) {
        suppDemandCalendarService.deleteSuppCalendar(param);
        return ApiResult.ok();
    }
}
