package com.elitesland.scp.domain.entity.item;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("商品详情实体类")
public class ScpStoreItemDO implements Serializable {

    @ApiModelProperty("商品SKU的ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品SKU的编码")
    private String itemCode;

    @ApiModelProperty("商品SKU的名称")
    private String itemName;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    @ApiModelProperty("品类名称")
    private String itemCateName;

    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    @ApiModelProperty(value = "SPU商品图片")
    private List<ItmItemAttachmentRpcDTO> spuAttachmentList;

    @ApiModelProperty(value = "SKU商品图片")
    private List<ItmItemAttachmentRpcDTO> skuAttachmentList;

}
