package com.elitesland.scp.domain.entity.msg;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 运营消息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Entity
@Table(name = "scp_message", indexes = {
        @Index(name = "idx_scp_msg_title", columnList = "title"),
        @Index(name = "idx_scp_msg_author", columnList = "authorId"),
        @Index(name = "idx_scp_msg_category", columnList = "category"),
        @Index(name = "idx_scp_msg_type", columnList = "messageType"),
        @Index(name = "idx_scp_msg_publish", columnList = "published"),
        @Index(name = "idx_scp_msg_publishtime", columnList = "publishTime"),
})
@Comment("运营消息")
@DynamicInsert
@Getter
@Setter
public class ScpMessageDO extends BaseModel {
    private static final long serialVersionUID = -7627451721162411028L;

    @Comment(value = "标题")
    @Column(nullable = false)
    private String title;

    @Comment(value = "摘要")
    @Column()
    private String summaries;

    @Comment(value = "作者")
    @Column()
    private Long authorId;

    @Comment(value = "消息分类，[UDC]yst-suplan:MESSAGE_CATEGORY")
    @Column()
    private String category;

    @Comment(value = "消息类型")
    @Column()
    private String messageType;

    @Comment(value = "是否置顶", defaultValue = "0")
    @Column()
    private Boolean top;

    @Comment(value = "是否已发布", defaultValue = "0")
    @Column()
    private Boolean published;

    @Comment(value = "发布时间")
    @Column()
    private LocalDateTime publishTime;

    @Comment(value = "修改时间")
    @Column()
    private LocalDateTime changeTime;

    @Comment(value = "公告内容ID")
    @Column()
    private Long txtId;

    @Comment(value = "附件标识，多个以逗号分隔")
    @Column()
    private String fileCodesStr;
}
