package com.elitesland.scp.domain.service.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;

import java.util.List;
import java.util.Optional;

public interface ScpDemandOrderDomainService {

    /**
     * 订货订单明细分页查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderTitlePageRespVO> page(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订货订单保存
     *
     * @param saveVO
     * @return
     */
    Long saveDemandOrder(ScpDemandOrderSaveVO saveVO);

    /**
     * 订货订单明细分页查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderPage(ScpDemandOrderPageParamVO paramVO);


    /**
     * 订货订单列表
     *
     * @param paramVO
     * @return
     */
    List<ScpDemandOrderPageRespVO> queryDemandOrderList(ScpDemandOrderPageParamVO paramVO);

    /**
     * 查询订单头列表
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订单订单查询
     *
     * @param ids
     * @return
     */
    List<ScpDemandOrderDTO> findDemandOrderByIds(List<Long> ids);

    /**
     * 根据ID查询订货订单查询
     *
     * @param id
     * @return
     */
    Optional<ScpDemandOrderDTO> findDemandOrderById(Long id);

    /**
     * 根据订货单ID集合查询物料和仓库数据
     *
     * @param ids
     * @return
     */
    List<ScpDemandOrderComputeVO> getItemAndWarehouseByIds(List<Long> ids);

    /**
     * 根据订货集ID集合查询订货订单
     *
     * @param demandIds
     * @return
     */
    List<ScpDemandOrderDTO> findDemandOrderByDemandIds(List<Long> demandIds);


    /**
     * 根据条件查询订货订单
     *
     * @param paramVO
     * @return
     */
    List<ScpDemandOrderDTO> findDemandOrderByParam(ScpDemandOrderParamVO paramVO);

    /**
     * 根据订货集ID更新订货订单配货状态
     *
     * @param demandId
     */
    void updateAllocStatusByDemandId(Long demandId);

    /**
     * 根据订货集ID更新订货订单推送状态
     *
     * @param demandId
     */
    void updatePushStatusByDemandId(Long demandId);

    List<AppDemandOrderCountRespVO> countStatus(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订货单删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 查询未推送的订单
     *
     * @param demandId
     * @return
     */
    Long countUnPushedOrderByDemandId(Long demandId);

    /**
     * 更新订货单状态
     *
     * @param id
     */
    void updateAllocStatusAndPayStatusById(Long id);

    /**
     * 订货集ID查询订货订单数量
     *
     * @param demandIds
     * @return
     */
    Long countDemandOrderByDemandIds(List<Long> demandIds);

    /**
     * 分页查询计算订货信息
     *
     * @param orderIds
     * @return
     */
    List<ScpDemandOrderComputeVO> findComputeDemandOrderD(List<Long> orderIds);

    /**
     * 分页查询订货单ID
     *
     * @param paramVO
     * @return
     */
    List<Long> pageDemandOrderIds(ScpComputeDemandOrderPageParamVO paramVO);

    /**
     * 更新订货单状态
     *
     * @param id
     * @param type
     */
    void updateDocStatusById(Long id, String type);

    /**
     * 根据订货单ID更新订货订单推送状态
     *
     * @param id
     */
    void updatePushStatusById(Long id);

    /**
     * 更新订货单付款状态
     *
     * @param id
     */
    void updatePayStatusById(Long id);

    /**
     * 待支付订货订单分页查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO);

    /**
     * 关联单据号查询支付订单详情
     *
     * @param srcDocId
     * @return
     */
    AppPayOrderRespVO payOrderById(Long srcDocId);

    /**
     * 查询单据数量
     *
     * @param paramVO
     * @return
     */
    Long countAppOrderByParam(ScpDemandOrderPageParamVO paramVO);

    /**
     * 查询支付订单数量
     * @param paramVO
     * @return
     */
    Long countAppPayOrderByParam(ScpDemandOrderPageParamVO paramVO);

    /**
     * 更新评价标识
     * @param id
     * @return
     */
    void updateReplyFlagById(Long id);

    /**
     * 关闭订货订单
     * @param id
     */
    void closeDemandOrder(Long id);
}
