package com.elitesland.scp.infr.repo.msg;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.CommonPublishedMessagePageQueryVO;
import com.elitesland.scp.application.facade.vo.query.msg.ScpMessagePageMngQueryVO;
import com.elitesland.scp.domain.entity.msg.QScpMessageDO;
import com.elitesland.scp.domain.entity.msg.QScpMessageReceiverDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Repository
public class ScpMessageRepoProc extends BaseRepoProc<ScpMessageDO> {
    private static final QScpMessageDO QDO = QScpMessageDO.scpMessageDO;
    private static final QScpMessageReceiverDO QDO_RECEIVER = QScpMessageReceiverDO.scpMessageReceiverDO;

    public ScpMessageRepoProc() {
        super(QDO);
    }

    public void updateTxtId(long id, long txtId) {
        super.updateValue(QDO.txtId, txtId, id);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePublish(@NotEmpty Collection<Long> ids, LocalDateTime publishTime) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, true)
                .set(QDO.publishTime, publishTime)
                .where(QDO.id.in(ids).and(QDO.published.eq(false)).and(QDO.publishTime.isNull()))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePublish(@NotEmpty Collection<Long> ids) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, true)
                .where(QDO.id.in(ids).and(QDO.published.eq(false)).and(QDO.publishTime.isNotNull()))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateRevoke(@NotEmpty Collection<Long> ids) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, false)
                .setNull(QDO.publishTime)
                .where(QDO.id.in(ids).and(QDO.published.eq(true)))
                .execute();
    }

    public PagingVO<ScpMessageDO> pageMng(ScpMessagePageMngQueryVO queryVO) {
        var predate = PredicateBuilder.builder()
                .andEq(QDO.authorId, queryVO.getAuthorId())
                .andLike(QDO.title, queryVO.getTitle())
                .andEq(QDO.category, queryVO.getCategory())
                .andEq(QDO.messageType, queryVO.getMessageType())
                .andEq(QDO.top, queryVO.getTop())
                .andEq(QDO.published, queryVO.getPublished())
                .andBetween(QDO.publishTime, queryVO.getPublishTimeStart(), queryVO.getPublishTimeEnd())
                .andLike(new StringExpression[]{QDO.title, QDO.summaries}, queryVO.getKeyword())
                .build();
        return super.queryByPage(predate, queryVO.getPageRequest(), QDO.createTime.desc());
    }

    public PagingVO<ScpMessageDO> pagePublished(String receiverType, CommonPublishedMessagePageQueryVO queryVO) {
        JPQLQuery<Long> subQueryReceiver = null;
        if (StringUtils.hasText(queryVO.getReceiverId()) && StringUtils.hasText(receiverType)) {
            subQueryReceiver = JPAExpressions.select(QDO_RECEIVER.messageId)
                    .from(QDO_RECEIVER)
                    .where(QDO_RECEIVER.receiverId.eq(queryVO.getReceiverId()).and(QDO_RECEIVER.receiverType.eq(receiverType)));
        }

        var predate = PredicateBuilder.builder()
                .andIn(subQueryReceiver != null, QDO.id, subQueryReceiver)
                .andEq(QDO.category, queryVO.getCategory())
                .andEq(QDO.messageType, queryVO.getMessageType())
                .andLoe(QDO.publishTime, LocalDateTime.now())
                .andBetween(QDO.publishTime, queryVO.getPublishTimeStart(), queryVO.getPublishTimeEnd())
                .andEq(QDO.published, true)
                .andLike(QDO.title, queryVO.getTitle())
                .andLike(new StringExpression[]{QDO.title, QDO.summaries}, queryVO.getKeyword())
                .build();

        var pageRequest = queryVO.getPageRequest();

        pageRequest = pageRequest.withSort(Sort.Direction.DESC, QDO.top.getMetadata().getName(), QDO.publishTime.getMetadata().getName());
        return super.queryByPage(predate, pageRequest);
    }
}
