package com.elitesland.scp.infr.repo.whnet;

import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-20
* @Version 1.0
**/
@Repository
public interface ScpWhNetRelationRepo extends JpaRepository<ScpWhNetRelationDO, Long>, QuerydslPredicateExecutor<ScpWhNetRelationDO> {


    @Query(value = "select * from scp_wh_net_relation where (delete_flag=0 or delete_flag is null) and status = true " +
            "and CONCAT(COALESCE(demand_wh_st_code, ''), COALESCE(item_cate_code, ''), COALESCE(item_code, '')) in (?1)",nativeQuery = true)
    List<ScpWhNetRelationDO> findByConcatKey(List<String> concatKey);


    @Query(value = "select * from scp_wh_net_relation where (delete_flag=0 or delete_flag is null)" +
            "and CONCAT(COALESCE(demand_wh_st_code, ''), COALESCE(item_cate_code, ''), COALESCE(item_code, '')) = (?1)",nativeQuery = true)
    List<ScpWhNetRelationDO> findByAllBussinessKey(String concatKey);

    @Query(value = "select * from scp_wh_net_relation where (delete_flag=0 or delete_flag is null)" +
            "and CONCAT(COALESCE(type, ''),COALESCE(supply_wh_code, ''), COALESCE(demand_wh_st_code, ''), COALESCE(item_code, '')) in (?1)",nativeQuery = true)
    List<ScpWhNetRelationDO> findByAllConcatKey(List<String> concatKey);


    @Modifying
    @Query(value = "delete from scp_wh_net_relation where (delete_flag=0 or delete_flag is null) and status = true and CONCAT(COALESCE(demand_wh_st_code, ''), COALESCE(item_cate_code, ''), COALESCE(item_code, '')) in (?1)",nativeQuery = true)
    void deleteByConcatKey(List<String> concatKey);

    List<ScpWhNetRelationDO> findByIdIn(List<Long> ids);

}
