package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.scp.boh.StoreReceiveSendParam;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveCancelListener implements MessageQueueListener<StoreReceiveSendParam> {

    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final RedisTemplate redisClient;
    private final TransactionTemplate transactionTemplate;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;
    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveSendParam.CANCEL_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSendParam storeReceiveSendParam) {
        log.info("调拨订单取消：" + JSON.toJSONString(storeReceiveSendParam));
        if ("TRO_AUTO_CLOSE".equals(storeReceiveSendParam.getDocType())) {
            log.info("调拨订单自动关闭不做业务处理:{}");
            return;
        }


        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollUtil.isNotEmpty(receiveDOS) && "T".equals(receiveDOS.get(0).getRtType())) {
            StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
            storeReceiveRepo.deleteAllById(storeReceiveDO.getId());
            storeReceiveDRepo.deleteAllByMasId(storeReceiveDO.getId());
        } else {
            List<Long> dIds = storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
            scpDemandOrderDDomainService.cancelOrderByDIds(dIds);
            scpDemandOrderDomainService.updateDocStatusById(storeReceiveSendParam.getOrderId(), ScpConstant.CANCEL);

        }
        Optional<ScpDemandOrderDTO> demandOrder = scpDemandOrderDomainService.findDemandOrderById(storeReceiveSendParam.getOrderId());
        if (demandOrder.isPresent()){
            ScpDemandOrderDTO demandOrderDTO = demandOrder.get();
            List<ScpDemandOrderDDTO> demandOrderDDTOList  = scpDemandOrderDDomainService.findDemandOrderDByMasId(demandOrderDTO.getId());
            List<Long> activityIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollUtil.isEmpty(activityIds)) {
                return;
            }
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            transactionTemplate.execute(trans -> {
                try {
                    //更新门店已强配次数
                    ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
                    String key = ScpConstant.ALLOC_SETTING + demandOrderDTO.getDemandWhStCode();
                    Object obj = redisClient.opsForValue().get(key);
                    if (obj != null) {
                        String str = (String) obj;
                        var setting = JSON.parseObject(str, ScpAllocSettingRedisDO.class);
                        List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList().stream().filter(row -> {
                            if (!activityIds.contains(row.getActivityId())) {
                                return false;
                            }
                            if ((row.getAllocNum() - 1) > 0) {
                                return true;
                            } else {
                                return false;
                            }
                        }).map(row -> {
                            row.setAllocNum(row.getAllocNum() - 1);
                            return row;
                        }).collect(Collectors.toList());
                        scpAllocSettingRedisDO.setActivityList(activityList);
                        redisClient.opsForValue().set(key, JSONUtil.toJsonStr(scpAllocSettingRedisDO));
                    }
                    scpAllocSettingStoreRepo.minAllocNumByParam(activityIds,  demandOrderDTO.getDemandWhStCode());
                    return null;
                } catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
        }
    }

}
