package com.elitesland.scp.workflow;

import com.elitesland.scp.common.CallBackPathConstant;
import com.elitesland.scp.workflow.service.FeedbackProcessService;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * @author Danny.Wang
 * @title ItemAddWfCallBackController
 * @Date2023/1/3 17:13
 */
@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(CallBackPathConstant.FEEDBACK_PATH)
public class ScpFeedbackCallBackController implements WorkflowCallBack {

    private final FeedbackProcessService feedbackProcessService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("payload:{}",payload);
        return WorkflowResult.success(new ArrayList<>());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());

        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("状态修改回调:{}",payload.toString());
        //供应商申请
        feedbackProcessService.processStatusChange(getId(payload.getBusinessKey()), payload.getProcInstStatus(),payload.getCommentInfo().getComment());
        return WorkflowResult.success(null);
    }

    //从businessKey中提取id
    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }
}
