/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.setting;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingBaseParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/setting"}, produces={"application/json"})
public class ScpOrderSettingController {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderSettingController.class);
    private final ScpOrderSettingService scpOrderSettingService;

    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e-  \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpOrderSettingPageRespVO>> queryOrderSetting(@RequestBody ScpOrderSettingPageParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] queryOrderSetting  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpOrderSettingService.page(paramVO));
    }

    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e - \u67e5\u8be2\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpOrderSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-ORDER-SETTING] findIdOne, id ={}", (Object)id);
        return this.scpOrderSettingService.findOrderSettingById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e- \u4e0b\u62c9")
    @PostMapping(value={"/list"})
    public ApiResult<List<ScpOrderSettingRespVO>> queryOrderSettingList(@RequestBody ScpOrderSettingParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] queryOrderSettingList  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpOrderSettingService.queryOrderSettingList(paramVO));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e - \u4fdd\u5b58")
    public ApiResult<Long> saveOrderSetting(@RequestBody @Validated ScpOrderSettingSaveVO saveVO) {
        log.info("[SCP-ORDER-SETTING] saveOrderSetting  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpOrderSettingService.saveOrderSetting(saveVO));
    }

    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e - \u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/change"})
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpOrderSettingStatusParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] changeStatus paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpOrderSettingService.changeOrderSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5355\u636e\u7c7b\u578b\u914d\u7f6e - \u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ORDER-SETTING] delete ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpOrderSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u6839\u636e\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u9996\u9009\u5546\u54c1\u5206\u7c7b")
    @PostMapping(value={"/cateCode"})
    public ApiResult<Object> getFirstCateCode(@RequestBody ScpOrderSettingBaseParamVO paramVO) {
        log.info("[SCP-ORDER-SETTING] getFirstCateCode param = {}", (Object)paramVO);
        return ApiResult.ok((Object)this.scpOrderSettingService.getFirstItemCate(paramVO));
    }

    public ScpOrderSettingController(ScpOrderSettingService scpOrderSettingService) {
        this.scpOrderSettingService = scpOrderSettingService;
    }
}

