package com.elitesland.scp.application.facade.vo.whnet;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-20
* @Version 1.0
**/

@Data
public class ScpWhNetRelationPageParamVO extends AbstractOrderQueryParam implements Serializable {

    @ApiModelProperty(value = "供应仓库id集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> supplyWhIds;

    @ApiModelProperty(value = "类型集合")
    private List<String> types;

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    private List<Long> demandWhStIds;

    @ApiModelProperty(value = "需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty(value = "商品品类编码")
    private List<String> itemCateCodes;

    @ApiModelProperty(value = "商品id集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty(value = "计划员数据权限")
    private Boolean scpmanAuthority;

    @ApiModelProperty(value = "仓库集合")
    private List<Long> whIds;

    @ApiModelProperty(value = "门店集合")
    private List<Long> storeIds;

    @ApiModelProperty("销售公司编码集合")
    private List<String> ouCodes;

}