package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpsmanAuthprityComponentImportImpl implements ScpsmanAuthorityComponentService {

    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiSalRpcService rmiSalRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return PagingVO.<ScpsmanAuthorityComponentVO>builder()
                    .total(0)
                    .records(null)
                    .build();
        }
        List<ScpsmanAuthorityComponentVO> collect = scpManAuthorityPageRespVOPagingVO.stream().map(ScpDemandAuthorityConvert.INSTANCE::pageVoToComponentVo).collect(Collectors.toList());
        List<String> storeCodeList = collect.stream().filter(t -> ObjectUtil.isNotNull(t.getStWhCode())).map(ScpsmanAuthorityComponentVO::getStWhCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> storeMap = rmiOrgStoreRpcService.getOrgStoreBaseMap(storeCodeList);
        collect.stream().forEach(t -> {
            OrgStoreBaseRpcDTO orgStoreRpcDTO = storeMap.get(t.getStWhCode());
            t.setStoreType2(orgStoreRpcDTO.getStoreType2());
            //门店客户(子客户)
            t.setStCustCode(orgStoreRpcDTO.getCustCode());
            t.setStCustName(orgStoreRpcDTO.getCustName());
            t.setStWhName(orgStoreRpcDTO.getStoreName());
            t.setBrandCode(orgStoreRpcDTO.getBrandCode());
            t.setStoreOuCode(orgStoreRpcDTO.getOuCode());
            t.setDailyFlag(orgStoreRpcDTO.getDailyFlag());
            t.setPreDailyFlag(orgStoreRpcDTO.getPreDailyFlag());
        });
        return PagingVO.<ScpsmanAuthorityComponentVO>builder()
                .total(scpManAuthorityPageRespVOPagingVO.getTotal())
                .records(collect)
                .build();
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        //默认查询门店
        paramVO.setType(0L);
        PagingVO<ScpsmanAuthorityComponentVO> scpManAuthorityPageRespVOPagingVO = this.salemansAuthorityComponentPage(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isNotEmpty()) {
            ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO = scpManAuthorityPageRespVOPagingVO.getRecords().get(0);
            this.storeTypeQuery(scpsmanAuthorityComponentVO);
            return scpsmanAuthorityComponentVO;

        }
        return null;
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
        OrgStoreDetailRpcDTO byCode = rmiOrgStoreRpcService.getByCode(scpsmanAuthorityComponentVO.getStWhCode());
        if (Objects.nonNull(byCode)) {
            scpsmanAuthorityComponentVO.setStoreType2(byCode.getStoreType2());
            scpsmanAuthorityComponentVO.setStoreType2Name(byCode.getStoreType2Name());
            scpsmanAuthorityComponentVO.setStoreOuCode(byCode.getOuCode());
            if (StringUtils.isBlank(scpsmanAuthorityComponentVO.getStCustCode())){
                //门店客户(子客户)
                scpsmanAuthorityComponentVO.setStCustCode(byCode.getCustCode());
                scpsmanAuthorityComponentVO.setStCustName(byCode.getCustName());

            }
        }
        //查看门店客户的主客户和是否是外部
        if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStCustCode())){
            List<CustBaseDTO> custBaseInfoDTOList = rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode()));
            if (CollectionUtil.isNotEmpty(custBaseInfoDTOList)){
                CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
                //主客户
                scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());

                //主客户的信息
                if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStoreCustCode())){
                    List<CustBaseInfoDTO> custBaseInfoDTOS = rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode()));
                    if (CollectionUtil.isNotEmpty(custBaseInfoDTOS)) {
                        CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                        scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                        if (Objects.equals(custBaseInfoDTO1.getCustType2(),"A")){
                            scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                        }
                    }
                }
            }
        }
    }

    /**
     * 根据当前登陆人,类型查询计划员权限
     *
     * @param paramVO
     * @return
     */
    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        //默认查询启用状态计划员权限
        paramVO.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.listQuery(paramVO);
        if (CollUtil.isEmpty(scpManAuthorityPageRespVOPagingVO)) {
            return new ArrayList();
        }
        return scpManAuthorityPageRespVOPagingVO.stream().map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
    }
}
