package com.elitesland.scp.application.service.export;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightExportRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderTemplatePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplatePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplateRespVO;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import com.elitesland.scp.application.service.order.ScpOrderTemplateService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpStoreOrderTemplateServiceExportImpl implements DataExport<ScpOrderTemplatePageRespVO, ScpOrderTemplatePageParamVO>{
    private final ScpOrderTemplateService orderTemplateService;

    @Override
    public String getTmplCode() {
        return "scp_store_order_template_export";
    }

    @Override
    public PagingVO<ScpOrderTemplatePageRespVO> executeExport(ScpOrderTemplatePageParamVO queryParam) {


        // 2. 定义目标字符串格式（例如：yyyy-MM-dd HH:mm:ss）
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("HH:mm:ss");



        orderTemplateService.page(queryParam).getRecords().forEach(s -> {
            s.setIsActiveName(s.getIsActive() == 1 ? "是" : "否");
            s.setDeadlineTimeStr(s.getDeadlineTime().format(formatter2));
            s.setStartDateStr(s.getStartDate().format(formatter));
            s.setEndDateStr(s.getEndDate().format(formatter));

        });
        return orderTemplateService.page(queryParam);
    }
}
