/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.dto.invwh.InvWhSimpleRpcDtoParam;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockDownLoadParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockDownloadVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockSaveVO;
import com.elitesland.scp.application.service.stock.ScpSafetyTargetStockService;
import com.elitesland.scp.domain.convert.stock.ScpSafetyTargetStockConvert;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.domain.service.stock.ScpSafetyTargetStockDomainService;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSafetyTargetStockServiceImpl
implements ScpSafetyTargetStockService {
    private static final Logger log = LoggerFactory.getLogger(ScpSafetyTargetStockServiceImpl.class);
    private final ScpSafetyTargetStockDomainService safetyTargetStockDomainService;
    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;
    private final InvWhProvider invWhProvider;
    private final ItmItemRpcService itemRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final UdcProvider udcProvider;

    @Override
    public PagingVO<ScpSafetyTargetStockPageVO> searchPage(ScpSafetyTargetStockPageParam param) {
        PagingVO<ScpSafetyTargetStockPageVO> page = this.safetyTargetStockDomainService.searchPage(param);
        Map uomMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List itemIds = page.getRecords().stream().map(ScpSafetyTargetStockPageVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List itemSimpleRpcDTOS = this.itemRpcService.findSimpleItem(itemIds);
            Map<Long, ItmItemSimpleRpcDTO> itmMap = itemSimpleRpcDTOS.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, v -> v, (e1, e2) -> e1));
            page.getRecords().forEach(d -> {
                if (itmMap.containsKey(d.getItemId())) {
                    d.setItemName(((ItmItemSimpleRpcDTO)itmMap.get(d.getItemId())).getItemName());
                    d.setItemCode(((ItmItemSimpleRpcDTO)itmMap.get(d.getItemId())).getItemCode());
                    d.setBrandName(((ItmItemSimpleRpcDTO)itmMap.get(d.getItemId())).getBrandName());
                    d.setBrand(((ItmItemSimpleRpcDTO)itmMap.get(d.getItemId())).getBrand());
                    d.setItemType2(((ItmItemSimpleRpcDTO)itmMap.get(d.getItemId())).getItemType2());
                }
                d.setPlanUomName((String)uomMap.get(d.getPlanUom()));
            });
        }
        return page;
    }

    @Override
    @Transactional
    public String saveSafetyTargetStock(ScpSafetyTargetStockSaveVO createParam) {
        ScpSafetyTargetStockDTO saveVoToDto = ScpSafetyTargetStockConvert.INSTANCE.saveVoToDto(createParam);
        String businessKey = createParam.computeBusinessKey();
        if (createParam.getId() == null) {
            if (this.safetyTargetStockDomainService.findByBusinessKey(businessKey) != null) {
                throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u5df2\u5b58\u5728");
            }
        } else {
            ScpSafetyTargetStockDTO safetyTargetStockDTO = this.safetyTargetStockDomainService.findById(createParam.getId());
            if (safetyTargetStockDTO == null) {
                throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            List<ScpSafetyTargetStockDTO> safetyTargetStockDTOS = this.safetyTargetStockDomainService.findByBusinessKey(businessKey);
            long count = safetyTargetStockDTOS.stream().filter(d -> Objects.equals(d.getId(), createParam.getId())).count();
            if (count != 1L) {
                throw new BusinessException(ApiCode.FAIL, "\u540c\u4e00\u516c\u53f8\u3001\u4ed3\u5e93\u3001\u5546\u54c1 \u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d");
            }
            ScpSafetyTargetStockConvert.INSTANCE.copySaveParamToDto(createParam, safetyTargetStockDTO);
        }
        saveVoToDto.setBusinessId(saveVoToDto.getOuId().toString() + saveVoToDto.getWhId().toString() + saveVoToDto.getItemId().toString());
        this.safetyTargetStockDomainService.save(saveVoToDto);
        return saveVoToDto.getId().toString();
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        this.safetyTargetStockDomainService.delete(ids);
    }

    @Override
    @Transactional
    public void batchSaveSafetyTargetStock(List<ScpSafetyTargetStockSaveVO> createParams) {
        if (CollectionUtils.isEmpty(createParams)) {
            return;
        }
        List<String> businessKeys = createParams.stream().map(ScpSafetyTargetStockSaveVO::computeBusinessKey).collect(Collectors.toList());
        List businessKeys2 = createParams.stream().map(ScpSafetyTargetStockSaveVO::computeBusinessKey).distinct().collect(Collectors.toList());
        if (businessKeys2.size() != businessKeys.size()) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u540c\u516c\u53f8\u3001\u4ed3\u5e93\u3001\u5546\u54c1\u914d\u7f6e\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
        }
        List<ScpSafetyTargetStockDO> targetStockDOS = this.scpSafetyTargetStockRepo.findAllByBusinessIdIn(businessKeys);
        ArrayList existIds = new ArrayList();
        Map<Object, Object> existMap = new HashMap();
        if (CollectionUtils.isNotEmpty(targetStockDOS)) {
            existMap = targetStockDOS.stream().collect(Collectors.groupingBy(d -> d.getWhId() + d.getOuId() + d.getItemId()));
        }
        List saveVOList = createParams.stream().filter(d -> d.getId() != null).collect(Collectors.toList());
        List saveVOList2 = createParams.stream().filter(d -> d.getId() == null).collect(Collectors.toList());
        ArrayList<ScpSafetyTargetStockDTO> dtoList = new ArrayList<ScpSafetyTargetStockDTO>();
        Map<Object, Object> finalExistMap = existMap;
        if (CollectionUtils.isNotEmpty(saveVOList)) {
            List<Long> ids = saveVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<ScpSafetyTargetStockDTO> safetyTargetStockDTOS = this.safetyTargetStockDomainService.findIdBatch(ids);
            Map<Long, ScpSafetyTargetStockDTO> targetStockDTOMap = safetyTargetStockDTOS.stream().collect(Collectors.toMap(BaseViewModel::getId, d -> d));
            List stockDTOS = saveVOList.stream().map(d -> {
                List existList;
                d.setBusinessId(d.getBusinessId());
                List stockDOList = (List)finalExistMap.get(d.getWhId() + d.getOuId() + d.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)stockDOList) && CollectionUtils.isNotEmpty(existList = stockDOList.stream().filter(e -> !Objects.equals(e.getId(), d.getId())).collect(Collectors.toList()))) {
                    existIds.addAll(existList.stream().map(BaseModel::getId).collect(Collectors.toList()));
                }
                ScpSafetyTargetStockDTO targetStockDTO = (ScpSafetyTargetStockDTO)targetStockDTOMap.get(d.getId());
                ScpSafetyTargetStockConvert.INSTANCE.copySaveParamToDto((ScpSafetyTargetStockSaveVO)d, targetStockDTO);
                targetStockDTO.setBusinessId(targetStockDTO.getOuId().toString() + targetStockDTO.getWhId().toString() + targetStockDTO.getItemId().toString());
                return targetStockDTO;
            }).collect(Collectors.toList());
            dtoList.addAll(stockDTOS);
        }
        if (CollectionUtils.isNotEmpty(saveVOList2)) {
            List stockDTOS = saveVOList2.stream().map(d -> {
                d.setBusinessId(d.getBusinessId());
                List stockDOList = (List)finalExistMap.get(d.getWhId() + d.getOuId() + d.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)stockDOList)) {
                    existIds.addAll(stockDOList.stream().map(BaseModel::getId).collect(Collectors.toList()));
                }
                return ScpSafetyTargetStockConvert.INSTANCE.saveVoToDto((ScpSafetyTargetStockSaveVO)d);
            }).collect(Collectors.toList());
            dtoList.addAll(stockDTOS);
        }
        if (CollectionUtils.isNotEmpty(existIds)) {
            this.scpSafetyTargetStockRepo.deleteAllById(existIds);
        }
        if (CollectionUtils.isNotEmpty(dtoList)) {
            this.safetyTargetStockDomainService.saveAll(dtoList);
        }
    }

    @Override
    public List<ScpSafetyTargetStockDownloadVO> downloadTmplFile(ScpSafetyTargetStockDownLoadParam param) {
        ArrayList<ScpSafetyTargetStockDownloadVO> downloadVOS = new ArrayList<ScpSafetyTargetStockDownloadVO>();
        InvWhSimpleRpcDtoParam invWhRpcDtoParam = new InvWhSimpleRpcDtoParam();
        invWhRpcDtoParam.setOuIds(param.getOuIds());
        List invWhRpcSimpleDTOS = (List)this.invWhProvider.findNonStoreWhRpcDTO(invWhRpcDtoParam).computeData();
        if (CollectionUtils.isEmpty((Collection)invWhRpcSimpleDTOS)) {
            return downloadVOS;
        }
        List simpleOuDto1 = this.orgOuRpcService.findSimpleOuDto(param.getOuIds());
        if (CollectionUtils.isEmpty((Collection)simpleOuDto1)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        Map<Long, OrgOuRpcSimpleDTO> ouMap1 = simpleOuDto1.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v, (e1, e2) -> e1));
        List ouCodes = invWhRpcSimpleDTOS.stream().map(InvWhRpcSimpleDTO::getOuCode).distinct().collect(Collectors.toList());
        List ouIds = invWhRpcSimpleDTOS.stream().map(InvWhRpcSimpleDTO::getOuId).distinct().collect(Collectors.toList());
        List filterOuNames = param.getOuIds().stream().filter(d -> !ouIds.contains(d)).filter(d -> ouMap1.get(d) != null).map(d -> ((OrgOuRpcSimpleDTO)ouMap1.get(d)).getOuName()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterOuNames)) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u516c\u53f8\uff1a" + filterOuNames + "\u4e0d\u5b58\u5728\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93\uff0c\u8bf7\u914d\u7f6e");
        }
        List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(ouIds);
        Map<String, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, v -> v, (e1, e2) -> e1));
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setBuCodes(ouCodes);
        businessRpcDtoParam.setMrpType("PD");
        List businessRpcDTOList = this.itemRpcService.findItmItemBusinessByParam(businessRpcDtoParam);
        if (CollectionUtils.isEmpty((Collection)businessRpcDTOList)) {
            log.info("\u6ca1\u6709\u7b26\u5408\u8fd0\u884cMRP\u7c7b\u578b\u5546\u54c1\u6570\u636e\uff0c\u8bf7\u5148\u521b\u5efa\u5546\u54c1");
            return downloadVOS;
        }
        Map uomMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        Map<String, List<ItmItemBusinessRpcDTO>> businessItemMap = businessRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getBuCode));
        invWhRpcSimpleDTOS.forEach(d -> {
            List itemBusinessRpcDTOS = (List)businessItemMap.get(d.getOuCode());
            if (itemBusinessRpcDTOS != null && !itemBusinessRpcDTOS.isEmpty()) {
                itemBusinessRpcDTOS.forEach(i -> {
                    ScpSafetyTargetStockDownloadVO safetyTargetStockDownloadVO = new ScpSafetyTargetStockDownloadVO();
                    safetyTargetStockDownloadVO.setWhCode(d.getWhCode());
                    safetyTargetStockDownloadVO.setWhName(d.getWhName());
                    safetyTargetStockDownloadVO.setOuCode(d.getOuCode());
                    safetyTargetStockDownloadVO.setOuName(((OrgOuRpcSimpleDTO)ouMap.get(d.getOuCode())).getOuName());
                    safetyTargetStockDownloadVO.setItemCode(i.getItemCode());
                    safetyTargetStockDownloadVO.setItemName(i.getItemName());
                    safetyTargetStockDownloadVO.setPlanUom(i.getUom4());
                    safetyTargetStockDownloadVO.setPlanUomName((String)uomMap.get(i.getUom4()));
                    downloadVOS.add(safetyTargetStockDownloadVO);
                });
            }
        });
        return downloadVOS;
    }

    public ScpSafetyTargetStockServiceImpl(ScpSafetyTargetStockDomainService safetyTargetStockDomainService, ScpSafetyTargetStockRepo scpSafetyTargetStockRepo, InvWhProvider invWhProvider, ItmItemRpcService itemRpcService, OrgOuRpcService orgOuRpcService, UdcProvider udcProvider) {
        this.safetyTargetStockDomainService = safetyTargetStockDomainService;
        this.scpSafetyTargetStockRepo = scpSafetyTargetStockRepo;
        this.invWhProvider = invWhProvider;
        this.itemRpcService = itemRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.udcProvider = udcProvider;
    }
}

