/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.PurPriceParamRpcDTO;
import com.elitesland.pur.dto.po.PurPoDDTO;
import com.elitesland.pur.dto.po.PurPoDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.pur.provider.PurPoDProvider;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.pur.provider.PurPriceProvider;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiPurRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiPurRpcService.class);
    private final PurPriceProvider purPriceProvider;
    private final PurPoProvider purPoProvider;
    private final PurPoDProvider purPoDProvider;

    public String checkItemPurPrice(List<PurPriceParamRpcDTO> param) {
        log.info("\u6821\u9a8c\u5916\u91c7\u91c7\u8d2d\u4ef7\u683c,{}", (Object)JSON.toJSONString(param));
        ApiResult itemPurPrice = this.purPriceProvider.checkItemPurPrice(param);
        log.info("\u6821\u9a8c\u5916\u91c7\u91c7\u8d2d\u4ef7\u683c\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)itemPurPrice));
        if (!itemPurPrice.isSuccess()) {
            return itemPurPrice.getMsg();
        }
        return "";
    }

    public List<PurPoSaveDTO> createPo(List<PurPoSaveDTO> param) {
        log.info("\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355,{}", (Object)JSON.toJSONString(param));
        List purResult = (List)this.purPoProvider.createBatch(param).computeData();
        log.info("\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)purResult));
        return purResult;
    }

    public List<PurPoPayRpcDTO> payInfo(Long id) {
        ApiResult payInfoByPoId = this.purPoProvider.findPayInfoByPoId(id);
        if (!payInfoByPoId.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38:" + payInfoByPoId.getMsg());
        }
        return (List)payInfoByPoId.getData();
    }

    public PurPoDTO findPurPoById(Long id) {
        List poList = this.purPoProvider.findIdBatch(List.of(id));
        if (CollUtil.isEmpty((Collection)poList)) {
            throw new BusinessException("\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return (PurPoDTO)poList.get(0);
    }

    public List<PurPoDDTO> findPurPoDByPoId(Long poId) {
        List podList = this.purPoDProvider.findByMasIds(List.of(poId));
        if (CollUtil.isEmpty((Collection)podList)) {
            throw new BusinessException("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        return podList;
    }

    public void updateOnlinePay(PurPoOnlinePayParamDTO payParamDTO) {
        try {
            this.purPoProvider.updateOnlinePay(payParamDTO);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5728\u7ebf\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public PurPoOnlinePayRpcDTO findOnlinePayInfo(Long poId) {
        PurPoOnlinePayRpcDTO onlinePayInfo = this.purPoProvider.findOnlinePayInfo(poId);
        log.info("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355:{},\u652f\u4ed8\u4fe1\u606f:{}", (Object)poId, (Object)JSONUtil.toJsonStr((Object)onlinePayInfo));
        return onlinePayInfo;
    }

    public void closePo(List<Long> ids) {
        try {
            this.purPoProvider.closePo(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u91c7\u8d2d\u57df\uff1a\u5173\u95ed\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38" + e.toString());
        }
    }

    public RmiPurRpcService(PurPriceProvider purPriceProvider, PurPoProvider purPoProvider, PurPoDProvider purPoDProvider) {
        this.purPriceProvider = purPriceProvider;
        this.purPoProvider = purPoProvider;
        this.purPoDProvider = purPoDProvider;
    }
}

