/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.item;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.domain.entity.item.ScpCateItemDO;
import com.elitesland.scp.domain.service.item.ScpCateItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepo;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.param.AppItemRpcParamVO;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.service.item.CateItemRpcService;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/scp/cate/item"})
public class ScpCateItemDomainServiceImpl
implements ScpCateItemDomainService,
CateItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(ScpCateItemDomainServiceImpl.class);
    private final ScpCateItemRepo scpCateItemRepo;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    public void saveBatch(List<ScpCateItemDO> scpCateItemDOS) {
        this.scpCateItemRepo.saveAll(scpCateItemDOS);
    }

    @Override
    public void delete(List<Long> ids) {
        this.scpCateItemRepo.deleteAllByIdInBatch(ids);
    }

    @Override
    public ApiResult<List<ScpCateItemDTO>> query(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    public ApiResult<List<String>> queryCateCodeByDocType(AppItemRpcParamVO paramVO) {
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            List<String> itemTypes = this.scpOrderSettingDomainService.findItemCatesByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        log.info("queryCateCodeByDocType paramVO:{}", (Object)paramVO);
        List<AppItmItemPageVO> byDocType = this.scpCateItemRepoProc.getByDocType(paramVO);
        List itemCateCodes = byDocType.stream().map(AppItmItemPageVO::getItemCateCode).collect(Collectors.toList());
        return ApiResult.ok(itemCateCodes);
    }

    @Override
    public List<String> existByItemCodes(List<String> itemCodes) {
        return this.scpCateItemRepoProc.queryByItemCodes(itemCodes);
    }

    public ApiResult<List<String>> findItemCodesBy(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryItemCode(cateItemRpcParam));
    }

    public ApiResult<List<ScpCateItemDTO>> listByParam(CateItemRpcParam cateItemRpcParam) {
        return ApiResult.ok(this.scpCateItemRepoProc.queryDto(cateItemRpcParam));
    }

    @Override
    public void changeHotFlag(ScpCateItemHotParamVO paramVO) {
        this.scpCateItemRepoProc.changeHotFlag(paramVO);
    }

    @Override
    public PagingVO<ScpCateItemRespVO> page(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemRespVO> itemList = this.scpCateItemRepoProc.queryItemList(paramVO);
            List<ScpOrderSettingRespVO> settingList = this.scpOrderSettingDomainService.findEnabledSetting();
            if (CollUtil.isEmpty(settingList)) {
                return new PagingVO(count, itemList);
            }
            Map<String, List<ScpOrderSettingRespVO>> settingMap = settingList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).collect(Collectors.groupingBy(row -> (String)StrUtil.split((CharSequence)row.getItemCate(), (CharSequence)",").get(0)));
            Map<Long, List<ItmItemScpBaseRpcDTO>> itemMap = this.getItemMap(itemList);
            itemList.forEach(row -> {
                if (itemMap.containsKey(row.getItemId())) {
                    Optional<ItmItemAttachmentRpcDTO> first;
                    ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)((List)itemMap.get(row.getItemId())).get(0);
                    row.setSpec(itmItemScpBaseRpcDTO.getSpec());
                    List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                    if (CollUtil.isNotEmpty((Collection)spuAttchmentList) && (first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst()).isPresent()) {
                        row.setUrl(first.get().getUrl());
                    }
                    row.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
                    row.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
                    row.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
                    row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                    row.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
                    row.setUom(itmItemScpBaseRpcDTO.getUom2());
                    List settingRespVOS = (List)settingMap.get(itmItemScpBaseRpcDTO.getItemType());
                    if (CollUtil.isEmpty((Collection)settingRespVOS)) {
                        return;
                    }
                    ScpOrderSettingRespVO setting = (ScpOrderSettingRespVO)settingRespVOS.get(0);
                    row.setDocType(setting.getDocType());
                }
            });
            Map<String, List<ScpCateItemRespVO>> docTypeMap = itemList.stream().filter(row -> StrUtil.isNotBlank((CharSequence)row.getDocType())).collect(Collectors.groupingBy(ScpCateItemRespVO::getDocType));
            HashMap allPriceMap = new HashMap();
            docTypeMap.forEach((k, v) -> {
                ScpOrderSettingRespVO setting = this.scpOrderSettingDomainService.findCacheByDocType((String)k, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                List<AppItemActivityItemPriceParamVO> priceParamVOS = v.stream().map(row -> {
                    AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                    priceParamVO.setItemCode(row.getItemCode());
                    priceParamVO.setItemId(row.getItemId());
                    priceParamVO.setItemCateCode(row.getItemCateCode());
                    priceParamVO.setUom(row.getUom());
                    return priceParamVO;
                }).collect(Collectors.toList());
                Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), setting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
                allPriceMap.putAll(priceMap);
            });
            itemList.forEach(row -> {
                if (!allPriceMap.containsKey(row.getItemCode())) {
                    return;
                }
                row.setPrice(((PriPriceRpcDTO)((List)allPriceMap.get(row.getItemCode())).get(0)).getPrice());
            });
            return new PagingVO(count, itemList);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpCateItemPageVO> skuPage(ScpCateItemPageParamVO paramVO) {
        long count = this.scpCateItemRepoProc.countItem(paramVO);
        if (count > 0L) {
            List<ScpCateItemPageVO> scpCateItemPageVOS = this.scpCateItemRepoProc.skuPage(paramVO);
            return new PagingVO(count, scpCateItemPageVOS);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSorNo(Long id, Integer sorNo) {
        this.scpCateItemRepoProc.updateSortNoById(sorNo, id);
    }

    private Map<Long, List<ItmItemScpBaseRpcDTO>> getItemMap(List<ScpCateItemRespVO> cateItemList) {
        List itemIds = cateItemList.stream().map(ScpCateItemRespVO::getItemId).collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> baseRpcDTOList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isNotEmpty(baseRpcDTOList)) {
            return baseRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getId));
        }
        return new HashMap<Long, List<ItmItemScpBaseRpcDTO>>();
    }

    public ScpCateItemDomainServiceImpl(ScpCateItemRepo scpCateItemRepo, ScpCateItemRepoProc scpCateItemRepoProc, RmiItemService rmiItemService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService) {
        this.scpCateItemRepo = scpCateItemRepo;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.rmiItemService = rmiItemService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
    }
}

