/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.stock;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invIo.InvIoDateRangeParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.dto.invwh.InvWhSimpleRpcDtoParam;
import com.elitesland.inv.provider.InvIoProvider;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcParamVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockDownLoadParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockDownloadVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockParamVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockRespVO;
import com.elitesland.scp.application.facade.vo.stock.ScpStStockCalcUpdateParam;
import com.elitesland.scp.application.facade.vo.stock.ScpStStockSyncParamVO;
import com.elitesland.scp.application.facade.vo.stock.mq.ScpPredictStStockCalcSendParam;
import com.elitesland.scp.application.service.stock.ScpPredictStStockCalcService;
import com.elitesland.scp.application.service.stock.ScpPredictStockSendUtil;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockCalcDO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockCalcRepo;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockCalcRepoProc;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepo;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepoProc;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepoProc;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ScpPredictStStockCalcServiceImpl
implements ScpPredictStStockCalcService {
    private static final Logger log = LoggerFactory.getLogger(ScpPredictStStockCalcServiceImpl.class);
    private final ScpPredictStStockCalcRepoProc scpPredictStStockCalcRepoProc;
    private final ScpPredictStStockCalcRepo scpPredictStStockCalcRepo;
    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;
    private final ScpPredictStStockRepo scpPredictStStockRepo;
    private final TaskExecutor executor;
    private final InvWhProvider invWhProvider;
    private final OrgOuRpcService orgOuRpcService;
    private final ItmItemRpcService itemRpcService;
    private final InvIoProvider invIoProvider;
    private final ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final UdcProvider udcProvider;

    @Override
    public PagingVO<ScpPredictStStockCalcPageVO> page(ScpPredictStStockCalcPageParam param) {
        PagingVO<ScpPredictStStockCalcPageVO> page;
        List<Long> stIds;
        if (CollectionUtils.isNotEmpty(param.getWhIds())) {
            stIds = this.scpPredictStStockRepoProc.findStIdsByWhIds(param.getWhIds());
            if (CollectionUtils.isEmpty(stIds)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            if (CollectionUtils.isEmpty(param.getStIds())) {
                param.setStIds(stIds);
            } else {
                param.getStIds().addAll(stIds);
            }
        }
        if (CollectionUtils.isNotEmpty(param.getItemIds())) {
            stIds = this.scpPredictStStockRepoProc.findStIdsByItemIds(param.getItemIds());
            if (CollectionUtils.isEmpty(stIds)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            if (CollectionUtils.isEmpty(param.getStIds())) {
                param.setStIds(stIds);
            } else {
                param.getStIds().addAll(stIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(page = this.scpPredictStStockCalcRepoProc.page(param)).getRecords())) {
            Map stockStatusMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "ST_STOCK_STATUS");
            page.getRecords().forEach(d -> d.setCalcuStatusName((String)stockStatusMap.get(d.getCalcuStatus())));
        }
        return page;
    }

    @Override
    public PagingVO<ScpPredictStStockRespVO> stStockDetailPage(ScpPredictStStockParamVO param) {
        PagingVO<ScpPredictStStockRespVO> page = this.scpPredictStStockRepoProc.stStockDetailPage(param);
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List itemIds = page.getRecords().stream().map(d -> d.getItemId()).distinct().collect(Collectors.toList());
            List simpleItem = this.itemRpcService.findSimpleItem(itemIds);
            Map<Long, ItmItemSimpleRpcDTO> itemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, v -> v, (e1, e2) -> e1));
            Map uom = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            Integer qtyPlace = SysUtils.getQtyPlace();
            page.getRecords().forEach(d -> {
                if (itemMap.get(d.getItemId()) != null) {
                    d.setItemName(((ItmItemSimpleRpcDTO)itemMap.get(d.getItemId())).getItemName());
                    Integer places = ((ItmItemSimpleRpcDTO)itemMap.get(d.getItemId())).getDecimalPlaces();
                    places = places == null ? qtyPlace : places;
                    d.setSaleQty(d.getIoQty().divide(d.getUomRatio(), (int)places, RoundingMode.HALF_UP));
                } else {
                    d.setSaleQty(d.getIoQty().divide(d.getUomRatio(), (int)qtyPlace, RoundingMode.HALF_UP));
                }
                d.setPlanUomName((String)uom.get(d.getPlanUom()));
            });
        }
        return page;
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        this.scpPredictStStockCalcRepo.deleteAllById(ids);
        this.scpPredictStStockRepo.deleteAllByStIdIn(ids);
    }

    @Override
    @Transactional
    public String calcPredictStStock(ScpPredictStStockCalcParamVO param) {
        if (CollectionUtils.isEmpty(param.getOuIds())) {
            throw new BusinessException(ApiCode.FAIL, "\u8ba1\u7b97\u524d\uff0c\u5148\u9009\u62e9\u516c\u53f8");
        }
        InvWhSimpleRpcDtoParam simpleRpcDtoParam = new InvWhSimpleRpcDtoParam();
        simpleRpcDtoParam.setOuIds(param.getOuIds());
        List whRpcSimpleDTOList = (List)this.invWhProvider.findNonStoreWhRpcDTO(simpleRpcDtoParam).computeData();
        if (CollectionUtils.isEmpty((Collection)whRpcSimpleDTOList)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4e0b\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5");
        }
        List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(param.getOuIds());
        if (CollectionUtils.isEmpty((Collection)simpleOuDto)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        List whOuIds = whRpcSimpleDTOList.stream().map(InvWhRpcSimpleDTO::getOuId).distinct().collect(Collectors.toList());
        List ouRpcSimpleDTOS = simpleOuDto.stream().filter(d -> whOuIds.contains(d.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ouRpcSimpleDTOS)) {
            throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4e0b\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap = whRpcSimpleDTOList.stream().collect(Collectors.groupingBy(InvWhRpcSimpleDTO::getOuId));
        Map<Long, OrgOuRpcSimpleDTO> ouMap = ouRpcSimpleDTOS.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v));
        List ouCodes = ouRpcSimpleDTOS.stream().filter(d -> whOuIds.contains(d.getId())).map(OrgOuRpcSimpleDTO::getOuCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ouCodes)) {
            throw new BusinessException(ApiCode.FAIL, "\u6ca1\u6709\u7b26\u5408\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93\u7684\u516c\u53f8\uff0c\u8bf7\u5148\u914d\u7f6e");
        }
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setBuCodes(ouCodes);
        businessRpcDtoParam.setMrpType("PD");
        List businessRpcDTOList = this.itemRpcService.findItmItemBusinessByParam(businessRpcDtoParam);
        if (CollectionUtils.isEmpty((Collection)businessRpcDTOList)) {
            log.info("\u6ca1\u6709\u7b26\u5408\u516c\u53f8\u8fd0\u884cMRP\u7c7b\u578b\u7ecf\u8425\u76ee\u5f55\u5546\u54c1\u6570\u636e\uff0c\u8bf7\u5148\u521b\u5efa\u5546\u54c1");
            throw new BusinessException(ApiCode.FAIL, "\u6ca1\u6709\u7b26\u5408\u516c\u53f8\u8fd0\u884cMRP\u7c7b\u578b\u7ecf\u8425\u76ee\u5f55\u5546\u54c1\u6570\u636e\uff0c\u8bf7\u5148\u521b\u5efa\u5546\u54c1");
        }
        Map<String, List<ItmItemBusinessRpcDTO>> businessItemMap = businessRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getBuCode));
        String lotNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("F", new ArrayList<String>());
        List<ScpPredictStStockCalcDO> scpPredictStStockCalcDOS = this.extractedStStockPredict(param, ouMap, ouWhMap, lotNo);
        Map<String, ScpPredictStStockCalcDO> map = scpPredictStStockCalcDOS.stream().collect(Collectors.toMap(d -> d.getOuId().toString() + d.getPredLotNo(), d -> d));
        List<Long> ouIds = param.getOuIds().stream().filter(whOuIds::contains).distinct().collect(Collectors.toList());
        LocalDateTime dateTime = LocalDateTime.now();
        final ArrayList stockSyncParamVOS = new ArrayList();
        ouIds.forEach(d -> {
            ScpStStockSyncParamVO scpStStockSyncParamVO = new ScpStStockSyncParamVO();
            scpStStockSyncParamVO.setOuId((Long)d);
            if (map.get(d + lotNo) != null) {
                scpStStockSyncParamVO.setStId(((ScpPredictStStockCalcDO)map.get(d + lotNo)).getId());
                scpStStockSyncParamVO.setDateTime(dateTime);
                stockSyncParamVOS.add(scpStStockSyncParamVO);
            }
        });
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ScpPredictStStockCalcSendParam sendParam = ScpPredictStStockCalcSendParam.build(stockSyncParamVOS);
                log.info("\u9884\u6d4b\u5b89\u5168\u5e93\u5b58&\u76ee\u6807\u5e93\u5b58 mq \u6d88\u606f\u5f00\u59cb\uff1a" + JSON.toJSONString((Object)sendParam));
                ScpPredictStockSendUtil.send(sendParam, "PREDICT_STOCK_CHANNEL");
                log.info("\u9884\u6d4b\u5b89\u5168\u5e93\u5b58&\u76ee\u6807\u5e93\u5b58 mq \u6d88\u606f\u6210\u529f\uff1a" + JSON.toJSONString((Object)sendParam));
            }
        });
        return lotNo;
    }

    @Override
    @Transactional
    public void calcuStStock(List<ScpStStockSyncParamVO> stockSyncParamVOS) {
        LocalDate datetime = stockSyncParamVOS.get(0).getDateTime().toLocalDate();
        LocalDate minusMonthsDate = datetime.minusDays(30L);
        long days = 30L;
        log.info("\u5f00\u59cb\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6,\u5f00\u59cb\u65f6\u95f4\uff1a{},\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)datetime, (Object)minusMonthsDate);
        List ouIds = stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getOuId).distinct().collect(Collectors.toList());
        List masIds = stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId).distinct().collect(Collectors.toList());
        List stStockCalcDOList = this.scpPredictStStockCalcRepo.findAllById(masIds);
        if (CollectionUtils.isEmpty((Collection)stStockCalcDOList)) {
            log.error("\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        Map<Long, ScpPredictStStockCalcDO> calcMap = stStockCalcDOList.stream().collect(Collectors.toMap(BaseModel::getId, d -> d));
        if (ouIds.size() != stockSyncParamVOS.size()) {
            ScpStStockCalcUpdateParam calcUpdateParam = new ScpStStockCalcUpdateParam();
            calcUpdateParam.setCalcuStatus("FAIL");
            calcUpdateParam.setStIds(stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId).collect(Collectors.toList()));
            calcUpdateParam.setCalcuMsg("\u6570\u636e\u5f02\u5e38\uff0c\u516c\u53f8\u91cd\u590d\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
            this.scpPredictStStockCalcRepoProc.updateStStockCalcStatus(calcUpdateParam);
            return;
        }
        InvWhSimpleRpcDtoParam simpleRpcDtoParam = new InvWhSimpleRpcDtoParam();
        simpleRpcDtoParam.setOuIds(ouIds);
        List whRpcSimpleDTOList = (List)this.invWhProvider.findNonStoreWhRpcDTO(simpleRpcDtoParam).computeData();
        List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(ouIds);
        Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap = whRpcSimpleDTOList.stream().collect(Collectors.groupingBy(InvWhRpcSimpleDTO::getOuId));
        Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v));
        List ouCodes = simpleOuDto.stream().map(OrgOuRpcSimpleDTO::getOuCode).collect(Collectors.toList());
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setBuCodes(ouCodes);
        businessRpcDtoParam.setMrpType("PD");
        List businessRpcDTOList = this.itemRpcService.findItmItemBusinessByParam(businessRpcDtoParam);
        Map<String, List<ItmItemBusinessRpcDTO>> businessItemMap = businessRpcDTOList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getBuCode));
        int size = stockSyncParamVOS.size();
        ArrayList<ScpStStockCalcUpdateParam> stockCalcUpdateParams = new ArrayList<ScpStStockCalcUpdateParam>();
        CompletableFuture[] futures = new CompletableFuture[size];
        ScpStStockCalcUpdateParam calcUpdateParam2 = new ScpStStockCalcUpdateParam();
        ArrayList stockCalcDOs2 = new ArrayList();
        ArrayList stockCalcDOs = new ArrayList();
        for (int i = 0; i < size; ++i) {
            ScpStStockCalcUpdateParam calcUpdateParam = new ScpStStockCalcUpdateParam();
            calcUpdateParam.setCalcuStatus("DONE");
            calcUpdateParam.setCalcuMsg(null);
            ScpStStockSyncParamVO scpStStockSyncParamVO = stockSyncParamVOS.get(i);
            Long ouId = scpStStockSyncParamVO.getOuId();
            Long stId = scpStStockSyncParamVO.getStId();
            calcUpdateParam.setStIds(List.of(scpStStockSyncParamVO.getStId()));
            List<InvWhRpcSimpleDTO> whRpcSimpleDTOS = ouWhMap.get(ouId);
            if (CollectionUtils.isEmpty(whRpcSimpleDTOS)) {
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(String.format("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u3010%s\u3011\u4e0b\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93", ouId));
                stockCalcUpdateParams.add(calcUpdateParam);
                log.error(String.format("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u3010%s\u3011\u4e0b\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93", ouId));
                continue;
            }
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(ouId);
            List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS = businessItemMap.get(ouRpcSimpleDTO.getOuCode());
            if (CollectionUtils.isEmpty(itemBusinessRpcDTOS)) {
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(String.format("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u3010%s\u3011\u4e0b\u7b26\u5408MRP\u7c7b\u578b\u7ecf\u8425\u76ee\u5f55\u5546\u54c1", ouId));
                stockCalcUpdateParams.add(calcUpdateParam);
                log.error(String.format("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u3010%s\u3011\u4e0b\u7b26\u5408MRP\u7c7b\u578b\u7ecf\u8425\u76ee\u5f55\u5546\u54c1", ouId));
                continue;
            }
            try {
                Map<Long, InvWhRpcSimpleDTO> whMap = whRpcSimpleDTOS.stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhId, d -> d));
                List whIds = whRpcSimpleDTOS.stream().map(InvWhRpcSimpleDTO::getWhId).distinct().collect(Collectors.toList());
                List itemIds = itemBusinessRpcDTOS.stream().map(ItmItemBusinessRpcDTO::getId).distinct().collect(Collectors.toList());
                InvIoDateRangeParamRpcDTO rangeParamRpcDTO = new InvIoDateRangeParamRpcDTO();
                rangeParamRpcDTO.setItemIds(itemIds);
                rangeParamRpcDTO.setWhIds(whIds);
                rangeParamRpcDTO.setOuId(ouId);
                rangeParamRpcDTO.setIoDateFrom(minusMonthsDate.atTime(LocalTime.of(0, 0, 0)));
                rangeParamRpcDTO.setIoDateTo(datetime.atTime(LocalTime.of(23, 59, 59)));
                rangeParamRpcDTO.setSceneCodes(List.of("SO_OUT", "SO_LOGIC_DELIVERY", "SO_LOGIC_RECEIPT", "SO_RETURN", "TRN003", "TRN_RELEASE_ISSUE", "TRN008", "TRN007", "TRN004"));
                log.info("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5e93\u5b58\u6d41\u6c34\uff0c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)rangeParamRpcDTO));
                List invIoRpcDTOS = (List)this.invIoProvider.findInvIoByDateRange(rangeParamRpcDTO).computeData();
                Map<Object, Object> whIoMap = CollectionUtils.isNotEmpty((Collection)invIoRpcDTOS) ? invIoRpcDTOS.stream().collect(Collectors.groupingBy(InvIoRpcDTO::getWhId)) : new HashMap();
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    for (Long whId : whIds) {
                        List itemIoList = (List)whIoMap.get(whId);
                        if (CollectionUtils.isEmpty((Collection)itemIoList)) {
                            this.extractedStStockDo(whId, itemBusinessRpcDTOS, ouId, ouRpcSimpleDTO, whMap, stockCalcDOs2, stId, calcMap);
                            continue;
                        }
                        this.extractedStStock2(whId, itemIoList, itemBusinessRpcDTOS, ouId, ouRpcSimpleDTO, whMap, stockCalcDOs, days, stId, calcMap);
                    }
                }, (Executor)this.executor);
                stockCalcUpdateParams.add(calcUpdateParam);
                futures[i] = future;
                continue;
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\uff0c" + ExceptionUtils.getStackTrace((Throwable)e));
                calcUpdateParam.setCalcuStatus("FAIL");
                calcUpdateParam.setStIds(List.of(stId));
                calcUpdateParam.setCalcuMsg(ExceptionUtils.getStackTrace((Throwable)e));
                stockCalcUpdateParams.add(calcUpdateParam);
            }
        }
        try {
            ArrayList<ScpPredictStStockDO> distinctStockCalcDOs;
            List<String> businessIds;
            CompletableFuture.allOf(futures).get();
            if (CollectionUtils.isNotEmpty(stockCalcDOs2)) {
                List<Long> stIds = stockCalcDOs2.stream().map(ScpPredictStStockDO::getStId).distinct().collect(Collectors.toList());
                businessIds = stockCalcDOs2.stream().map(ScpPredictStStockDO::getBusinessId).distinct().collect(Collectors.toList());
                this.scpPredictStStockRepoProc.deleteAllByBusinessIdAndStId(businessIds, stIds);
                distinctStockCalcDOs = new ArrayList<ScpPredictStStockDO>(stockCalcDOs2.stream().collect(Collectors.toMap(ScpPredictStStockDO::getBusinessId, stock -> stock, (existing, replacement) -> existing)).values());
                this.scpPredictStStockRepo.saveAll(distinctStockCalcDOs);
            }
            if (CollectionUtils.isNotEmpty(stockCalcDOs)) {
                List<Long> stIds = stockCalcDOs.stream().map(ScpPredictStStockDO::getStId).distinct().collect(Collectors.toList());
                businessIds = stockCalcDOs.stream().map(ScpPredictStStockDO::getBusinessId).distinct().collect(Collectors.toList());
                this.scpPredictStStockRepoProc.deleteAllByBusinessIdAndStId(businessIds, stIds);
                distinctStockCalcDOs = new ArrayList<ScpPredictStStockDO>(stockCalcDOs.stream().collect(Collectors.toMap(ScpPredictStStockDO::getBusinessId, stock -> stock, (existing, replacement) -> existing)).values());
                this.scpPredictStStockRepo.saveAll(distinctStockCalcDOs);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            calcUpdateParam2.setCalcuMsg("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\uff0c\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
            log.error("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\uff0c\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
            throw new BusinessException("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\uff0c\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
        }
        catch (Exception e) {
            calcUpdateParam2.setCalcuMsg(e.getMessage());
            log.error("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\u9519\u8bef\u65e5\u5fd7\uff0c" + ExceptionUtils.getStackTrace((Throwable)e));
            throw new BusinessException("\u8ba1\u7b97\u9884\u6d4b\u76ee\u6807\u5e93\u5b58\u5b89\u5168\u5e93\u5b58\u8ba1\u7b97\u6761\u4ef6\u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (CollectionUtils.isNotEmpty(stockCalcUpdateParams)) {
                log.info("stockCalcUpdateParams is:{}", (Object)JSON.toJSONString(stockCalcUpdateParams));
                this.scpPredictStStockCalcRepoProc.updateBatchCalcStatus(stockCalcUpdateParams);
            } else {
                calcUpdateParam2.setCalcuStatus("FAIL");
                calcUpdateParam2.setStIds(stockSyncParamVOS.stream().map(ScpStStockSyncParamVO::getStId).collect(Collectors.toList()));
                this.scpPredictStStockCalcRepoProc.updateStStockCalcStatus(calcUpdateParam2);
            }
        }
    }

    @Override
    public List<ScpPredictStStockDownloadVO> downloadTmplFile(ScpPredictStStockDownLoadParam param) {
        PagingVO<ScpPredictStStockDownloadVO> pagingVO;
        if (param.getStId() == null || StringUtils.isEmpty((CharSequence)param.getPredLotNo())) {
            throw new BusinessException(ApiCode.FAIL, "\u9884\u6d4b\u6279\u6b21ID\u548c\u9884\u6d4b\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getSize() == null || param.getSize() == 10) {
            param.setSize(20000);
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.scpPredictStStockRepoProc.findDownloadPredictStStock(param)).getRecords())) {
            return new ArrayList<ScpPredictStStockDownloadVO>();
        }
        Map uomMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        List itemIds = pagingVO.getRecords().stream().map(ScpPredictStStockDownloadVO::getItemId).distinct().collect(Collectors.toList());
        List simpleItem = this.itemRpcService.findSimpleItem(itemIds);
        Map<Long, ItmItemSimpleRpcDTO> itmItemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, v -> v));
        pagingVO.getRecords().forEach(d -> {
            d.setStIdStr(d.getStId().toString());
            d.setPlanUomName((String)uomMap.get(d.getPlanUom()));
            if (itmItemMap.get(d.getItemId()) != null) {
                d.setItemName(((ItmItemSimpleRpcDTO)itmItemMap.get(d.getItemId())).getItemName());
            }
        });
        return pagingVO.getRecords();
    }

    private List<ScpPredictStStockCalcDO> extractedStStockPredict(ScpPredictStStockCalcParamVO param, Map<Long, OrgOuRpcSimpleDTO> ouMap, Map<Long, List<InvWhRpcSimpleDTO>> ouWhMap, String lotNo) {
        ArrayList scpPredictStStockCalcDOs = new ArrayList();
        param.getOuIds().forEach(d -> {
            ScpPredictStStockCalcDO scpPredictStStockCalcDO = new ScpPredictStStockCalcDO();
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(d);
            if (ouRpcSimpleDTO == null) {
                scpPredictStStockCalcDO.setCalcuStatus("FAIL");
                scpPredictStStockCalcDO.setCalcuMsg(String.format("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u3010%s\u3011\uff0c\u6570\u636e\u4e0d\u5b58\u5728", ouRpcSimpleDTO.getOuName()));
            }
            scpPredictStStockCalcDO.setCreateTime(LocalDateTime.now());
            scpPredictStStockCalcDO.setOuId((Long)d);
            scpPredictStStockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            scpPredictStStockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            scpPredictStStockCalcDO.setPredLotNo(lotNo);
            List whRpcSimpleDTOS = (List)ouWhMap.get(d);
            if (CollectionUtils.isEmpty((Collection)whRpcSimpleDTOS)) {
                scpPredictStStockCalcDO.setCalcuStatus("FAIL");
                scpPredictStStockCalcDO.setCalcuMsg(String.format("\u672a\u67e5\u8be2\u516c\u53f8\u3010%s\u3011\u4e0b\u975e\u95e8\u5e97\u4ed3\u7c7b\u578b\u4ed3\u5e93\uff0c\u8bf7\u914d\u7f6e", ouRpcSimpleDTO.getOuName()));
            } else {
                scpPredictStStockCalcDO.setCalcuStatus("CALCUING");
            }
            scpPredictStStockCalcDOs.add(scpPredictStStockCalcDO);
        });
        long n1 = scpPredictStStockCalcDOs.stream().map(d -> d.getOuId().toString() + d.getPredLotNo()).distinct().count();
        if ((long)scpPredictStStockCalcDOs.size() != n1) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u9884\u6d4b\u6279\u6b21\u4e0d\u80fd\u91cd\u590d,\u7a0d\u540e\u91cd\u8bd5");
        }
        return this.scpPredictStStockCalcRepo.saveAll(scpPredictStStockCalcDOs);
    }

    private void extractedStStock2(Long whId, List<InvIoRpcDTO> itemIoList, List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS, Long ouId, OrgOuRpcSimpleDTO ouRpcSimpleDTO, Map<Long, InvWhRpcSimpleDTO> whMap, List<ScpPredictStStockDO> stockCalcDOs, long days, Long stId, Map<Long, ScpPredictStStockCalcDO> calcMap) {
        Map<Long, List<InvIoRpcDTO>> listMap = itemIoList.stream().collect(Collectors.groupingBy(d -> d.getItemId()));
        for (ItmItemBusinessRpcDTO item : itemBusinessRpcDTOS) {
            ScpPredictStStockDO stockCalcDO = new ScpPredictStStockDO();
            if (calcMap.get(stId) != null) {
                stockCalcDO.setCreateUserId(calcMap.get(stId).getCreateUserId());
                stockCalcDO.setModifyUserId(calcMap.get(stId).getModifyUserId());
                stockCalcDO.setCreator(calcMap.get(stId).getCreator());
                stockCalcDO.setUpdater(calcMap.get(stId).getUpdater());
            }
            stockCalcDO.setStId(stId);
            stockCalcDO.setOuId(ouId);
            stockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            stockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            stockCalcDO.setItemId(item.getId());
            stockCalcDO.setItemCode(item.getItemCode());
            stockCalcDO.setItemCateCode(item.getItemCateCode());
            stockCalcDO.setBrand(item.getBrand());
            stockCalcDO.setWhId(whId);
            stockCalcDO.setWhCode(whMap.get(whId).getWhCode());
            stockCalcDO.setWhName(whMap.get(whId).getWhName());
            stockCalcDO.setPlanUom(item.getUom4());
            stockCalcDO.setBusinessId(ouId.toString() + whId.toString() + item.getId().toString());
            Integer purAheadPeriod = item.getPurAheadPeriod() == null ? 0 : item.getPurAheadPeriod();
            stockCalcDO.setPurAheadPeriod(purAheadPeriod);
            int recvDays = item.getRecvHandlerDays() == null ? 0 : item.getRecvHandlerDays();
            stockCalcDO.setRecvHandlerDays(recvDays);
            BigDecimal safeStockRatio = item.getSafeStockRatio() == null ? BigDecimal.ZERO : item.getSafeStockRatio();
            stockCalcDO.setSafeStockRatio(safeStockRatio);
            int purDelivPeriod = item.getPurDelivPeriod() == null ? 0 : item.getPurDelivPeriod();
            stockCalcDO.setPurDelivPeriod(purDelivPeriod);
            BigDecimal targetStockRatio = item.getTargetStockRatio() == null ? BigDecimal.ZERO : item.getTargetStockRatio();
            stockCalcDO.setTargetStockRatio(targetStockRatio);
            stockCalcDO.setUomRatio(item.getUomRatio4() == null ? BigDecimal.ONE : item.getUomRatio4());
            stockCalcDO.setDecimalPlaces(item.getDecimalPlaces() == null ? 4 : item.getDecimalPlaces());
            stockCalcDOs.add(stockCalcDO);
        }
        List<String> businessIds = stockCalcDOs.stream().map(d -> d.getBusinessId()).distinct().collect(Collectors.toList());
        List<ScpSafetyTargetStockDTO> safetyTargetStockDTOS = this.scpSafetyTargetStockRepoProc.findByBusinessIds(businessIds);
        HashMap stockDTOMap = CollectionUtils.isEmpty(safetyTargetStockDTOS) ? new HashMap() : safetyTargetStockDTOS.stream().collect(Collectors.toMap(d -> d.getBusinessId(), d -> d, (e1, e2) -> e1));
        for (ScpPredictStStockDO stockCalcDO : stockCalcDOs) {
            ScpSafetyTargetStockDTO safetyTargetStockDTO = (ScpSafetyTargetStockDTO)stockDTOMap.get(stockCalcDO.getBusinessId());
            List<InvIoRpcDTO> ioRpcDTOS = listMap.get(stockCalcDO.getItemId());
            if (CollectionUtils.isEmpty(ioRpcDTOS)) {
                stockCalcDO.setPredTargetQty(BigDecimal.ZERO);
                stockCalcDO.setPredSafetyQty(BigDecimal.ZERO);
                if (safetyTargetStockDTO == null) continue;
                stockCalcDO.setSafetyQty(safetyTargetStockDTO.getSafetyQty());
                stockCalcDO.setTargetQty(safetyTargetStockDTO.getTargetQty());
                stockCalcDO.setPredTargetQty(stockCalcDO.getTargetQty());
                stockCalcDO.setPredSafetyQty(stockCalcDO.getSafetyQty());
                continue;
            }
            if (safetyTargetStockDTO != null) {
                stockCalcDO.setSafetyQty(safetyTargetStockDTO.getSafetyQty());
                stockCalcDO.setTargetQty(safetyTargetStockDTO.getTargetQty());
            } else {
                stockCalcDO.setSafetyQty(BigDecimal.ZERO);
                stockCalcDO.setTargetQty(BigDecimal.ZERO);
            }
            InvIoRpcDTO invIoRpcDTO = ioRpcDTOS.get(0);
            stockCalcDO.setIoQty(invIoRpcDTO.getSumQty().negate());
            BigDecimal qty = invIoRpcDTO.getSumQty().divide(stockCalcDO.getUomRatio(), (int)stockCalcDO.getDecimalPlaces(), RoundingMode.HALF_UP);
            BigDecimal divide = qty.divide(BigDecimal.valueOf(days), (int)stockCalcDO.getDecimalPlaces(), RoundingMode.HALF_UP);
            BigDecimal predSafetyQty = divide.multiply(BigDecimal.valueOf(stockCalcDO.getPurAheadPeriod() + stockCalcDO.getRecvHandlerDays())).multiply(stockCalcDO.getSafeStockRatio());
            stockCalcDO.setPredSafetyQty(predSafetyQty.setScale(0, RoundingMode.HALF_UP));
            BigDecimal targetQty = divide.multiply(BigDecimal.valueOf(stockCalcDO.getPurDelivPeriod().intValue())).multiply(stockCalcDO.getTargetStockRatio());
            stockCalcDO.setPredTargetQty(targetQty.setScale(0, RoundingMode.HALF_UP));
        }
    }

    private void extractedStStockDo(Long whId, List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS, Long ouId, OrgOuRpcSimpleDTO ouRpcSimpleDTO, Map<Long, InvWhRpcSimpleDTO> whMap, List<ScpPredictStStockDO> stockCalcDOs2, Long stId, Map<Long, ScpPredictStStockCalcDO> calcMap) {
        for (ItmItemBusinessRpcDTO item : itemBusinessRpcDTOS) {
            ScpPredictStStockDO stockCalcDO = new ScpPredictStStockDO();
            stockCalcDO.setStId(stId);
            stockCalcDO.setOuId(ouId);
            stockCalcDO.setOuCode(ouRpcSimpleDTO.getOuCode());
            stockCalcDO.setOuName(ouRpcSimpleDTO.getOuName());
            stockCalcDO.setItemId(item.getId());
            stockCalcDO.setItemCode(item.getItemCode());
            stockCalcDO.setItemCateCode(item.getItemCateCode());
            stockCalcDO.setBrand(item.getBrand());
            stockCalcDO.setWhId(whId);
            stockCalcDO.setWhCode(whMap.get(whId).getWhCode());
            stockCalcDO.setWhName(whMap.get(whId).getWhName());
            stockCalcDO.setPlanUom(item.getUom4());
            stockCalcDO.setUomRatio(item.getUomRatio4() == null ? BigDecimal.ONE : item.getUomRatio4());
            stockCalcDO.setDecimalPlaces(item.getDecimalPlaces() == null ? 4 : item.getDecimalPlaces());
            stockCalcDO.setBusinessId(ouId.toString() + whId.toString() + item.getId().toString());
            stockCalcDO.setIoQty(BigDecimal.ZERO);
            if (calcMap.get(stId) != null) {
                stockCalcDO.setCreateUserId(calcMap.get(stId).getCreateUserId());
                stockCalcDO.setModifyUserId(calcMap.get(stId).getModifyUserId());
                stockCalcDO.setUpdater(calcMap.get(stId).getUpdater());
                stockCalcDO.setCreator(calcMap.get(stId).getCreator());
            }
            stockCalcDOs2.add(stockCalcDO);
        }
        List<String> keys = stockCalcDOs2.stream().map(ScpPredictStStockDO::getBusinessId).distinct().collect(Collectors.toList());
        List<ScpSafetyTargetStockDTO> byBusinessIds = this.scpSafetyTargetStockRepoProc.findByBusinessIds(keys);
        HashMap stockDTOMap = CollectionUtils.isEmpty(byBusinessIds) ? new HashMap() : byBusinessIds.stream().collect(Collectors.toMap(d -> d.getBusinessId(), d -> d, (e1, e2) -> e1));
        for (ScpPredictStStockDO stockCalcDO : stockCalcDOs2) {
            if (stockDTOMap.get(stockCalcDO.getBusinessId()) != null) {
                stockCalcDO.setSafetyQty(((ScpSafetyTargetStockDTO)stockDTOMap.get(stockCalcDO.getBusinessId())).getSafetyQty());
                stockCalcDO.setTargetQty(((ScpSafetyTargetStockDTO)stockDTOMap.get(stockCalcDO.getBusinessId())).getTargetQty());
                stockCalcDO.setPlanUom(((ScpSafetyTargetStockDTO)stockDTOMap.get(stockCalcDO.getBusinessId())).getPlanUom());
                stockCalcDO.setPredSafetyQty(stockCalcDO.getSafetyQty());
                stockCalcDO.setPredTargetQty(stockCalcDO.getTargetQty());
                continue;
            }
            stockCalcDO.setSafetyQty(BigDecimal.ZERO);
            stockCalcDO.setTargetQty(BigDecimal.ZERO);
            stockCalcDO.setPredSafetyQty(BigDecimal.ZERO);
            stockCalcDO.setPredTargetQty(BigDecimal.ZERO);
        }
    }

    public ScpPredictStStockCalcServiceImpl(ScpPredictStStockCalcRepoProc scpPredictStStockCalcRepoProc, ScpPredictStStockCalcRepo scpPredictStStockCalcRepo, ScpPredictStStockRepoProc scpPredictStStockRepoProc, ScpPredictStStockRepo scpPredictStStockRepo, TaskExecutor executor, InvWhProvider invWhProvider, OrgOuRpcService orgOuRpcService, ItmItemRpcService itemRpcService, InvIoProvider invIoProvider, ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc, RmiSysUserRpcService rmiSysUserRpcService, UdcProvider udcProvider) {
        this.scpPredictStStockCalcRepoProc = scpPredictStStockCalcRepoProc;
        this.scpPredictStStockCalcRepo = scpPredictStStockCalcRepo;
        this.scpPredictStStockRepoProc = scpPredictStStockRepoProc;
        this.scpPredictStStockRepo = scpPredictStStockRepo;
        this.executor = executor;
        this.invWhProvider = invWhProvider;
        this.orgOuRpcService = orgOuRpcService;
        this.itemRpcService = itemRpcService;
        this.invIoProvider = invIoProvider;
        this.scpSafetyTargetStockRepoProc = scpSafetyTargetStockRepoProc;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.udcProvider = udcProvider;
    }
}

