/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.out.service;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.comm.service.ComPaymentTermProviderService;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRateRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitescloud.cloudt.system.service.SysUserService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.scp.application.out.service.SystemDubboService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SystemDubboServiceImpl
implements SystemDubboService {
    private static final Logger log = LoggerFactory.getLogger(SystemDubboServiceImpl.class);
    private final SeqNumProvider sysNumberRuleService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final UdcProvider udcProvider;
    private final SysCurrencyRpcService currencyRpcService;
    private final SysTaxRateRpcService taxRateRpcService;
    private final SysCurrencyRateRpcService currencyRateRpcService;
    private final SysAreaRpcService areaRpcService;
    private final SysUserRpcService sysUserRpcService;
    private final ComPaymentTermProviderService comPaymentTermService;
    private final SysUserService sysUserService;
    private final UserRpcService userRpcService;
    private final EmployeeRpcService employeeRpcService;
    private final SysCacheSettingRpcService sysCacheSettingRpcService;

    @Override
    public String generateCode(String ruleCode, List<String> runtimeValues) {
        String code = this.sysNumberRuleService.generateCode("yst-purc", ruleCode, runtimeValues);
        if (Objects.isNull(code)) {
            log.error("\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
        }
        return code;
    }

    @Override
    public List<String> generateCode(String ruleCode, List<String> runtimeValues, Integer num) {
        List codes = this.sysNumberRuleService.generateCode("yst-purc", ruleCode, runtimeValues, num);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)codes)) {
            log.error("\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
        }
        return codes;
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouId);
        try {
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            ArrayList newStr = new ArrayList();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)customParams)) {
                String[] sp = customParams.split(";");
                Collections.addAll(newStr, sp);
            }
            param.setFlowRoleCodes(newStr);
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            return this.udcProvider.getValueMapByUdcCode(domain, udc);
        }
        catch (Exception e) {
            log.error("sysUdcGetCodeMap error:", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    @Override
    public SysUserDTO sysUserCurrent() {
        try {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            if (userDetails == null) {
                return null;
            }
            SysUserDTO sysUserDTO = userDetails.getUser();
            if (sysUserDTO == null) {
                return null;
            }
            return sysUserDTO;
        }
        catch (Exception e) {
            log.error("sysUserCurrent error:", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SysUserRpcDTO> findUserByUserIds(List<Long> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        try {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setUserIds(ids);
            List sysUserRpcDTOList = this.sysUserRpcService.findUserRpcDtoByParam(param);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)sysUserRpcDTOList)) {
                return Collections.EMPTY_LIST;
            }
            return sysUserRpcDTOList;
        }
        catch (Exception e) {
            log.error("findUserByUserIds error:", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public Optional<SysUserRpcDTO> findUserByUserId(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        try {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setUserIds(Collections.singletonList(id));
            List sysUserRpcDTOList = this.sysUserRpcService.findUserRpcDtoByParam(param);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)sysUserRpcDTOList)) {
                return Optional.empty();
            }
            return Optional.of((SysUserRpcDTO)sysUserRpcDTOList.get(0));
        }
        catch (Exception e) {
            log.error("findUserByUserId error:", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public List<SysUserBasicDTO> findUserByUserIdBatch(Set<Long> ids) {
        log.info("findUserByUserIdBatch params:{}", (Object)JSON.toJSONString(ids));
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        try {
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setUserIds(ids);
            ApiResult apiResult = this.userRpcService.queryUser(userQueryDTO);
            log.info("findUserByUserIdBatch\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            if (apiResult.isSuccess()) {
                return (List)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7cfb\u7edf\u57df\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
        }
        catch (Exception e) {
            log.error("findUserByUserIdBatch error:", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List<ComPaymentTermRespVO> findPaymentCodeBatch(List<String> paymentTermCodes) {
        log.info("findPaymentCodeBatch params:{}", (Object)JSON.toJSONString(paymentTermCodes));
        if (org.springframework.util.CollectionUtils.isEmpty(paymentTermCodes)) {
            return Lists.newArrayList();
        }
        try {
            List list = this.comPaymentTermService.findCodeBatch(paymentTermCodes);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("findPaymentCodeBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<ComPaymentTermRespVO> findPaymentByCode(String paymentTermCode) {
        log.info("findPaymentByCode param:{}", (Object)paymentTermCode);
        if (StringUtils.isEmpty((Object)paymentTermCode)) {
            return Optional.empty();
        }
        try {
            ComPaymentTermRespVO comPaymentTermRespVO = this.comPaymentTermService.getCodeOne(paymentTermCode);
            if (Objects.nonNull(comPaymentTermRespVO)) {
                return Optional.of(comPaymentTermRespVO);
            }
        }
        catch (Exception e) {
            log.error("findPaymentByCode error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<ComPaymentTermRespVO> findAllPayment() {
        log.info("findAllPayment");
        try {
            List paymentTermRespVOS = this.comPaymentTermService.list();
            if (Objects.nonNull(paymentTermRespVOS)) {
                return paymentTermRespVOS;
            }
        }
        catch (Exception e) {
            log.error("findAllPayment error:", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<SysCurrencyRespDTO> findCurrByCodes(List<String> currCodes) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u57df-\u6839\u636e\u8d27\u5e01\u7f16\u53f7\u96c6\u5408\u83b7\u53d6\u8d27\u5e01\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), currCodes);
        if (org.springframework.util.CollectionUtils.isEmpty(currCodes)) {
            return Lists.newArrayList();
        }
        try {
            return (List)this.currencyRpcService.listByCodes(new HashSet<String>(currCodes)).getData();
        }
        catch (Exception e) {
            log.error("findCurrByCodes error:", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public List<SysCurrencyRespDTO> findAllCurrency() {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u57df-\u83b7\u53d6\u6240\u6709\u8d27\u5e01\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
        try {
            ApiResult currencyResult = this.currencyRpcService.queryList(new SysCurrencyQueryDTO());
            if (!currencyResult.isFailed()) {
                return (List)currencyResult.getData();
            }
            log.error("findAllCurrency error: {}", (Object)currencyResult.getErrorMsg());
        }
        catch (Exception e) {
            log.error("findAllCurrency error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<SysCurrencyRespDTO> findCurrByCode(String currCode) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u6839\u636e\u8d27\u5e01\u7f16\u53f7\u83b7\u53d6\u8d27\u5e01\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)currCode);
        if (StringUtils.isEmpty((Object)currCode)) {
            return Optional.empty();
        }
        try {
            SysCurrencyRespDTO comCurrRespVO = (SysCurrencyRespDTO)this.currencyRpcService.getByCode(currCode).getData();
            log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u8d27\u5e01\u7f16\u53f7\u83b7\u53d6\u8d27\u5e01\u4fe1\u606f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)comCurrRespVO);
            if (Objects.nonNull(comCurrRespVO)) {
                return Optional.of(comCurrRespVO);
            }
        }
        catch (Exception e) {
            log.error("findCurrByCode error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<SysTaxRateRespDTO> findTaxRateBytaxRateNoList(List<String> taxRateNos) {
        log.info("findTaxRateBytaxRateNoList params:{}", (Object)JSON.toJSONString(taxRateNos));
        if (org.springframework.util.CollectionUtils.isEmpty(taxRateNos)) {
            return Lists.newArrayList();
        }
        SysTaxRateQueryDTO queryDTO = new SysTaxRateQueryDTO();
        queryDTO.setTaxRateNos(new HashSet<String>(taxRateNos));
        try {
            List comTaxRateVos = (List)this.taxRateRpcService.queryList(queryDTO).getData();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)comTaxRateVos)) {
                return comTaxRateVos;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SysTaxRateRespDTO> findAllTaxRate() {
        log.info("findAllTaxRate");
        SysTaxRateQueryDTO queryDTO = new SysTaxRateQueryDTO();
        try {
            List comTaxRateVos = (List)this.taxRateRpcService.queryList(queryDTO).getData();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)comTaxRateVos)) {
                return comTaxRateVos;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SysUserVO> sysUserGetByIds(List<Long> ids) {
        try {
            return this.sysUserService.getByIds(ids);
        }
        catch (Exception e) {
            log.error("sysUserGetByIds error:", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public List<SysEmployeeBasicDTO> getEmpByIds(Set<Long> empIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(empIds)) {
            return Lists.newArrayList();
        }
        EmployeeQueryDTO param = new EmployeeQueryDTO();
        param.setIds(empIds);
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6279\u91cf\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)LocalDateTime.now());
        ApiResult apiResult = this.employeeRpcService.queryList(param);
        if (apiResult.isSuccess()) {
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6279\u91cf\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)apiResult), (Object)LocalDateTime.now());
            return (List)apiResult.getData();
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff1a" + apiResult.getMsg());
    }

    @Override
    public SysEmployeeBasicDTO getEmpByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            return null;
        }
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6839\u636e\u7528\u6237id\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)userId), (Object)LocalDateTime.now());
        ApiResult apiResult = this.employeeRpcService.getByUserId(userId);
        if (apiResult.isSuccess()) {
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6839\u636e\u7528\u6237id\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)apiResult), (Object)LocalDateTime.now());
            return (SysEmployeeBasicDTO)apiResult.getData();
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff1a" + apiResult.getMsg());
    }

    @Override
    public List<EmployeePageRespDTO> queryEmpByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            return Collections.emptyList();
        }
        EmployeePageQueryDTO param = new EmployeePageQueryDTO();
        param.setIds(Collections.singleton(userId));
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6839\u636e\u7528\u6237id\u5206\u9875\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)userId), (Object)LocalDateTime.now());
        ApiResult apiResult = this.employeeRpcService.queryByPage(param);
        if (apiResult.isSuccess() && apiResult.getData() != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)((PagingVO)apiResult.getData()).getRecords())) {
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df\u6839\u636e\u7528\u6237id\u5206\u9875\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}, \u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)apiResult), (Object)LocalDateTime.now());
            return ((PagingVO)apiResult.getData()).getRecords();
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff1a" + apiResult.getMsg());
    }

    @Override
    public Optional<SysTaxRateRespDTO> findTaxRateByTaxRateNo(String taxRateNo) {
        log.info("findTaxRateByTaxRateNo param:{}", (Object)taxRateNo);
        try {
            if (StringUtils.isEmpty((Object)taxRateNo)) {
                return Optional.empty();
            }
            SysTaxRateRespDTO comTaxRateRespVO = (SysTaxRateRespDTO)this.taxRateRpcService.getByTaxRateNo(taxRateNo).getData();
            if (Objects.nonNull(comTaxRateRespVO)) {
                return Optional.of(comTaxRateRespVO);
            }
        }
        catch (Exception e) {
            log.error("findTaxRateByTaxRateNo error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<SysAreaRespDTO> findAreaByCodes(List<String> areaCodes) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u533a\u57df\u7f16\u53f7\u96c6\u5408\u83b7\u53d6\u533a\u57df\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), areaCodes);
        if (org.springframework.util.CollectionUtils.isEmpty(areaCodes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            return (List)this.areaRpcService.listByAreaCodes(new HashSet<String>(areaCodes)).getData();
        }
        catch (Exception e) {
            log.error("findAreaByCodes error:", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List<SysAreaRespDTO> findAllArea() {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u83b7\u53d6\u5168\u90e8\u533a\u57df\u4fe1\u606f\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now());
        try {
            List areaList = (List)this.areaRpcService.queryList(new SysAreaQueryDTO()).getData();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)areaList)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f");
            }
            return areaList;
        }
        catch (Exception e) {
            log.error("findAreaByCodes error:", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        log.info("findAllEmpsByIdIn params:{}", (Object)JSON.toJSONString(calcEmpIds));
        try {
            if (calcEmpIds.isEmpty()) {
                return Collections.emptyList();
            }
            List sysUserVOList = this.sysUserService.getByIds(calcEmpIds);
            if (!CollectionUtils.isEmpty((Collection)sysUserVOList)) {
                return sysUserVOList;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        log.info("findPaymentCodeBatch param:{}", (Object)JSON.toJSONString(paymentTermCodes));
        if (org.springframework.util.CollectionUtils.isEmpty(paymentTermCodes)) {
            return Lists.newArrayList();
        }
        try {
            List list = this.comPaymentTermService.findCodeBatch(paymentTermCodes);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("findPaymentCodeBatch error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u521b\u5efa\u7528\u6237\u8d26\u53f7\u65b0\u65b9\u6cd5\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        try {
            ApiResult apiResult = this.sysUserRpcService.sysUserAccountCreate(param);
            log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u521b\u5efa\u7528\u6237\u8d26\u53f7\u65b0\u65b9\u6cd5\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)apiResult);
            return apiResult;
        }
        catch (Exception e) {
            log.error("sysUserAccountCreate error:", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @Override
    public SysSettingVO findSysSetting(String settingNo) {
        log.info("\u8c03\u7528\u7cfb\u7edf\u57df-\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)settingNo);
        try {
            SysSettingVO sysSettingVO = this.sysCacheSettingRpcService.oneByNo(settingNo);
            return sysSettingVO;
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df-\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public SystemDubboServiceImpl(SeqNumProvider sysNumberRuleService, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, UdcProvider udcProvider, SysCurrencyRpcService currencyRpcService, SysTaxRateRpcService taxRateRpcService, SysCurrencyRateRpcService currencyRateRpcService, SysAreaRpcService areaRpcService, SysUserRpcService sysUserRpcService, ComPaymentTermProviderService comPaymentTermService, SysUserService sysUserService, UserRpcService userRpcService, EmployeeRpcService employeeRpcService, SysCacheSettingRpcService sysCacheSettingRpcService) {
        this.sysNumberRuleService = sysNumberRuleService;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.udcProvider = udcProvider;
        this.currencyRpcService = currencyRpcService;
        this.taxRateRpcService = taxRateRpcService;
        this.currencyRateRpcService = currencyRateRpcService;
        this.areaRpcService = areaRpcService;
        this.sysUserRpcService = sysUserRpcService;
        this.comPaymentTermService = comPaymentTermService;
        this.sysUserService = sysUserService;
        this.userRpcService = userRpcService;
        this.employeeRpcService = employeeRpcService;
        this.sysCacheSettingRpcService = sysCacheSettingRpcService;
    }
}

