/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.UserConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    @Autowired
    private UserRpcService sysUserService;
    private static final UserConvert USER_CONVERT = UserConvert.INSTANCE;

    public static Long currentUserId() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
        if (ObjectUtil.isEmpty((Object)currentUserDTO) || currentUserDTO.getUserId() == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        return currentUserDTO.getUserId();
    }

    public static CurrentUserDTO currentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        CurrentUserDTO user = USER_CONVERT.convert(userDetails);
        user.setDetail(USER_CONVERT.convert(userDetails.getUser()));
        user.setUserId(userDetails.getUser().getId());
        return user;
    }
}

