/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDListParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class ScpDemandOrderDRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private final QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
    private static final QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;
    private final QBean<ScpDemandOrderDDTO> itemList;

    public List<ScpDemandOrderDDTO> findByMasId(Long masId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemList).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.masId.eq((Object)masId));
        return jpaQuery.fetch();
    }

    public long deleteByIds(List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.scpDemandOrderDDO.id.in(ids));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.scpDemandOrderDDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public void updatePlanQtyAndAmtById(Long id, BigDecimal planQty) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set(this.scpDemandOrderDDO.planQuantity, (Object)planQty).set((Path)this.scpDemandOrderDDO.isCalculated, (Object)Boolean.TRUE).set(this.scpDemandOrderDDO.planAmt, (Expression)this.scpDemandOrderDDO.price.multiply((Number)planQty)).where(new Predicate[]{this.scpDemandOrderDDO.id.eq((Object)id)}).execute();
    }

    public void updateAllocQtyById(Long id, BigDecimal qty) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set(this.scpDemandOrderDDO.allocationQuantity, (Object)qty).where(new Predicate[]{this.scpDemandOrderDDO.id.eq((Object)id)}).execute();
    }

    public void updateErrorMsgById(Long dId, String errorMsg) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set((Path)this.scpDemandOrderDDO.syncMsg, (Object)errorMsg).set((Path)this.scpDemandOrderDDO.isPushed, (Object)false).where(new Predicate[]{this.scpDemandOrderDDO.id.eq((Object)dId)}).execute();
    }

    public void updateSrcDocInfoById(Long id, Long srcDocId, String srcDocNo, String srcLineNO, String docCls) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set(this.scpDemandOrderDDO.srcDocId, (Object)srcDocId).set((Path)this.scpDemandOrderDDO.srcDocNo, (Object)srcDocNo).set((Path)this.scpDemandOrderDDO.srcDocLineNo, (Object)srcLineNO).set((Path)this.scpDemandOrderDDO.srcDocCls, (Object)docCls).where(new Predicate[]{this.scpDemandOrderDDO.id.eq((Object)id)}).execute();
    }

    public void clearSrcDocInfo(Long docId) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).setNull(this.scpDemandOrderDDO.srcDocId).setNull((Path)this.scpDemandOrderDDO.srcDocNo).setNull((Path)this.scpDemandOrderDDO.srcDocCls).setNull((Path)this.scpDemandOrderDDO.srcDocLineNo).setNull(this.scpDemandOrderDDO.allocationQuantity).where(new Predicate[]{this.scpDemandOrderDDO.srcDocId.eq((Object)docId)}).execute();
    }

    public void resetSrcDocQuantity(Long dId, BigDecimal qty) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set(this.scpDemandOrderDDO.quantity, (Expression)this.scpDemandOrderDDO.quantity.subtract((Number)qty)).where(new Predicate[]{this.scpDemandOrderDDO.id.eq((Object)dId)}).execute();
    }

    public Map<Long, Long> getDemandSumItem(List<Long> demandIds) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        String username = currentUserDTO.getDetail().getUsername();
        JPAQuery subQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpDemandOrderDRepoProc.scpsmanAuthorityDO.id).distinct()).from((EntityPath)scpsmanAuthorityDO)).leftJoin((EntityPath)scpsmanInfoDO)).on((Predicate)ScpDemandOrderDRepoProc.scpsmanInfoDO.scpsmanNo.eq((Expression)ScpDemandOrderDRepoProc.scpsmanAuthorityDO.scpsmanNo))).where((Predicate)ScpDemandOrderDRepoProc.scpsmanAuthorityDO.enableStatus.eq(Boolean.TRUE).and((Predicate)ScpDemandOrderDRepoProc.scpsmanInfoDO.loginAccount.eq((Object)username)));
        List authIds = subQuery.fetch();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDO.demandId, this.scpDemandOrderDDO.id.count().as("count")})).from((EntityPath)this.scpDemandOrderDO)).leftJoin((EntityPath)this.scpDemandOrderDDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId))).leftJoin((EntityPath)scpsmanAuthorityDDO)).on((Predicate)this.scpDemandOrderDO.demandWhStCode.eq((Expression)ScpDemandOrderDRepoProc.scpsmanAuthorityDDO.stWhCode));
        jpaQuery.where((Predicate)this.scpDemandOrderDO.demandId.in(demandIds));
        jpaQuery.where((Predicate)ScpDemandOrderDRepoProc.scpsmanAuthorityDDO.masId.in((Collection)authIds));
        jpaQuery.groupBy(this.scpDemandOrderDO.demandId);
        List orderDRespVOS = jpaQuery.fetch();
        if (orderDRespVOS.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        return orderDRespVOS.stream().collect(Collectors.toMap(ScpDemandOrderRespVO::getDemandId, ScpDemandOrderRespVO::getCount));
    }

    public long deleteBySourceIds(List<Long> sourceIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.scpDemandOrderDDO.sourceId.in(sourceIds));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.scpDemandOrderDDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public BigDecimal findPushedItemMasId(Long masId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderDDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.lineNo, this.scpDemandOrderDDO.id})).from((EntityPath)this.scpDemandOrderDDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.masId.in((Object[])new Long[]{masId}));
        ((JPAQuery)jpaQuery.orderBy(this.scpDemandOrderDDO.lineNo.asc())).limit(1L);
        ScpDemandOrderDDTO scpDemandOrderDDTO = (ScpDemandOrderDDTO)jpaQuery.fetchOne();
        return scpDemandOrderDDTO != null ? scpDemandOrderDDTO.getLineNo() : BigDecimal.ZERO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long deleteByMasIdAndIsPushed(Long masId, Boolean isPushed) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.scpDemandOrderDDO.masId.eq((Object)masId));
        predicates.add(this.scpDemandOrderDDO.isPushed.eq(isPushed));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.scpDemandOrderDDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public List<Long> getMasIdByDId(List<Long> dIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scpDemandOrderDDO.masId).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.id.in(dIds))).fetch();
    }

    public List<ScpDemandOrderPayInfoRespVO> findPayInfo(Long masId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderPayInfoRespVO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.planAmt.sum().as("amt")})).from((EntityPath)this.scpDemandOrderDDO);
        jpaQuery.where((Predicate)this.scpDemandOrderDDO.masId.eq((Object)masId));
        jpaQuery.groupBy(new Expression[]{this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.saleOuName, this.scpDemandOrderDDO.saleOuCode, this.scpDemandOrderDDO.payStatus});
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderDDO> findByMasIdAndIsPushed(Long masId, Boolean isPushed) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.scpDemandOrderDDO).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.masId.eq((Object)masId).and((Predicate)this.scpDemandOrderDDO.isPushed.eq(isPushed)))).fetch();
    }

    public void initAllocQuantity(Long masId) {
        this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set(this.scpDemandOrderDDO.allocationQuantity, this.scpDemandOrderDDO.planQuantity).where(new Predicate[]{this.scpDemandOrderDDO.masId.eq((Object)masId)}).execute();
    }

    public LocalDateTime findDocCreateTimeBySrcDocId(Long srcDocId) {
        return (LocalDateTime)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.scpDemandOrderDO.createTime).from((EntityPath)this.scpDemandOrderDO)).leftJoin((EntityPath)this.scpDemandOrderDDO)).on((Predicate)this.scpDemandOrderDO.id.eq(this.scpDemandOrderDDO.masId))).where((Predicate)this.scpDemandOrderDDO.srcDocId.eq((Object)srcDocId))).fetchOne();
    }

    public List<ScpDemandOrderRelateDTO> findRelateOrderByMasId(Long masId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderRelateDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.srcDocId, this.scpDemandOrderDDO.srcDocNo, this.scpDemandOrderDDO.srcDocCls, this.scpDemandOrderDDO.payStatus})).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.masId.eq((Object)masId));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderDDTO> findItemListByMasId(List<Long> masIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderDDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.imgUrl})).from((EntityPath)this.scpDemandOrderDDO)).where((Predicate)this.scpDemandOrderDDO.masId.in(masIds));
        return jpaQuery.fetch();
    }

    public void updatePayStatusBySrcDocId(String srcDocNo, String payStatus) {
        JPAUpdateClause jpaQuery = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set((Path)this.scpDemandOrderDDO.payStatus, (Object)payStatus);
        jpaQuery.where(new Predicate[]{this.scpDemandOrderDDO.srcDocNo.eq((Object)srcDocNo)});
        jpaQuery.execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOnlinePayFlagAndPayerNameBySrcDocNo(String srcDocNo, String payerName, Boolean payStatus) {
        JPAUpdateClause jpaQuery = this.jpaQueryFactory.update((EntityPath)this.scpDemandOrderDDO).set((Path)this.scpDemandOrderDDO.payerName, (Object)payerName).set((Path)this.scpDemandOrderDDO.onlinePayFlag, (Object)payStatus);
        jpaQuery.where(new Predicate[]{this.scpDemandOrderDDO.srcDocNo.eq((Object)srcDocNo)});
        jpaQuery.execute();
    }

    private JPAQuery<ScpDemandOrderDDTO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpDemandOrderDDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.masId, this.scpDemandOrderDDO.demandQuantity, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.itemCode, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.itemName})).from((EntityPath)this.scpDemandOrderDDO);
    }

    private Predicate where(ScpDemandOrderDListParamVO query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty(query.getMasIds())) {
            list.add(this.scpDemandOrderDDO.masId.in(query.getMasIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayStatus())) {
            list.add(this.scpDemandOrderDDO.payStatus.eq((Object)query.getPayStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getItemCode())) {
            list.add(this.scpDemandOrderDDO.itemCode.eq((Object)query.getItemCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getItemCodeNe())) {
            list.add(this.scpDemandOrderDDO.itemCode.ne((Object)query.getItemCodeNe()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<ScpDemandOrderDDTO> queryList(ScpDemandOrderDListParamVO scpDemandOrderDParamVO) {
        JPAQuery<ScpDemandOrderDDTO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(scpDemandOrderDParamVO));
        return jpaQuery.fetch();
    }

    public ScpDemandOrderDRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemList = Projections.bean(ScpDemandOrderDDTO.class, (Expression[])new Expression[]{this.scpDemandOrderDDO.id, this.scpDemandOrderDDO.itemId, this.scpDemandOrderDDO.recvQty, this.scpDemandOrderDDO.quantity, this.scpDemandOrderDDO.planQuantity, this.scpDemandOrderDDO.isPushed, this.scpDemandOrderDDO.payStatus, this.scpDemandOrderDDO.freightLineFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

