/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.controller;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.pay.service.RefundsService;
import com.elitesland.scp.pay.vo.RefundParamVO;
import com.tenpay.business.entpay.mse.sdk.api.Refund;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/refund"})
public class RefundsController {
    private static final Logger log = LoggerFactory.getLogger(RefundsController.class);
    private final RefundsService refundsService;

    @ApiOperation(value="\u9000\u6b3e\u7533\u8bf7 - \u5c0f\u7a0b\u5e8f\u8c03\u7528")
    @PostMapping(value={"/create/{paymentId}"})
    public Refund create(@PathVariable(value="paymentId") String paymentId) throws EntpayException {
        log.info("\u9000\u6b3e\u7533\u8bf7\u8bf7\u6c42\u53c2\u6570-\u5c0f\u7a0b\u5e8f\u8c03\u7528\uff1a{}", (Object)paymentId);
        return this.refundsService.refundOrder(paymentId);
    }

    @ApiOperation(value="\u9000\u6b3e\u67e5\u8be2\uff08\u5185\u5355\u53f7\uff09")
    @GetMapping(value={"/retrieve/{refundId}"})
    public Refund retrieve(@PathVariable(value="refundId") String refundId) throws EntpayException {
        log.info("\u9000\u6b3e\u67e5\u8be2(\u5185\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)refundId);
        return Refund.retrieve((String)refundId);
    }

    @ApiOperation(value="\u9000\u6b3e\u67e5\u8be2\uff08\u5916\u5355\u53f7\uff09")
    @GetMapping(value={"/retrieve/out-refund-id/{outRefundId}"})
    public Refund retrieveByOutRefundId(@PathVariable(value="outRefundId") String outRefundId) throws EntpayException {
        log.info("\u9000\u6b3e\u67e5\u8be2(\u5916\u5355\u53f7)\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)outRefundId);
        return Refund.retrieveByOutRefundId((String)outRefundId);
    }

    @ApiOperation(value="\u9000\u6b3e\u7533\u8bf7-\u624b\u52a8")
    @PostMapping(value={"/create/manu"})
    public Refund create(@RequestBody RefundParamVO refundParamVO) throws EntpayException {
        log.info("\u9000\u6b3e\u7533\u8bf7\u8bf7\u6c42\u53c2\u6570-\u624b\u52a8\uff1a{}", (Object)JSONUtil.toJsonStr((Object)refundParamVO));
        return this.refundsService.refundOrderManu(refundParamVO);
    }

    public RefundsController(RefundsService refundsService) {
        this.refundsService = refundsService;
    }
}

