/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.controller;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResultResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payments"})
@Validated
public class LakalaPaymentController {
    private static final Logger log = LoggerFactory.getLogger(LakalaPaymentController.class);
    private final LklPaymentService paymentService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355")
    @PostMapping(value={"/online/lkl-pay"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355", allowRepeatRequest=false)
    public ApiResult<OnlineLklPayOrderResponseVO> createOnlineMPPay(HttpServletRequest request, @RequestBody @Validated OnlineLklPayOrderParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        String clientIP = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        param.setClientIp(clientIP);
        return ApiResult.ok((Object)this.paymentService.createMpPayOnline(param));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u7ed3\u679c")
    @GetMapping(value={"/online/queryResult/{docNo}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u7ed3\u679c", allowRepeatRequest=false)
    public ApiResult<OnlineLklPayOrderResultResponseVO> queryResult(@PathVariable String docNo) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)docNo);
        return ApiResult.ok((Object)this.paymentService.queryResult(docNo));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2")
    @PostMapping(value={"/balance"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2", allowRepeatRequest=false)
    public ApiResult<BalanceResponseVO> queryBalance(@RequestBody @Validated QueryBalanceParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        return ApiResult.ok((Object)this.paymentService.queryBalance(param));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2")
    @PostMapping(value={"/queryAccountDtl"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2", allowRepeatRequest=false)
    public ApiResult<JSONObject> queryAccountDtl(@RequestBody @Validated QueryAccountDtlParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        return ApiResult.ok((Object)this.paymentService.queryAccountDtl(param));
    }

    public LakalaPaymentController(LklPaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

