/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.lakalapay.config.LakalaProperties;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.utils.RSA;
import com.elitesland.scp.lakalapay.utils.TcslPay;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResultResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LklPaymentServiceImpl
implements LklPaymentService {
    private static final Logger log = LoggerFactory.getLogger(LklPaymentServiceImpl.class);
    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;
    private final MessageDelyQueueService messageDelyQueueService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TransactionTemplate transactionTemplate;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TcslPay tcslPay;
    private final LakalaProperties lakalaProperties;
    private final SysThirdApiLogRpcService sysThirdApiLogRpcService;

    @Override
    public OnlineLklPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param) {
        String result = "";
        try {
            String docCls = param.getDocNo().substring(0, 2);
            String docNo = param.getDocNo();
            OnlineLklPayOrderResultResponseVO onlineLklPayOrderResultResponseVO = this.tcslPay.queryResult(docNo);
            if (onlineLklPayOrderResultResponseVO != null && onlineLklPayOrderResultResponseVO.getResultCode().equals("0") && onlineLklPayOrderResultResponseVO.getPayState().equals("success")) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = this.buildPayItems(param, docCls);
            if (onlineLklPayOrderResponseVO != null) {
                OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO2 = onlineLklPayOrderResponseVO;
                return onlineLklPayOrderResponseVO2;
            }
            this.buildPaymentMapParam(param);
            OnlineLklPayOrderResponseVO pay = this.tcslPay.pay(param);
            if (pay == null || pay.getPayUrl() == null) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25");
            }
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey("scp_order_update_pay_status");
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(pay.getTradeNo());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_update_pay_status", (Serializable)updateParamVO);
            this.redisUtils.set("SCP_ONLINE_PAY:" + docNo, (Object)JSONUtil.toJsonStr((Object)pay), 30L, TimeUnit.MINUTES);
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime expireTime = now.plusMinutes(30L);
            Duration duration = Duration.between(now, expireTime);
            this.messageDelyQueueService.resettingOrderExpireTime("SCP_ONLINE_PAY:" + docNo, duration.toMillis());
            result = JSONObject.toJSONString((Object)pay);
            OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO3 = pay;
            return onlineLklPayOrderResponseVO3;
        }
        catch (Exception e) {
            result = e.getMessage();
            throw new BusinessException("\u62c9\u5361\u62c9\u652f\u4ed8\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            ThirdApiLogDTO thirdApiLogDTO = new ThirdApiLogDTO();
            thirdApiLogDTO.setAppCode("yst-nxg-scp");
            thirdApiLogDTO.setReqTime(LocalDateTime.now());
            thirdApiLogDTO.setThirdApp("LKL");
            thirdApiLogDTO.setReqBody(JSONObject.toJSONString((Object)param));
            thirdApiLogDTO.setRespBody(result);
            thirdApiLogDTO.setReqMethod(HttpMethod.POST);
            thirdApiLogDTO.setServer(Boolean.valueOf(true));
            thirdApiLogDTO.setUri("/payments/online/lkl-pay");
            thirdApiLogDTO.setRestful(Boolean.valueOf(true));
            thirdApiLogDTO.setReqSuccess(Boolean.valueOf(true));
            thirdApiLogDTO.setRespSuccess(Boolean.valueOf(true));
            thirdApiLogDTO.setBusinessKey(param.getDocNo());
            thirdApiLogDTO.setNeedRetry(Boolean.valueOf(false));
            ThirdApiRetryParamDTO thirdApiRetryParamDTO = new ThirdApiRetryParamDTO();
            thirdApiRetryParamDTO.setUri("/payments/online/lkl-pay");
            thirdApiRetryParamDTO.setReqMethod(HttpMethod.POST);
            thirdApiRetryParamDTO.setReqBody(JSONObject.toJSONString((Object)param));
            thirdApiLogDTO.setRetryParam(thirdApiRetryParamDTO);
            thirdApiLogDTO.setBusinessType("LKL_PAY");
            this.sysThirdApiLogRpcService.saveLog(thirdApiLogDTO);
        }
    }

    @Override
    public OnlineLklPayOrderResultResponseVO queryResult(String docNo) {
        try {
            return this.tcslPay.queryResult(docNo);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        try {
            OrgStoreDetailRpcDTO byCode = this.orgStoreRpcService.getByCode(param.getStoreCode());
            log.info("\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)byCode));
            if (byCode == null) {
                throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u4e0d\u5b58\u5728");
            }
            List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
            if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
                BalanceResponseVO balanceResponseVO = new BalanceResponseVO();
                balanceResponseVO.setBalance("0");
                balanceResponseVO.setUsableBalance("0");
                balanceResponseVO.setIsValid(false);
                return balanceResponseVO;
            }
            Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
            if (orgBankRpcDTO.isEmpty()) {
                BalanceResponseVO balanceResponseVO = new BalanceResponseVO();
                balanceResponseVO.setBalance("0");
                balanceResponseVO.setUsableBalance("0");
                balanceResponseVO.setIsValid(false);
                return balanceResponseVO;
            }
            OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
            param.setAccountNo(orgBankRpcDTO1.getCardNo());
            param.setBrandId(10L);
            return this.tcslPay.queryBalance(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public JSONObject queryAccountDtl(QueryAccountDtlParamVO param) {
        try {
            List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
            if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
                throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u94f6\u884c\u4fe1\u606f");
            }
            Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
            if (orgBankRpcDTO.isEmpty()) {
                throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u62c9\u5361\u62c9\u94f6\u884c\u4fe1\u606f");
            }
            OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
            param.setAccountNo(orgBankRpcDTO1.getCardNo());
            param.setBrandId(10L);
            return this.tcslPay.queryAccountDtl(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    private OnlineLklPayOrderResponseVO buildPayItems(OnlineLklPayOrderParamVO param, String docCls) {
        OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = new OnlineLklPayOrderResponseVO();
        Object obj = this.redisUtils.get("SCP_ONLINE_PAY:" + param.getDocNo());
        OnlineLklPayOrderParamVO.PayeeInfoVO payeeInfoVO = new OnlineLklPayOrderParamVO.PayeeInfoVO();
        payeeInfoVO.setSubTradeAmount("" + param.getAmt().setScale(2, RoundingMode.HALF_UP));
        List simpleByOuCodes = this.orgOuRpcService.findSimpleByOuCodes(List.of(param.getOuCode()));
        if (simpleByOuCodes == null || simpleByOuCodes.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u9500\u552e\u516c\u53f8\uff1a" + param.getOuCode());
        }
        List ouBank = this.orgOuRpcService.findOuBank(((OrgOuRpcSimpleDTO)simpleByOuCodes.get(0)).getId());
        if (ouBank == null || ouBank.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        Optional<OrgOuBankRpcDTO> in = ouBank.stream().filter(a -> a.getAccType().equals("IN")).findAny();
        if (in.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        OrgOuBankRpcDTO orgOuBankRpcDTO = in.get();
        payeeInfoVO.setPayeeAccountNo(orgOuBankRpcDTO.getBankAcc());
        payeeInfoVO.setPayeeName(orgOuBankRpcDTO.getHolderName());
        payeeInfoVO.setSubOutTradeNo(param.getDocNo());
        param.setPayeeInfo(List.of(payeeInfoVO));
        if ("PO".equals(docCls)) {
            PurPoOnlinePayRpcDTO onlinePayInfo = this.rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                onlineLklPayOrderResponseVO = (OnlineLklPayOrderResponseVO)JSONObject.parseObject((String)((String)obj), OnlineLklPayOrderResponseVO.class);
                return onlineLklPayOrderResponseVO;
            }
        } else {
            InvTroOnlinePayRpcDTO onlinePayInfo = this.rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                onlineLklPayOrderResponseVO = (OnlineLklPayOrderResponseVO)JSONObject.parseObject((String)((String)obj), OnlineLklPayOrderResponseVO.class);
                return onlineLklPayOrderResponseVO;
            }
        }
        return null;
    }

    private void buildPaymentMapParam(OnlineLklPayOrderParamVO param) {
        List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
        if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u94f6\u884c\u4fe1\u606f");
        }
        Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
        if (orgBankRpcDTO.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u62c9\u5361\u62c9\u94f6\u884c\u4fe1\u606f");
        }
        OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
        param.setPayerNo(orgBankRpcDTO1.getCardNo());
        param.setPayerType(orgBankRpcDTO1.getType());
    }

    @Override
    public String paymentNotify(String bytes) throws JSONException {
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)bytes));
        log.info("\u62c9\u5361\u62c9\u82cf\u5546-\u6536\u94f6\u53f0\u652f\u4ed8\u8f6c\u8d26\u7533\u8bf7\u7ed3\u679c\u901a\u77e5,\u901a\u77e5\u5185\u5bb9:{}", (Object)bytes);
        byte[] bytes1 = Base64.decodeBase64((String)bytes);
        Map map = (Map)JSON.parseObject((byte[])bytes1, Map.class, (Feature[])new Feature[0]);
        log.info("\u62c9\u5361\u62c9\u82cf\u5546-\u6536\u94f6\u53f0\u652f\u4ed8\u8f6c\u8d26\u7533\u8bf7\u7ed3\u679c\u901a\u77e5,\u901a\u77e5\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)map));
        String sign = (String)map.get("sign");
        map.remove("sign");
        String localSign = RSA.getSignHmacSHA256(map, this.lakalaProperties.getAppSecret());
        log.info("\u62c9\u5361\u62c9\u82cf\u5546-\u6536\u94f6\u53f0\u652f\u4ed8\u8f6c\u8d26\u7533\u8bf7\u7ed3\u679c\u901a\u77e5,\u9a8c\u7b7e\u7ed3\u679c:{};key:", (Object)localSign, (Object)this.lakalaProperties.getAppSecret());
        if (!sign.equals(localSign)) {
            return "\u7b7e\u540d\u9519\u8bef";
        }
        String data = (String)map.get("data");
        Map result = (Map)JSON.parseObject((String)data, Map.class);
        log.info("\u62c9\u5361\u62c9\u82cf\u5546-\u6536\u94f6\u53f0\u652f\u4ed8\u8f6c\u8d26\u7533\u8bf7\u7ed3\u679c\u901a\u77e5,\u901a\u77e5\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)result));
        String docNo = (String)result.get("outTradeNo");
        String tradeNo = (String)result.get("tradeNo");
        BigDecimal tradeAmount = (BigDecimal)result.get("tradeAmount");
        String paySuccessTime = (String)result.get("paySuccessTime");
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            TenantContextHolder.setCurrentTenant((SysTenantDTO)TenantClient.getSessionTenant());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if ("PO".equals(docNo.substring(0, 2))) {
                PurPoOnlinePayParamDTO purPoOnlinePayParamDTO = new PurPoOnlinePayParamDTO();
                purPoOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                purPoOnlinePayParamDTO.setDocNo(docNo);
                purPoOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paySuccessTime, formatter));
                this.rmiPurRpcService.updateOnlinePay(purPoOnlinePayParamDTO);
            } else {
                InvTroOnlinePayParamDTO invTroOnlinePayParamDTO = new InvTroOnlinePayParamDTO();
                invTroOnlinePayParamDTO.setDocNo(docNo);
                invTroOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paySuccessTime, formatter));
                invTroOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                this.rmiInvStkRpcService.updateOnlinePay(invTroOnlinePayParamDTO);
            }
            String key = "SCP_ONLINE_PAY:" + docNo;
            if (this.redisTemplate.delete((Object)key).booleanValue()) {
                this.messageDelyQueueService.remove("SCP_ONLINE_PAY:" + key);
                this.transactionTemplate.setPropagationBehavior(3);
                this.transactionTemplate.execute(transactionStatus -> {
                    try {
                        this.scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(docNo, ScpUdcEnum.PAY_STATUS_PAYED.getValueCode());
                        return "ok";
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u8981\u8d27\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                        transactionStatus.setRollbackOnly();
                        return "ok";
                    }
                });
                ScpOrderPayMqParam orderSubmitMqParam = new ScpOrderPayMqParam();
                orderSubmitMqParam.setSrcDocNo(docNo);
                orderSubmitMqParam.setFlowNo(tradeNo);
                orderSubmitMqParam.setBusinessKey("scp_order_pay");
                orderSubmitMqParam.setPayDateTime(LocalDateTime.parse(paySuccessTime, formatter));
                BigDecimal amt = tradeAmount.setScale(2, RoundingMode.HALF_UP);
                orderSubmitMqParam.setRealRecAmt(amt);
                orderSubmitMqParam.setType("lkl");
                this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_pay", (Serializable)orderSubmitMqParam);
            } else {
                log.error("\u4e0d\u80fd\u91cd\u590d\u8c03\u7528\u652f\u4ed8\u56de\u8c03");
            }
            return "";
        }, this.lakalaProperties.getTenantCode());
        return this.returnDatastring("success", 1);
    }

    private String returnDatastring(String data, int result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        map.put("result", result);
        return Base64.encodeBase64String((byte[])JSON.toJSONBytes(map, (SerializerFeature[])new SerializerFeature[0]));
    }

    public LklPaymentServiceImpl(NotifyVerifyService notifyVerifyService, RedisWrapper redisWrapper, RedisUtils redisUtils, RmiPurRpcService rmiPurRpcService, RmiInvStkRpcService rmiInvStkRpcService, AccountLinkService accountLinkService, MessageQueueTemplate messageQueueTemplate, ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc, MessageDelyQueueService messageDelyQueueService, OrgStoreRpcService orgStoreRpcService, OrgOuRpcService orgOuRpcService, TenantDataIsolateProvider tenantDataIsolateProvider, TransactionTemplate transactionTemplate, RedisTemplate<Object, Object> redisTemplate, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, TcslPay tcslPay, LakalaProperties lakalaProperties, SysThirdApiLogRpcService sysThirdApiLogRpcService) {
        this.notifyVerifyService = notifyVerifyService;
        this.redisWrapper = redisWrapper;
        this.redisUtils = redisUtils;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.accountLinkService = accountLinkService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
        this.messageDelyQueueService = messageDelyQueueService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.transactionTemplate = transactionTemplate;
        this.redisTemplate = redisTemplate;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.tcslPay = tcslPay;
        this.lakalaProperties = lakalaProperties;
        this.sysThirdApiLogRpcService = sysThirdApiLogRpcService;
    }
}

