/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.boh.StoreAppletHomeVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnTotalVO;
import com.elitesland.scp.application.facade.vo.boh.StoreTodoVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListRespVO;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class StoreAppletServiceImpl
implements StoreAppletService {
    private static final Logger log = LoggerFactory.getLogger(StoreAppletServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ItmItemRpcService itmItemRpcService;
    private final DemandOrderTemplateService demandOrderTemplateService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;

    @Override
    public StoreAppletHomeVO find(Long storeId, LocalDateTime startDate, String demandWhStCode, String type) {
        StoreAppletHomeVO storeAppletHomeVO = new StoreAppletHomeVO();
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setReceiveCount(this.storeReceiveRepoProc.findReceive(storeId, startDate));
            storeAppletHomeVO.setReplyCount(this.scpDemandOrderRepoProc.countUnReply(storeId, startDate));
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setRtnCount(this.storeReceiveRepoProc.findRtn(storeId, startDate));
            storeAppletHomeVO.setOrderCount(this.storeReceiveRepoProc.findOrderCount(storeId, startDate));
            storeAppletHomeVO.setOrderCalendar(this.storeReceiveRepoProc.storeCalendar(storeId));
        }, (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        return storeAppletHomeVO;
    }

    private int templateCount(String demandWhStCode, String type) {
        DemandOrderListParamVO vo = new DemandOrderListParamVO();
        vo.setDemandWhStCode(demandWhStCode);
        vo.setType(type);
        List<DemandOrderListRespVO> list = this.demandOrderTemplateService.list(vo);
        if (CollUtil.isEmpty(list)) {
            return 0;
        }
        return list.size();
    }

    @Override
    public StoreTodoVO todo(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreTodoVO();
        }
        return this.storeReceiveRepoProc.findTodo(param);
    }

    private List<Long> findDocIds(StoreReceivePageParam param) {
        if (StrUtil.isNotBlank((CharSequence)param.getItemName()) || StrUtil.isNotBlank((CharSequence)param.getItemCode()) || StrUtil.isNotBlank((CharSequence)param.getItemKeyword())) {
            List itemIdByCodeName = this.itmItemRpcService.findItemIdByCodeName(param.getItemCode(), param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty((Collection)itemIdByCodeName)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<Long>();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List allLeafCateId = this.itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);
            List<Long> itemIdsByCate = this.storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<Long>();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = this.storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new ArrayList<Long>();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new ArrayList<Long>();
            }
            return param.getIds();
        }
        return null;
    }

    @Override
    public StoreReceiveTotalVO receiveTotal(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreReceiveTotalVO();
        }
        return this.storeReceiveRepoProc.findReceiveTotal(param);
    }

    @Override
    public StoreRtnTotalVO rtnCount(StoreReceivePageParam param) {
        List<Long> docIds = this.findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreRtnTotalVO();
        }
        return this.storeReceiveRepoProc.findRtnTotal(param);
    }

    public StoreAppletServiceImpl(StoreReceiveRepoProc storeReceiveRepoProc, ItmItemRpcService itmItemRpcService, DemandOrderTemplateService demandOrderTemplateService, ScpDemandOrderRepoProc scpDemandOrderRepoProc) {
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.itmItemRpcService = itmItemRpcService;
        this.demandOrderTemplateService = demandOrderTemplateService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
    }
}

