/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.item;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemHotParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.item.ScpCateItemParam;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpCateItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.param.CateItemRpcParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e2d\u53f0-\u54c1\u7c7b\u5546\u54c1"})
@RestController
@RequestMapping(value={"/cate/item"}, produces={"application/json"})
public class CateItemController {
    private static final Logger log = LoggerFactory.getLogger(CateItemController.class);
    private final ScpCateItemService scpCateItemService;

    @PostMapping(value={"/bind"})
    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u7ed1\u5b9a")
    public ApiResult<Void> bind(@RequestBody @Validated ScpCateItemParam cateStoreParam) {
        this.scpCateItemService.bindItem(cateStoreParam);
        return ApiResult.ok();
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u53d6\u6d88\u7ed1\u5b9a")
    public ApiResult<Void> remove(@RequestBody @Validated List<Long> ids) {
        this.scpCateItemService.remove(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u54c1\u7c7b\u67e5\u8be2")
    public ApiResult<List<ScpCateItemDTO>> query(@RequestBody @Validated CateItemRpcParam cateItemRpcParam) {
        return this.scpCateItemService.query(cateItemRpcParam);
    }

    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u662f\u5426\u70ed\u9500")
    @PostMapping(value={"/changeHotFlag"})
    public ApiResult<Object> changeHotFlag(@RequestBody @Validated ScpCateItemHotParamVO paramVO) {
        log.info("[SCP-CATE-ITEM] changeHotFlag paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpCateItemService.changeHotFlag(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u5546\u54c1\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpCateItemRespVO>> page(@RequestBody @Validated ScpCateItemPageParamVO paramVO) {
        log.info("[SCP-CATE-ITEM] page paramVO = {}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpCateItemService.page(paramVO));
    }

    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u6392\u5e8f")
    @GetMapping(value={"/sortNo/{id}/{sorNo}"})
    public ApiResult<ScpDemandOrderRespVO> saveSortNo(@PathVariable Long id, @PathVariable Integer sorNo) {
        log.info("[SCP-CATE-ITEM] saveSortNo, id ={}", (Object)id);
        this.scpCateItemService.saveSortNo(id, sorNo);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u54c1\u7c7b\u5546\u54c1 - \u5546\u54c1\u7ef4\u62a4\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/sku/paging"})
    public ApiResult<PagingVO<ScpCateItemPageVO>> skuPaging(@RequestBody ScpCateItemPageParamVO param) {
        return ApiResult.ok(this.scpCateItemService.skuPage(param));
    }

    public CateItemController(ScpCateItemService scpCateItemService) {
        this.scpCateItemService = scpCateItemService;
    }
}

